/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.lying.grid.AbstractTileGrid;
import com.lying.grid.GridTile;
import java.util.List;
import net.minecraft.class_2350;
import org.joml.Math;

public class GraphTileGrid
extends AbstractTileGrid<GridTile> {
    @Override
    public AbstractTileGrid<GridTile> addToVolume(GridTile from, GridTile to) {
        int minX = Math.min((int)from.x, (int)to.x);
        int maxX = Math.max((int)from.x, (int)to.x);
        int minY = Math.min((int)from.y, (int)to.y);
        int maxY = Math.max((int)from.y, (int)to.y);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                this.addToVolume(new GridTile(x, y));
            }
        }
        return this;
    }

    @Override
    public boolean containsAdjacent(GridTile pos) {
        return this.set.keySet().stream().anyMatch(p2 -> p2.manhattanDistance(pos) == 1);
    }

    @Override
    public void grow(class_2350 direction, int size) {
        this.getBoundaries(List.of(direction)).forEach(p -> {
            for (int i = 0; i < size; ++i) {
                this.addToVolume(p.offset(direction));
            }
        });
    }

    @Override
    public List<GridTile> getBoundaries(List<class_2350> faces) {
        return this.set.keySet().stream().filter(p -> faces.stream().anyMatch(f -> this.isBoundary((GridTile)p, (class_2350)f))).toList();
    }

    public boolean isBoundary(GridTile pos) {
        return class_2350.class_2353.field_11062.method_29716().anyMatch(d -> this.isBoundary(pos, (class_2350)d));
    }

    public boolean isBoundary(GridTile pos, class_2350 side) {
        return !this.contains(pos.offset(side));
    }
}

