/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import java.util.Comparator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_241;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector2i;

public class GridTile {
    public static final int GRID_SIZE = 2;
    public static final GridTile ZERO = new GridTile(0, 0);
    public static final AbstractBox2f BOUNDS = new Box2f(0.0f, 2.0f, 0.0f, 2.0f);
    public static final class_238 BOX = new class_238(0.0, 0.0, 0.0, 2.0, 2.0, 2.0);
    public final int x;
    public final int y;

    public GridTile(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return "GridTile[" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof GridTile && this.manhattanDistance((GridTile)obj) == 0;
    }

    public GridTile copy() {
        return new GridTile(this.x, this.y);
    }

    public static Comparator<GridTile> distSort(GridTile target) {
        return (a, b) -> {
            double bD;
            double aD = a.distance(target);
            return aD < (bD = b.distance(target)) ? -1 : (aD > bD ? 1 : 0);
        };
    }

    public static GridTile median(GridTile ... tiles) {
        float x = 0.0f;
        float y = 0.0f;
        for (GridTile tile : tiles) {
            x += (float)tile.x;
            y += (float)tile.y;
        }
        return GridTile.fromVec(new class_241(x /= (float)tiles.length, y /= (float)tiles.length));
    }

    public static GridTile worldVecToGrid(class_241 vec) {
        return GridTile.fromVec(vec.method_35582(0.0f));
    }

    public static GridTile fromVec(class_241 vec) {
        return new GridTile((int)(vec.field_1343 - vec.field_1343 % 2.0f), (int)(vec.field_1342 - vec.field_1342 % 2.0f));
    }

    public class_241 toVec2f() {
        return new class_241((float)this.x, (float)this.y).method_35585(0.5f);
    }

    public class_241 gridToWorldVec() {
        return this.mul(2).toVec2f();
    }

    public Vector2i toVec2i() {
        return new Vector2i(this.x, this.y);
    }

    public double distance(GridTile tile) {
        return this.distance(tile.x, tile.y);
    }

    public double distance(int xIn, int yIn) {
        double x = this.x - xIn;
        double y = this.y - yIn;
        return Math.sqrt((double)(x * x + y * y));
    }

    public int manhattanDistance(GridTile tile) {
        return Math.abs((int)(this.x - tile.x)) + Math.abs((int)(this.y - tile.y));
    }

    public boolean isAdjacentTo(GridTile tile) {
        return this.manhattanDistance(tile) <= 1;
    }

    public Box2f bounds() {
        return new Box2f(this.x, this.x + 1, this.y, this.y + 1);
    }

    public GridTile offset(@Nullable class_2350 dir) {
        return this.offset(dir, 1);
    }

    public GridTile offset(@Nullable class_2350 dir, int distance) {
        if (dir == null || distance == 0) {
            return this.copy();
        }
        return new GridTile(this.x + dir.method_10148() * distance, this.y + dir.method_10165() * distance);
    }

    public GridTile add(Vector2i vec) {
        return this.add(vec.x, vec.y);
    }

    public GridTile add(int xIn, int yIn) {
        return new GridTile(this.x + xIn, this.y + yIn);
    }

    public GridTile add(GridTile tile) {
        return this.add(tile.x, tile.y);
    }

    public GridTile sub(Vector2i vec) {
        return this.sub(vec.x, vec.y);
    }

    public GridTile sub(int xIn, int yIn) {
        return new GridTile(this.x - xIn, this.y - yIn);
    }

    public class_2338 toPos(int yIn) {
        return new class_2338(this.x, yIn, this.y);
    }

    public GridTile mul(int scalar) {
        return new GridTile(this.x * scalar, this.y * scalar);
    }
}

