/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.init.CDTiles;
import com.lying.worldgen.Tile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class CDRoomTileSets {
    public static final Map<Tile, Float> DEFAULT_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> START_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> END_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> EMPTY_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> TREASURE_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> BOSS_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> BATTLE_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> PUZZLE_ROOM_TILESET = new HashMap<Tile, Float>();
    public static final Map<Tile, Float> TRAP_ROOM_TILESET = new HashMap<Tile, Float>();
    private static final List<Map<Tile, Float>> TILESETS = List.of(DEFAULT_TILESET, START_ROOM_TILESET, END_ROOM_TILESET, EMPTY_ROOM_TILESET, TREASURE_ROOM_TILESET, BOSS_ROOM_TILESET, BATTLE_ROOM_TILESET, PUZZLE_ROOM_TILESET, TRAP_ROOM_TILESET);

    public static void init() {
        TILESETS.forEach(set -> CDRoomTileSets.buildTileSet(set, CDTiles.AIR, Float.valueOf(10.0f)));
        CDRoomTileSets.buildTileSet(DEFAULT_TILESET, Map.of(CDTiles.FLOOR_PRISTINE, Float.valueOf(3000.0f), CDTiles.FLOOR, Float.valueOf(1000.0f), CDTiles.PUDDLE, Float.valueOf(1000.0f), CDTiles.WET_FLOOR, Float.valueOf(750.0f), CDTiles.POOL, Float.valueOf(100.0f), CDTiles.SEAT, Float.valueOf(10.0f), CDTiles.FLOOR_LIGHT, Float.valueOf(1.0f), CDTiles.TABLE, Float.valueOf(1.0f), CDTiles.TABLE_LIGHT, Float.valueOf(1.0f), CDTiles.WORKSTATION, Float.valueOf(1.0f)));
        CDRoomTileSets.addPlaceableFlooring(START_ROOM_TILESET);
        CDRoomTileSets.addPlaceableFlooring(END_ROOM_TILESET);
        CDRoomTileSets.addGenericFlooring(EMPTY_ROOM_TILESET);
        CDRoomTileSets.buildTileSet(EMPTY_ROOM_TILESET, Map.of(CDTiles.SEAT, Float.valueOf(10.0f), CDTiles.FLOOR_LIGHT, Float.valueOf(1.0f), CDTiles.TABLE, Float.valueOf(1.0f), CDTiles.TABLE_LIGHT, Float.valueOf(1.0f), CDTiles.WORKSTATION, Float.valueOf(1.0f)));
        CDRoomTileSets.addPlaceableFlooring(TREASURE_ROOM_TILESET);
        CDRoomTileSets.buildTileSet(TREASURE_ROOM_TILESET, CDTiles.TREASURE, Float.valueOf(3000.0f));
        CDRoomTileSets.buildTileSet(BOSS_ROOM_TILESET, Map.of(CDTiles.PILLAR_BASE, Float.valueOf(3000.0f), CDTiles.PILLAR, Float.valueOf(3000.0f), CDTiles.PILLAR_CAP, Float.valueOf(3000.0f), CDTiles.FLOOR_PRISTINE, Float.valueOf(1000.0f), CDTiles.FLOOR, Float.valueOf(1000.0f), CDTiles.HOT_FLOOR, Float.valueOf(750.0f), CDTiles.LAVA, Float.valueOf(750.0f)));
        CDRoomTileSets.buildTileSet(BATTLE_ROOM_TILESET, Map.of(CDTiles.FLOOR_PRISTINE, Float.valueOf(750.0f), CDTiles.FLOOR, Float.valueOf(1000.0f), CDTiles.HOT_FLOOR, Float.valueOf(1000.0f), CDTiles.LAVA, Float.valueOf(500.0f)));
        CDRoomTileSets.addPlaceableFlooring(PUZZLE_ROOM_TILESET);
        CDRoomTileSets.addPlaceableFlooring(TRAP_ROOM_TILESET);
    }

    public static void buildTileSet(Map<Tile, Float> tileSet, Map<Supplier<Tile>, Float> tilesIn) {
        tilesIn.entrySet().forEach(e -> CDRoomTileSets.buildTileSet(tileSet, (Supplier)e.getKey(), (Float)e.getValue()));
    }

    public static void buildTileSet(Map<Tile, Float> tileSet, Supplier<Tile> tile, Float weight) {
        tileSet.put(tile.get(), weight);
    }

    public static void addPlaceableFlooring(Map<Tile, Float> map) {
        map.put(CDTiles.FLOOR_PRISTINE.get(), Float.valueOf(3000.0f));
        map.put(CDTiles.FLOOR.get(), Float.valueOf(1000.0f));
    }

    public static void addGenericFlooring(Map<Tile, Float> map) {
        CDRoomTileSets.addPlaceableFlooring(map);
        map.put(CDTiles.PUDDLE.get(), Float.valueOf(1000.0f));
        map.put(CDTiles.WET_FLOOR.get(), Float.valueOf(200.0f));
        map.put(CDTiles.POOL.get(), Float.valueOf(10.0f));
    }
}

