/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintRoom;
import com.lying.init.CDLoggers;
import com.lying.utility.Box2f;
import com.lying.utility.DebugLogger;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LineUtils {
    public static final DebugLogger LOGGER = CDLoggers.PLANAR;
    private static final int TILE_SIZE = 2;

    public static List<LineSegment2f> simplifyLines(List<LineSegment2f> linesIn) {
        if (linesIn.size() <= 1) {
            return linesIn;
        }
        ArrayList output = Lists.newArrayList();
        boolean anyMerged = false;
        for (int i = 1; i < linesIn.size(); ++i) {
            LineSegment2f b;
            LineSegment2f a = linesIn.get(i - 1);
            LineSegment2f merged = LineUtils.mergeLines(a, b = linesIn.get(i));
            if (merged == null) {
                output.add(a);
                continue;
            }
            output.add(merged);
            anyMerged = true;
        }
        return anyMerged ? LineUtils.simplifyLines(output) : linesIn;
    }

    @Nullable
    public static LineSegment2f mergeLines(LineSegment2f a, LineSegment2f b) {
        if (!a.linksTo(b) || !a.alignsWith(b)) {
            return null;
        }
        ArrayList points = Lists.newArrayList();
        for (class_241 point : new class_241[]{a.getLeft(), a.getRight(), b.getLeft(), b.getRight()}) {
            if (points.contains(point)) {
                points.remove(point);
                continue;
            }
            points.add(point);
        }
        return new LineSegment2f((class_241)points.getFirst(), (class_241)points.getLast());
    }

    public static List<LineSegment2f> trialLines(BlueprintRoom start, BlueprintRoom end) {
        class_241 endDoor;
        Box2f startBox = (Box2f)start.worldBounds();
        Box2f endBox = (Box2f)end.worldBounds();
        Pair<class_2350, class_241> startPoints = LineUtils.findClosestTile(startBox, end.position());
        Pair<class_2350, class_241> endPoints = LineUtils.findClosestTile(endBox, start.position());
        class_241 startDoor = (class_241)startPoints.getRight();
        LineSegment2f startToEnd = new LineSegment2f(startDoor, endDoor = (class_241)endPoints.getRight());
        if (startToEnd.isStraightLine()) {
            return List.of(startToEnd);
        }
        class_2350 startExit = (class_2350)startPoints.getLeft();
        class_2350 endExit = (class_2350)endPoints.getLeft();
        class_241 outOfStart = startDoor.method_35586(new class_241((float)startExit.method_10148(), (float)startExit.method_10165()).method_35582(3.0f));
        class_241 outOfEnd = endDoor.method_35586(new class_241((float)endExit.method_10148(), (float)endExit.method_10165()).method_35582(3.0f));
        if (outOfStart.method_35589(endDoor) == startDoor.method_35589(outOfStart)) {
            return List.of(new LineSegment2f(startDoor, outOfStart), new LineSegment2f(outOfStart, endDoor));
        }
        return List.of(new LineSegment2f(startDoor, outOfStart), new LineSegment2f(outOfStart, outOfEnd), new LineSegment2f(outOfEnd, endDoor));
    }

    private static Pair<class_2350, class_241> findClosestTile(Box2f bounds, Vector2i target) {
        class_241 destination = new class_241((float)target.x, (float)target.y);
        float minDist = Float.MAX_VALUE;
        Pair best = null;
        block4: for (class_2350 face : class_2350.class_2353.field_11062) {
            LineSegment2f edge = bounds.getEdge(face);
            int tileLength = (int)(edge.length() / 2.0f);
            class_241 offset = new class_241((float)face.method_10148(), (float)face.method_10165()).method_35582(-1.0f);
            class_241 dir = edge.direction().method_35581();
            switch (tileLength) {
                case 1: 
                case 2: {
                    class_241 p2 = edge.left.method_35586(dir.method_35582(1.0f));
                    float d2 = p2.method_35586(offset).method_35589(destination);
                    if (!(d2 < minDist) && best != null) continue block4;
                    best = Pair.of((Object)face, (Object)p2);
                    minDist = d2;
                    continue block4;
                }
                case 3: {
                    class_241 p3 = edge.left.method_35586(edge.direction().method_35582(0.5f));
                    float d3 = p3.method_35586(offset).method_35589(destination);
                    if (!(d3 < minDist) && best != null) continue block4;
                    best = Pair.of((Object)face, (Object)p3);
                    minDist = d3;
                    continue block4;
                }
            }
            for (int i = 1; i < tileLength - 1; ++i) {
                class_241 pN = edge.left.method_35586(dir.method_35582(((float)i + 0.5f) * 2.0f));
                float dN = pN.method_35586(offset).method_35589(destination);
                if (!(dN < minDist) && best != null) continue;
                best = Pair.of((Object)face, (Object)pN);
                minDist = dN;
            }
        }
        return best;
    }
}

