/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.google.common.base.Predicates;
import com.lying.grid.BlueprintTileGrid;
import com.lying.init.CDTileTags;
import com.lying.init.CDTiles;
import com.lying.worldgen.Tile;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class TileConditions {
    public static Predicate<Tile> isAnyOf(class_2960 ... idsIn) {
        return t -> {
            class_2960 id = t.registryName();
            for (class_2960 test : idsIn) {
                if (!id.equals((Object)test)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition always() {
        return (t, p, s) -> true;
    }

    public static Condition never() {
        return (t, p, s) -> false;
    }

    public static Condition not(Condition cond) {
        return (t, p, s) -> !cond.test(t, p, s);
    }

    public static Condition boundary(class_2350.class_2353 type) {
        return TileConditions.boundary(type.method_29716().toList());
    }

    public static Condition boundary(List<class_2350> faces) {
        return (t, p, s) -> faces.stream().anyMatch(d -> s.isBoundary(p, (class_2350)d));
    }

    public static Condition nonBoundary() {
        return TileConditions.not(TileConditions.boundary(class_2350.method_42013().toList()));
    }

    public static Condition onFloor() {
        return TileConditions.adjacent(List.of(class_2350.field_11033), CDTileTags.SOLID_FLOORING::contains);
    }

    public static Condition onBottomLayer() {
        return TileConditions.boundary(List.of(class_2350.field_11033));
    }

    public static Condition onTopLayer() {
        return TileConditions.boundary(List.of(class_2350.field_11036));
    }

    public static Condition nonPassage() {
        return TileConditions.not(TileConditions.passage());
    }

    public static Condition passage() {
        return TileConditions.adjacent(t -> t.registryName().equals((Object)CDTiles.ID_PASSAGE));
    }

    public static Condition adjacent(Predicate<Tile> predicate) {
        return TileConditions.adjacent(class_2350.method_42013().toList(), predicate);
    }

    public static Condition adjacent(class_2350.class_2353 type, Predicate<Tile> predicate) {
        return TileConditions.adjacent(type.method_29716().toList(), predicate);
    }

    public static Condition adjacent(List<class_2350> faces, Predicate<Tile> predicate) {
        return (tile, pos, set) -> faces.stream().map(f -> pos.method_10093(f)).filter(set::contains).map(p -> set.get(p).get()).filter((Predicate<Tile>)Predicates.not(Tile::isBlank)).anyMatch(predicate);
    }

    public static Condition near(class_238 bounds, Predicate<Tile> predicate) {
        int lX = (int)(Math.min(10.0, bounds.method_17939()) * 0.5);
        int lY = (int)(Math.min(10.0, bounds.method_17940()) * 0.5);
        int lZ = (int)(Math.min(10.0, bounds.method_17941()) * 0.5);
        class_238 b = class_238.method_54784((class_2338)new class_2338(-lX, -lY, -lZ), (class_2338)new class_2338(lX, lY, lZ));
        return (tile, pos, set) -> {
            class_238 box = b.method_996(pos);
            return !set.getMatchingTiles((p2, t2) -> box.method_1006(new class_243((double)p2.method_10263() + 0.5, (double)p2.method_10264() + 0.5, (double)p2.method_10260() + 0.5)) && predicate.test((Tile)t2)).isEmpty();
        };
    }

    public static Condition near(double distance, Predicate<Tile> predicate) {
        double d = Math.min(10.0, distance);
        return (t, p, s) -> !s.getMatchingTiles((p2, t2) -> p2.method_19771((class_2382)p, d) && predicate.test((Tile)t2)).isEmpty();
    }

    public static Condition avoid(class_238 bounds, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.near(bounds, tiles));
    }

    public static Condition avoid(double distance, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.near(distance, tiles));
    }

    public static Condition consecutive(List<class_2350> faces) {
        return (t, p, s) -> TileConditions.adjacent(faces, t::is).test(t, p, s);
    }

    public static Condition nonConsecutive() {
        return TileConditions.nonConsecutive(class_2350.method_42013().toList());
    }

    public static Condition nonConsecutive(List<class_2350> faces) {
        return (t, p, s) -> TileConditions.not(TileConditions.adjacent(faces, t::is)).test(t, p, s);
    }

    public static Condition nonAdjacent(Predicate<Tile> tiles) {
        return TileConditions.nonAdjacent(class_2350.method_42013().toList(), tiles);
    }

    public static Condition nonAdjacent(List<class_2350> faces, Predicate<Tile> tiles) {
        return TileConditions.not(TileConditions.adjacent(faces, tiles));
    }

    public static Condition nonConsecutive(class_238 box) {
        return (t, p, s) -> TileConditions.avoid(box, t::is).test(t, p, s);
    }

    public static Condition maxOf(int i) {
        return (t, p, s) -> s.tallyOf(t) < i;
    }

    public static Condition maxOf(int i, Predicate<Tile> condition) {
        return (t, p, s) -> s.tallyMatching(condition) < i;
    }

    @FunctionalInterface
    public static interface Condition {
        public boolean test(Tile var1, class_2338 var2, BlueprintTileGrid var3);
    }
}

