/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.google.common.collect.Lists;
import com.lying.grid.BlueprintTileGrid;
import com.lying.init.CDLoggers;
import com.lying.init.CDTiles;
import com.lying.utility.CDUtils;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import org.apache.commons.lang3.tuple.Pair;

public class TileGenerator {
    public static final DebugLogger LOGGER = CDLoggers.WFC;
    public static boolean DEBUG = false;

    public static void generate(BlueprintTileGrid map, Map<Tile, Float> tiles, class_5819 rand) {
        if (map.isEmpty()) {
            LOGGER.error("Attempted to apply WFC to blank tile set");
            return;
        }
        LOGGER.info("Apply WFC to tile set of {} positions", map.volume());
        List<class_2338> positionsToGenerate = map.getBlanks();
        HashMap positionsPerY = new HashMap();
        positionsToGenerate.forEach(p -> {
            int y = p.method_10264();
            List set = positionsPerY.getOrDefault(y, Lists.newArrayList());
            set.add(p);
            positionsPerY.put(y, set);
        });
        ArrayList levels = Lists.newArrayList();
        levels.addAll(positionsPerY.keySet());
        Collections.sort(levels);
        int index = 0;
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            List positions = (List)positionsPerY.get(level);
            int size = positions.size();
            TileGenerator.processSet(positions, map, tiles, rand);
            LOGGER.info(" ## Generated set {} of {}, {} positions", ++index, levels.size(), size);
        }
        LOGGER.info("WFC complete");
    }

    private static void processSet(List<class_2338> slots, BlueprintTileGrid map, Map<Tile, Float> tiles, class_5819 rand) {
        if (slots.isEmpty() || tiles.isEmpty()) {
            LOGGER.forceWarn("Position set empty or no tiles were provided");
            return;
        }
        List<Tile> candidates = tiles.keySet().stream().filter(t -> !t.isBlank()).toList();
        while (!slots.isEmpty()) {
            map.clearOptionCache();
            MapEntry entry = TileGenerator.getMostConstrained(slots, map, candidates);
            map.put(entry.pos(), switch (entry.options().size()) {
                case 0 -> CDTiles.AIR.get();
                case 1 -> entry.options().get(0);
                default -> TileGenerator.selectTile(entry.options(), tiles, rand);
            });
            slots.remove(entry.index());
        }
    }

    protected static MapEntry getMostConstrained(List<class_2338> slots, BlueprintTileGrid map, List<Tile> candidates) {
        map.clearOptionCache();
        MapEntry most = MapEntry.of(slots.get(0), map, candidates);
        for (int i = 0; i < slots.size(); ++i) {
            class_2338 slotB = slots.get(i);
            MapEntry entry = new MapEntry(i, slotB, map.getOptionsFor(slotB, candidates));
            if (entry.size() >= most.size()) continue;
            most = entry;
        }
        return most;
    }

    public static Tile selectTile(List<Tile> options, Map<Tile, Float> weights, class_5819 rand) {
        ArrayList weightedList = Lists.newArrayList();
        options.forEach(tile -> weightedList.add(Pair.of((Object)tile, (Object)Float.valueOf(((Float)weights.get(tile)).floatValue()))));
        return (Tile)CDUtils.selectFromWeightedList(weightedList, rand.method_43057());
    }

    protected record MapEntry(int index, class_2338 pos, List<Tile> options) {
        public int size() {
            return this.options.size();
        }

        public static MapEntry of(class_2338 pos, BlueprintTileGrid map, List<Tile> options) {
            return new MapEntry(0, pos, map.getOptionsFor(pos, options));
        }
    }
}

