/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.google.common.collect.Lists;
import com.lying.grid.BlueprintTileGrid;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileConditions;
import java.util.List;
import net.minecraft.class_2338;

public class TilePredicate {
    private final List<TileConditions.Condition> primitives = Lists.newArrayList();

    public static TilePredicate fromCondition(TileConditions.Condition condition) {
        return Builder.create().condition(condition).build();
    }

    public boolean test(Tile tile, class_2338 pos, BlueprintTileGrid set) {
        return this.primitives.isEmpty() || this.primitives.stream().allMatch(p -> p.test(tile, pos, set));
    }

    public static class Builder {
        private final List<TileConditions.Condition> conditions = Lists.newArrayList();

        protected Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder condition(TileConditions.Condition condition) {
            this.conditions.add(condition);
            return this;
        }

        public TilePredicate build() {
            TilePredicate predicate = new TilePredicate();
            this.conditions.forEach(predicate.primitives::add);
            return predicate;
        }
    }
}

