/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.SightSensorBlock;
import com.lying.init.CDBlockEntityTypes;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class SightSensorBlockEntity
extends class_2586 {
    public static final Predicate<class_1297> IS_VISIBLE = class_1301.field_6155.and(e -> !e.method_5767());
    protected double sightRange = 8.0;
    protected double sightRadius = 4.0;
    private Optional<UUID> lookTargetPlayer = Optional.empty();
    private class_243 lookVec = new class_243(0.0, 0.0, -1.0);
    private int tickCount = 0;
    public class_243 clientLookVec = new class_243(0.0, 0.0, -1.0);

    public SightSensorBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)CDBlockEntityTypes.SIGHT_SENSOR.get(), pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10549("Range", this.sightRange);
        nbt.method_10549("Radius", this.sightRadius);
        this.lookTargetPlayer.ifPresent(id -> nbt.method_25927("Target", id));
        nbt.method_10549("LookX", this.lookVec.field_1352);
        nbt.method_10549("LookY", this.lookVec.field_1351);
        nbt.method_10549("LookZ", this.lookVec.field_1350);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.sightRange = Math.max(1.0, nbt.method_10574("Range"));
        this.sightRadius = Math.max(0.5, nbt.method_10545("Radius") ? nbt.method_10574("Radius") : this.sightRange * 0.5);
        this.lookTargetPlayer = nbt.method_10545("Target") ? Optional.of(nbt.method_25926("Target")) : Optional.empty();
        this.lookVec = new class_243(nbt.method_10574("LookX"), nbt.method_10574("LookY"), nbt.method_10574("LookZ")).method_1029();
    }

    public class_243 currentLook() {
        return this.lookVec;
    }

    public Optional<UUID> currentTarget() {
        return this.lookTargetPlayer;
    }

    public static <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
        return type != CDBlockEntityTypes.SIGHT_SENSOR.get() ? null : SightSensorBlock.validateTicker(type, (class_2591)CDBlockEntityTypes.SIGHT_SENSOR.get(), world.method_8608() ? SightSensorBlockEntity::tickClient : SightSensorBlockEntity::tickServer);
    }

    public static <T extends class_2586> void tickClient(class_1937 world, class_2338 pos, class_2680 state, SightSensorBlockEntity tile) {
        class_1657 player;
        class_243 look = tile.currentLook();
        double adjustRate = 0.1;
        if (tile.currentTarget().isPresent() && (player = world.method_18470(tile.currentTarget().get())) != null) {
            look = player.method_33571().method_1020(tile.getEyePos()).method_1029();
            adjustRate = 0.5;
        }
        tile.clientLookVec = tile.clientLookVec.method_1019(look.method_1020(tile.clientLookVec).method_1021(adjustRate));
    }

    public static <T extends class_2586> void tickServer(class_1937 world, class_2338 pos, class_2680 state, SightSensorBlockEntity tile) {
        if (tile.tickCount++ % SightSensorBlockEntity.updateRate(tile) > 0) {
            return;
        }
        if (tile.lookTargetPlayer.isEmpty()) {
            class_243 lookVec = tile.lookVec;
            Optional<class_3222> newTarget = ((class_3218)world).method_18456().stream().filter(IS_VISIBLE).filter(tile::isInViewCone).filter(p -> SightSensorBlockEntity.canEyeSeePlayer(tile, (class_1657)p, world)).sorted((a, b) -> {
                double distB;
                double distA = tile.distanceFromLook(a.method_33571());
                return distA < (distB = tile.distanceFromLook(b.method_33571())) ? -1 : (distA > distB ? 1 : 0);
            }).findFirst();
            newTarget.ifPresentOrElse(p -> {
                tile.startTracking((class_1657)p);
                tile.method_5431();
            }, () -> {
                class_5819 rand = world.method_8409();
                tile.lookVec = lookVec.method_1019(new class_243(rand.method_43058() - 0.5, rand.method_43058() - 0.5, rand.method_43058() - 0.5)).method_1029();
                tile.lookVec = new class_243(tile.lookVec.field_1352, class_3532.method_15350((double)tile.lookVec.field_1351, (double)-0.3, (double)0.3), tile.lookVec.field_1350).method_1029();
                tile.method_5431();
            });
        } else if (tile.lookTargetPlayer.isPresent()) {
            class_1657 player = world.method_18470(tile.lookTargetPlayer.get());
            if (player == null) {
                tile.clearTracking();
                tile.method_5431();
                return;
            }
            if (player != null && IS_VISIBLE.test((class_1297)player) && SightSensorBlockEntity.canEyeSeePlayer(tile, player, world)) {
                int charge = (Integer)tile.method_11010().method_11654((class_2769)SightSensorBlock.POWER);
                if (charge < 15) {
                    world.method_8652(tile.method_11016(), (class_2680)state.method_11657((class_2769)SightSensorBlock.POWER, (Comparable)Integer.valueOf(++charge)), 3);
                }
            } else {
                tile.stopTracking(player);
                tile.method_5431();
            }
        }
    }

    protected void startTracking(class_1657 player) {
        this.lookTargetPlayer = Optional.of(player.method_5667());
        this.updateBlock(1);
    }

    protected void stopTracking(class_1657 player) {
        if (this.lookTargetPlayer.isEmpty() || !this.lookTargetPlayer.get().equals(player.method_5667())) {
            return;
        }
        this.lookTargetPlayer = Optional.empty();
        this.lookVec = player.method_33571().method_1020(this.getEyePos()).method_1029();
        this.tickCount = 0;
        this.updateBlock(0);
    }

    protected void clearTracking() {
        this.lookTargetPlayer = Optional.empty();
        this.lookVec = new class_243(0.0, 0.0, -1.0);
        this.updateBlock(0);
    }

    protected void updateBlock(int power) {
        if (power == (Integer)this.method_11010().method_11654((class_2769)SightSensorBlock.POWER)) {
            return;
        }
        class_2680 state = (class_2680)((class_2680)this.method_11010().method_11657((class_2769)SightSensorBlock.POWER, (Comparable)Integer.valueOf(power))).method_11657((class_2769)SightSensorBlock.POWERED, (Comparable)Boolean.valueOf(power > 0));
        this.field_11863.method_8652(this.method_11016(), state, 3);
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), state, 3);
    }

    public class_243 getEyePos() {
        class_2338 tilePos = this.method_11016();
        return new class_243((double)tilePos.method_10263(), (double)tilePos.method_10264(), (double)tilePos.method_10260()).method_61889(0.5);
    }

    public double distanceFromLook(class_243 p) {
        double distToP = this.getEyePos().method_1022(p);
        class_243 conePoint = this.getEyePos().method_1019(this.lookVec.method_1021(distToP));
        return p.method_1022(conePoint);
    }

    protected boolean isInViewCone(class_1657 player) {
        double distFromEye = this.getEyePos().method_1022(player.method_33571());
        double radiusAtDist = distFromEye / this.sightRange * this.sightRadius;
        return distFromEye <= this.sightRange && this.distanceFromLook(player.method_33571()) < radiusAtDist;
    }

    protected static boolean canEyeSeePlayer(SightSensorBlockEntity eye, class_1657 player, class_1937 world) {
        if (eye.getEyePos().method_1022(player.method_33571()) > eye.sightRange) {
            return false;
        }
        class_3965 trace = world.method_17742(new class_3959(player.method_33571(), eye.getEyePos(), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, class_3726.method_16194()));
        return trace.method_17783() == class_239.class_240.field_1333 || trace.method_17777().method_19455((class_2382)eye.method_11016()) == 0;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public static int updateRate(SightSensorBlockEntity tile) {
        return tile.currentTarget().isPresent() ? 20 : 40;
    }
}

