/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.google.common.collect.Lists;
import com.lying.block.IWireableBlock;
import com.lying.block.SwingingBladeBlock;
import com.lying.block.entity.TrapActorBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5558;
import net.minecraft.class_7225;

public class SwingingBladeBlockEntity
extends TrapActorBlockEntity {
    private static final double PIVOT_OFFSET = 0.1875;
    private static final double BLADE_INNER = 1.5;
    private static final double BLADE_OUTER = 2.8;
    private static final float BLADE_ARC = (float)Math.toRadians(4.0);
    private int swingTime = 20;
    private float swingPosition = -1.0f;
    private float swingTarget = -1.0f;
    private boolean prevPower = false;
    public float clientSwingPosition = 0.0f;

    public SwingingBladeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)CDBlockEntityTypes.SWINGING_BLADE.get(), pos, state);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("Speed", this.swingTime);
        nbt.method_10548("Swing", this.swingPosition());
        nbt.method_10548("SwingTarget", this.swingTarget);
        nbt.method_10556("PrevPower", this.prevPower);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.swingTime = nbt.method_10550("Speed");
        this.swingPosition = nbt.method_10583("Swing");
        this.swingTarget = nbt.method_10583("SwingTarget");
        this.prevPower = nbt.method_10577("PrevPower");
    }

    public float swingPosition() {
        return class_3532.method_15363((float)this.swingPosition, (float)-1.0f, (float)1.0f);
    }

    public boolean swingComplete() {
        return this.swingPosition() == this.swingTarget;
    }

    @Override
    public boolean processWireConnection(class_2338 pos, IWireableBlock.WireRecipient type) {
        if (type != IWireableBlock.WireRecipient.ACTOR) {
            this.addWire(pos, type);
        }
        return type != IWireableBlock.WireRecipient.ACTOR;
    }

    public static <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
        return type != CDBlockEntityTypes.SWINGING_BLADE.get() ? null : SwingingBladeBlock.validateTicker(type, (class_2591)CDBlockEntityTypes.SWINGING_BLADE.get(), world.method_8608() ? SwingingBladeBlockEntity::tickClient : SwingingBladeBlockEntity::tickServer);
    }

    public static <T extends class_2586> void tickClient(class_1937 world, class_2338 pos, class_2680 state, SwingingBladeBlockEntity tile) {
        TrapActorBlockEntity.tickClient(world, pos, state, tile);
        if (tile.clientSwingPosition != tile.swingPosition()) {
            tile.clientSwingPosition += (tile.swingPosition() - tile.clientSwingPosition) * 0.9f;
        }
        if (tile.swingComplete() || world.method_8409().method_43056()) {
            return;
        }
        class_243 pivot = SwingingBladeBlockEntity.getPivotPoint(pos, (class_2350)state.method_11654(SwingingBladeBlock.FACING));
        class_243 centre = SwingingBladeBlockEntity.getBladeOffset(state, (float)Math.toRadians(90.0 * (double)tile.clientSwingPosition));
        class_243 outer = pivot.method_1019(centre.method_1021(2.15));
        world.method_8406((class_2394)class_2398.field_11205, outer.field_1352, outer.field_1351, outer.field_1350, 0.0, 0.0, 0.0);
    }

    public static <T extends class_2586> void tickServer(class_1937 world, class_2338 pos, class_2680 state, SwingingBladeBlockEntity tile) {
        TrapActorBlockEntity.tickServer(world, pos, state, tile);
        boolean dirty = false;
        boolean power = (Boolean)state.method_11654((class_2769)SwingingBladeBlock.POWERED);
        if (!tile.swingComplete()) {
            float delta = Math.signum(tile.swingTarget - tile.swingPosition());
            tile.swingPosition += 2.0f / (float)tile.swingTime * delta;
            dirty = true;
        } else if (power && !tile.prevPower) {
            tile.switchSwing();
        }
        if (power != tile.prevPower) {
            tile.prevPower = power;
            dirty = true;
        }
        if (dirty) {
            tile.method_5431();
        }
        class_2350 facing = (class_2350)state.method_11654(SwingingBladeBlock.FACING);
        class_243 pivot = SwingingBladeBlockEntity.getPivotPoint(pos, facing);
        float bladeAngle = (float)tile.getBladeAngle();
        ArrayList hits = Lists.newArrayList();
        for (class_243 point : new class_243[]{SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle + BLADE_ARC), SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle), SwingingBladeBlockEntity.getBladeOffset(state, bladeAngle - BLADE_ARC)}) {
            class_1309 entity;
            class_243 outer;
            class_243 inner = pivot.method_1019(point.method_1021(1.5));
            class_3966 trace = class_1675.method_18077((class_1937)world, null, (class_243)inner, (class_243)(outer = pivot.method_1019(point.method_1021(2.8))), (class_238)new class_238(inner, outer), (Predicate)class_1301.field_6156);
            if (trace == null || trace.method_17783() != class_239.class_240.field_1331 || !(trace.method_17782() instanceof class_1309) || hits.contains(entity = (class_1309)trace.method_17782())) continue;
            hits.add(entity);
        }
        hits.forEach(tile::hitEntity);
    }

    protected static class_243 getPivotPoint(class_2338 pos, class_2350 facing) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_61889(0.5).method_1031((double)facing.method_10153().method_10148() * 0.1875, (double)facing.method_10153().method_10164() * 0.1875, (double)facing.method_10153().method_10165() * 0.1875);
    }

    protected double getBladeAngle() {
        return Math.toRadians(90.0 * (double)this.swingPosition);
    }

    protected static class_243 getBladeOffset(class_2680 state, float angle) {
        class_2350 facing = (class_2350)state.method_11654(SwingingBladeBlock.FACING);
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654(SwingingBladeBlock.AXIS);
        class_243 forward = new class_243((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165());
        if (facing.method_10166() == axis) {
            return forward;
        }
        switch (facing.method_10166()) {
            case field_11048: {
                if (axis == class_2350.class_2351.field_11052) {
                    return forward.method_31033(angle * (float)(facing == class_2350.field_11034 ? 1 : -1));
                }
                return forward.method_1024(angle);
            }
            case field_11052: {
                if (axis == class_2350.class_2351.field_11048) {
                    return forward.method_31033(angle * (float)(facing == class_2350.field_11036 ? 1 : -1));
                }
                return forward.method_1037(-angle);
            }
            case field_11051: {
                if (axis == class_2350.class_2351.field_11052) {
                    return forward.method_1037(angle * (float)(facing == class_2350.field_11043 ? 1 : -1));
                }
                return forward.method_1024(angle * (float)(facing == class_2350.field_11043 ? -1 : 1));
            }
        }
        return forward;
    }

    public void hitEntity(class_1309 entity) {
        if (!entity.method_64397((class_3218)this.method_10997(), this.method_10997().method_48963().method_48830(), 6.0f)) {
            return;
        }
    }

    public void switchSwing() {
        this.swingTarget = this.swingTarget == 1.0f ? -1.0f : 1.0f;
        this.method_5431();
    }
}

