/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.grammar.RoomMetadata;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import org.joml.Vector2i;

public class BlueprintRoom {
    private static final int GRID_SIZE = 2;
    private final UUID id;
    private final RoomMetadata metadata;
    private List<UUID> childLinks = Lists.newArrayList();
    private List<UUID> parentLinks = Lists.newArrayList();
    private GridTile tilePosition = GridTile.ZERO.copy();
    private Optional<Blueprint> blueprint = Optional.empty();

    public BlueprintRoom(UUID idIn, RoomMetadata termIn, List<UUID> childLinksIn, List<UUID> parentLinksIn) {
        this.id = idIn;
        this.metadata = termIn;
        this.childLinks.addAll(childLinksIn);
        this.parentLinks.addAll(parentLinksIn);
    }

    public static BlueprintRoom create() {
        return new BlueprintRoom(UUID.randomUUID(), new RoomMetadata(), List.of(), List.of());
    }

    public boolean equals(Object obj) {
        return obj instanceof BlueprintRoom && ((BlueprintRoom)obj).id.equals(this.id);
    }

    public UUID uuid() {
        return this.id;
    }

    public BlueprintRoom clone() {
        return new BlueprintRoom(this.id, this.metadata.clone(), this.childLinks, this.parentLinks).setTilePosition(this.tilePosition);
    }

    public void attachToBlueprint(Blueprint blueprint) {
        this.blueprint = Optional.of(blueprint);
    }

    public RoomMetadata metadata() {
        return this.metadata;
    }

    public GridTile tilePosition() {
        return this.tilePosition;
    }

    public Vector2i position() {
        Vector2i tileSize = this.metadata().tileSize();
        GridTile tile = this.tileMin().add(tileSize.div(2));
        return tile.toVec2i().mul(2).add(1, 1);
    }

    public BlueprintRoom setPosition(Vector2i vec) {
        return this.setPosition(vec.x, vec.y);
    }

    public BlueprintRoom setPosition(int x, int y) {
        return this.setTilePosition(new GridTile(Math.floorDiv(x, 2), Math.floorDiv(y, 2)));
    }

    public BlueprintRoom setTilePosition(GridTile tile) {
        this.tilePosition = tile;
        this.blueprint.ifPresent(b -> b.clearPassageCache());
        return this;
    }

    public BlueprintRoom offset(Vector2i vec) {
        return this.offset(vec.x, vec.y);
    }

    public BlueprintRoom offset(int x, int y) {
        x = (int)Math.signum(x) * 2;
        y = (int)Math.signum(y) * 2;
        return this.setTilePosition(this.tilePosition.add(x, y));
    }

    public BlueprintRoom nudge(Vector2i vec) {
        return this.nudge(vec.x, vec.y);
    }

    public BlueprintRoom nudge(int x, int y) {
        return this.move(class_3532.method_15340((int)x, (int)-1, (int)1), class_3532.method_15340((int)y, (int)-1, (int)1));
    }

    public BlueprintRoom move(Vector2i vec) {
        return this.move(vec.x, vec.y);
    }

    public BlueprintRoom move(int x, int y) {
        return this.setTilePosition(this.tilePosition.add(x, y));
    }

    public boolean hasParents() {
        return !this.parentLinks.isEmpty();
    }

    public GridTile getParentPosition(Blueprint chart) {
        GridTile defaultPos = this.tilePosition.add(0, 1);
        if (!this.hasParents()) {
            return defaultPos;
        }
        int x = 0;
        int y = 0;
        if (this.parentLinks.size() > 1) {
            for (BlueprintRoom parent : this.getParents(chart)) {
                x += parent.position().x;
                y += parent.position().y;
            }
            return new GridTile(x /= this.parentLinks.size(), y /= this.parentLinks.size());
        }
        Optional<BlueprintRoom> parentOpt = chart.stream().filter(n -> n.uuid().equals(this.parentLinks.get(0))).findAny();
        if (parentOpt.isPresent()) {
            return parentOpt.get().tilePosition();
        }
        return defaultPos;
    }

    public GridTile tileMin() {
        return this.metadata().tileMin(this.tilePosition());
    }

    public GridTile tileMax() {
        return this.metadata().tileMax(this.tilePosition());
    }

    public AbstractBox2f tileBounds() {
        return this.tileBounds(this.tilePosition());
    }

    public AbstractBox2f tileBounds(GridTile position) {
        GridTile min = this.metadata().tileMin(position);
        GridTile max = this.metadata().tileMax(position);
        return new Box2f(min.x, max.x, min.y, max.y);
    }

    public AbstractBox2f worldBounds() {
        GridTile min = this.metadata().tileMin(this.tilePosition()).mul(2);
        GridTile max = this.metadata().tileMax(this.tilePosition()).mul(2);
        return new Box2f(min.x, max.x, min.y, max.y);
    }

    public class_238 worldBox() {
        GridTile min = this.metadata().tileMin(this.tilePosition()).mul(2);
        GridTile max = this.metadata().tileMax(this.tilePosition()).mul(2);
        return new class_238((double)min.x, 0.0, (double)min.y, (double)max.x, 8.0, (double)max.y);
    }

    public List<GridTile> tiles() {
        return this.metadata().tileFootprint(this.tilePosition);
    }

    public GraphTileGrid tileGrid() {
        return (GraphTileGrid)new GraphTileGrid().addAllToVolume(this.tiles());
    }

    public boolean occupies(GridTile tile) {
        return this.tiles().contains(tile);
    }

    public boolean isAdjacent(GridTile tile) {
        return this.tiles().stream().anyMatch(tile::isAdjacentTo);
    }

    public boolean intersects(AbstractBox2f boundsB) {
        AbstractBox2f bounds = this.tileBounds();
        return bounds.intersects(boundsB) || boundsB.intersects(bounds);
    }

    public boolean intersects(BlueprintRoom other) {
        List<GridTile> myTiles = this.tiles();
        return other.tiles().stream().anyMatch(p2 -> myTiles.stream().anyMatch(p2::isAdjacentTo));
    }

    public boolean hasChildren() {
        return !this.childLinks.isEmpty();
    }

    public int childrenCount() {
        return this.childLinks.size();
    }

    public int descendantCount(Collection<BlueprintRoom> chart) {
        int tally = this.childrenCount();
        for (BlueprintRoom child : this.getChildren(chart)) {
            tally += child.descendantCount(chart);
        }
        return tally;
    }

    public void addChild(BlueprintRoom child) {
        this.childLinks.add(child.id);
    }

    public List<BlueprintRoom> getParents(Collection<BlueprintRoom> graph) {
        return graph.stream().filter(n -> this.parentLinks.contains(n.id)).toList();
    }

    public List<BlueprintRoom> getChildren(Collection<BlueprintRoom> graph) {
        ArrayList set = Lists.newArrayList();
        set.addAll(graph.stream().filter(n -> this.childLinks.contains(n.id)).toList());
        return set;
    }
}

