/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintOrganiser;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.blueprint.BlueprintScruncher;
import com.lying.client.screen.NodeRenderUtils;
import com.lying.reference.Reference;
import com.lying.screen.DungeonScreenHandler;
import com.lying.utility.Box2f;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DungeonScreen
extends class_465<DungeonScreenHandler> {
    private static final class_310 mc = class_310.method_1551();
    public static final class_2960 ICON_TEX = Reference.ModInfo.prefix("textures/gui/tree_node.png");
    private State state = State.BLUEPRINT;
    public static int renderScale = 1;
    static boolean showCriticalPath = false;
    public static List<BlueprintPassage> criticalPath = Lists.newArrayList();
    public static List<BlueprintPassage> totalPassages = Lists.newArrayList();
    private final Long randSeed;
    private Vector2i displayOffset = new Vector2i(0, 0);
    private Vector2i dragStart = null;
    private class_4185 scrunchButton;
    private class_4185 collapseButton;
    private class_4185 criticalButton;
    private class_4185[] blueprintButtons;
    private Blueprint blueprint = null;
    private Map<Blueprint.ErrorType, Integer> errorCache = new HashMap<Blueprint.ErrorType, Integer>();
    private Box2f originBox = null;
    private List<LineSegment2f> originLines = Lists.newArrayList();

    public DungeonScreen(DungeonScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.randSeed = System.currentTimeMillis();
        renderScale = 16;
        showCriticalPath = false;
    }

    protected void method_25426() {
        class_4185 tree = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Tree"), b -> this.organise(BlueprintOrganiser.Tree::create)).method_46434(0, 0, 60, 20).method_46431();
        this.method_37063((class_364)tree);
        class_4185 x4 = class_4185.method_46430((class_2561)class_2561.method_43470((String)"4x Grid"), b -> this.organise(BlueprintOrganiser.Grid.Square::create)).method_46434(0, 20, 60, 20).method_46431();
        this.method_37063((class_364)x4);
        class_4185 x8 = class_4185.method_46430((class_2561)class_2561.method_43470((String)"8x Grid"), b -> this.organise(BlueprintOrganiser.Grid.Octagonal::create)).method_46434(0, 40, 60, 20).method_46431();
        this.method_37063((class_364)x8);
        class_4185 circle = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Concentric"), b -> this.organise(BlueprintOrganiser.Circular::create)).method_46434(0, 60, 60, 20).method_46431();
        this.method_37063((class_364)circle);
        this.scrunchButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Scrunch"), b -> this.scrunch()).method_46434(0, 90, 60, 20).method_46431();
        this.method_37063((class_364)this.scrunchButton);
        this.collapseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Collapse"), b -> this.collapse()).method_46434(0, 110, 60, 20).method_46431();
        this.method_37063((class_364)this.collapseButton);
        class_4185 goStart = class_4185.method_46430((class_2561)class_2561.method_43470((String)"O"), b -> this.resetDrag()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Focus Start"))).method_46434(this.field_22789 - 20, 0, 20, 20).method_46431();
        this.method_37063((class_364)goStart);
        this.criticalButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), b -> {
            showCriticalPath = !showCriticalPath;
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Toggle Critical Path"))).method_46434(this.field_22789 - 20, 25, 20, 20).method_46431();
        this.method_37063((class_364)this.criticalButton);
        this.blueprintButtons = new class_4185[]{tree, x4, x8, circle, this.scrunchButton, this.collapseButton, goStart, this.criticalButton};
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Mode"), b -> {
            this.state = State.values()[(this.state.ordinal() + 1) % State.values().length];
        }).method_46434(this.field_22789 - 60, this.field_22790 - 20, 60, 20).method_46431());
    }

    private void organise(Supplier<BlueprintOrganiser> organiser) {
        organiser.get().organise(this.blueprint, class_5819.method_43049((long)this.randSeed));
        this.cacheErrors();
        this.updatePathCaches();
        this.resetDrag();
    }

    private void scrunch() {
        BlueprintScruncher.scrunch(this.blueprint, false);
        BlueprintScruncher.scrunch(this.blueprint, true);
        this.cacheErrors();
        this.updatePathCaches();
    }

    private void collapse() {
        BlueprintScruncher.collapse(this.blueprint, false);
        BlueprintScruncher.collapse(this.blueprint, true);
        this.cacheErrors();
        this.updatePathCaches();
    }

    private void cacheErrors() {
        this.errorCache.clear();
        for (Blueprint.ErrorType type : Blueprint.ErrorType.values()) {
            int total = Blueprint.tallyErrors(this.blueprint, type);
            if (total <= 0) continue;
            this.errorCache.put(type, total);
        }
    }

    private void updatePathCaches() {
        totalPassages = BlueprintOrganiser.getFinalisedPassages(this.blueprint);
        if (!this.errorCache.isEmpty()) {
            criticalPath.clear();
            return;
        }
        criticalPath = BlueprintOrganiser.getPassages(this.blueprint.getCriticalPath());
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        switch (this.state.ordinal()) {
            case 0: {
                context.method_51439(this.field_22793, this.field_22785, (mc.method_22683().method_4486() - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, 10, 0xFFFFFF, false);
                if (this.blueprint == null || this.blueprint.isEmpty()) break;
                int totalErrors = 0;
                for (int val : this.errorCache.values()) {
                    totalErrors += val;
                }
                boolean errors = totalErrors > 0;
                class_5250 details = errors ? class_2561.method_43469((String)"gui.cydun.dungeon_data_long", (Object[])new Object[]{this.blueprint.size(), this.blueprint.maxDepth(), totalErrors, this.errorCache.getOrDefault((Object)Blueprint.ErrorType.COLLISION, 0), this.errorCache.getOrDefault((Object)Blueprint.ErrorType.INTERSECTION, 0), this.errorCache.getOrDefault((Object)Blueprint.ErrorType.TUNNEL, 0)}) : class_2561.method_43469((String)"gui.cydun.dungeon_data", (Object[])new Object[]{this.blueprint.size(), this.blueprint.maxDepth(), 0});
                context.method_51439(this.field_22793, (class_2561)details, (mc.method_22683().method_4486() - this.field_22793.method_27525((class_5348)details)) / 2, 20, 0xFFFFFF, false);
                if (!errors) break;
                int y = mc.method_22683().method_4502();
                for (class_2561 line : new class_2561[]{class_2561.method_43470((String)"Dark Gray - Errors detected elsewhere"), class_2561.method_43470((String)"Lime Green - Path intersects with unrelated room"), class_2561.method_43470((String)"Light Blue - Path intersects with unrelated path")}) {
                    Objects.requireNonNull(this.field_22793);
                    context.method_51439(this.field_22793, line, 10, y -= 9, class_124.field_1080.method_532().intValue(), false);
                }
                break;
            }
            case 1: {
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Geometry testing"), (mc.method_22683().method_4486() - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, 10, 0xFFFFFF, false);
            }
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        this.method_48267();
        switch (this.state.ordinal()) {
            case 0: {
                if (this.blueprint == null || this.blueprint.isEmpty()) {
                    return;
                }
                Vector2i position = this.method_25397() ? new Vector2i(this.displayOffset.x + mouseX - this.dragStart.x, this.displayOffset.y + mouseY - this.dragStart.y) : this.displayOffset;
                Vector2i drawOrigin = new Vector2i(mc.method_22683().method_4486() / 2, mc.method_22683().method_4502() / 5).add((Vector2ic)position);
                NodeRenderUtils.render((BlueprintRoom)this.blueprint.get(0), context, this.field_22793, drawOrigin, this.blueprint, this.errorCache, mouseX, mouseY, renderScale);
                break;
            }
            case 1: {
                class_241 lineStart = new class_241((float)(mc.method_22683().method_4486() / 2), (float)(mc.method_22683().method_4502() / 5));
                class_241 lineEnd = new class_241((float)mouseX, (float)mouseY);
                LineSegment2f line = new LineSegment2f(lineStart, lineEnd);
                NodeRenderUtils.renderGradientStraightLine(line, context, class_9848.method_61330((int)175, (int)class_124.field_1075.method_532()));
                class_241 textPoint = lineStart.method_35586(lineEnd.method_35586(lineStart.method_35588()).method_35582(0.5f));
                ArrayList intercepts = Lists.newArrayList();
                for (LineSegment2f edge : this.originLines) {
                    class_241 intercept = LineSegment2f.segmentIntercept(edge, line);
                    boolean hasIntercept = intercept != null;
                    int colour = hasIntercept ? 0xFFBF00 : 0x6E6E6E;
                    NodeRenderUtils.renderGradientStraightLine(edge, context, colour);
                    if (!hasIntercept) continue;
                    intercepts.add(new class_3545((Object)edge, (Object)intercept));
                }
                intercepts.forEach(p -> {
                    LineSegment2f edge = (LineSegment2f)p.method_15442();
                    class_241 intercept = (class_241)p.method_15441();
                    Box2f pointBox = new Box2f(intercept.field_1343 - 1.0f, intercept.field_1343 + 1.0f, intercept.field_1342 - 1.0f, intercept.field_1342 + 1.0f);
                    NodeRenderUtils.renderBox(pointBox, context, class_9848.method_61330((int)255, (int)class_124.field_1079.method_532()));
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)edge.asEquation()), (int)(edge.isVertical ? edge.getLeft().field_1343 + 5.0f : (edge.getLeft().field_1343 + edge.getRight().field_1343) / 2.0f), (int)(edge.isVertical ? (edge.getLeft().field_1342 + edge.getRight().field_1342) / 2.0f : edge.getLeft().field_1342 + 5.0f), class_124.field_1079.method_532().intValue(), false);
                });
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)line.asEquation()), (int)textPoint.field_1343, (int)textPoint.field_1342, 0xFFFFFF, false);
            }
        }
    }

    public void method_37432() {
        switch (this.state.ordinal()) {
            case 0: {
                for (class_4185 button : this.blueprintButtons) {
                    button.field_22764 = true;
                }
                if (this.blueprint == null) {
                    ((DungeonScreenHandler)this.method_17577()).graph().ifPresent(graph -> {
                        if (graph.isEmpty()) {
                            return;
                        }
                        this.blueprint = Blueprint.fromGraph(graph);
                        this.blueprint.updateCriticalPath();
                        class_5819 rand = class_5819.method_43049((long)this.randSeed);
                        this.blueprint.forEach(node -> node.metadata().setSize(node.metadata().type().size(rand)));
                        BlueprintOrganiser.Tree.create().organise(this.blueprint, rand);
                        this.cacheErrors();
                        this.updatePathCaches();
                    });
                    break;
                }
                this.collapseButton.field_22763 = this.criticalButton.field_22763 = this.errorCache.isEmpty();
                this.scrunchButton.field_22763 = this.criticalButton.field_22763;
                showCriticalPath = showCriticalPath && this.criticalButton.field_22763;
                break;
            }
            case 1: {
                for (class_4185 button : this.blueprintButtons) {
                    button.field_22764 = false;
                }
                if (this.originBox != null) break;
                Vector2i screenMid = new Vector2i(mc.method_22683().method_4486() / 2, mc.method_22683().method_4502() / 2);
                this.originBox = new Box2f(screenMid.x - 50, screenMid.x + 50, screenMid.y - 50, screenMid.y + 50);
                this.originLines.clear();
                this.originLines.addAll(this.originBox.asEdges());
            }
        }
    }

    public void resetDrag() {
        this.blueprint.start().ifPresent(s -> {
            this.displayOffset = s.position();
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.method_25398(true);
            this.dragStart = new Vector2i((int)mouseX, (int)mouseY);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.method_25397()) {
            int xOff = (int)mouseX - this.dragStart.x;
            int yOff = (int)mouseY - this.dragStart.y;
            this.displayOffset = this.displayOffset.add(xOff, yOff);
            this.method_25398(false);
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int prevScale = renderScale;
        renderScale = class_3532.method_15340((int)(renderScale + (int)verticalAmount), (int)1, (int)500);
        float delta = (float)renderScale / (float)prevScale;
        float offX = (float)this.displayOffset.x * delta;
        float offY = (float)this.displayOffset.y * delta;
        this.displayOffset = new Vector2i((int)offX, (int)offY);
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public static enum State {
        BLUEPRINT,
        DEBUG;

    }
}

