/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.client.screen.DungeonScreen;
import com.lying.grammar.RoomMetadata;
import com.lying.grid.GridTile;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.CompoundBox2f;
import com.lying.utility.LineSegment2f;
import com.lying.utility.RotaryBox2f;
import com.lying.utility.Vector2iUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class NodeRenderUtils {
    public static final int TILE_SIZE = 2;
    public static final int LIGHT_BLUE = 1931253;
    public static final int LIME_GREEN = 1963319;
    public static final int DARK_GRAY = 0x6E6E6E;
    public static final int PALE_RED = 12071988;
    public static final int GOLD = 0xFFBF00;
    public static final class_124[] LINE_COLOURS = new class_124[]{class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1077, class_124.field_1060, class_124.field_1075, class_124.field_1062, class_124.field_1058, class_124.field_1078, class_124.field_1076, class_124.field_1064, class_124.field_1068, class_124.field_1080, class_124.field_1063, class_124.field_1074};
    private static int colourIndex = 0;

    public static Function<LineSegment2f, LineSegment2f> scaleFunc(int renderScale, Vector2i origin) {
        class_241 vec = new class_241((float)origin.x, (float)origin.y);
        return p -> p.scale(renderScale).offset(vec);
    }

    public static void render(BlueprintRoom node, class_332 context, class_327 textRenderer, Vector2i origin, Blueprint chart, Map<Blueprint.ErrorType, Integer> errors, int mouseX, int mouseY, int renderScale) {
        chart.forEach(n -> NodeRenderUtils.renderNodeBounds(n, chart.stream().filter(n2 -> !n2.equals(n)).anyMatch(n::intersects), origin, renderScale, context));
        colourIndex = 0;
        NodeRenderUtils.renderLinks(origin, renderScale, chart, !errors.isEmpty(), context, mouseX, mouseY);
        if (DungeonScreen.showCriticalPath) {
            NodeRenderUtils.renderCriticalPath(origin, renderScale, chart, context);
        }
        chart.forEach(n -> NodeRenderUtils.renderNode(n, origin, renderScale, context, textRenderer, mouseX, mouseY));
    }

    public static void renderLinks(Vector2i origin, int renderScale, Blueprint chart, boolean errorsPresent, class_332 context, int mouseX, int mouseY) {
        Function<LineSegment2f, LineSegment2f> scaleFunc = NodeRenderUtils.scaleFunc(renderScale, origin);
        class_241 mousePos = new class_241((float)mouseX, (float)mouseY);
        Predicate<BlueprintPassage> showBounds = p -> {
            CompoundBox2f box = (CompoundBox2f)p.tileBounds();
            for (AbstractBox2f sub : box.asBoxes()) {
                class_241 d;
                class_241 c;
                class_241 b;
                ArrayList points = Lists.newArrayList();
                points.addAll(sub.asPoints());
                class_241 a = ((class_241)points.removeFirst()).method_35582((float)renderScale).method_35586(new class_241((float)origin.x, (float)origin.y));
                if (!new RotaryBox2f(a, b = ((class_241)points.removeFirst()).method_35582((float)renderScale).method_35586(new class_241((float)origin.x, (float)origin.y)), c = ((class_241)points.removeFirst()).method_35582((float)renderScale).method_35586(new class_241((float)origin.x, (float)origin.y)), d = ((class_241)points.removeFirst()).method_35582((float)renderScale).method_35586(new class_241((float)origin.x, (float)origin.y))).contains(mousePos)) continue;
                return true;
            }
            return false;
        };
        DungeonScreen.totalPassages.stream().forEach(p -> {
            int n = errorsPresent ? (p.intersectsOtherPassages(chart) ? 1931253 : (p.intersectsOtherRooms(chart) ? 1963319 : 0x6E6E6E)) : LINE_COLOURS[colourIndex++ % LINE_COLOURS.length].method_532();
            int linkColour = n;
            NodeRenderUtils.renderPath(p, scaleFunc, origin, renderScale, context, linkColour, showBounds.test((BlueprintPassage)p));
        });
    }

    public static void renderCriticalPath(Vector2i origin, int renderScale, Blueprint chart, class_332 context) {
        if (DungeonScreen.criticalPath.isEmpty()) {
            return;
        }
        Function<LineSegment2f, LineSegment2f> scaleFunc = NodeRenderUtils.scaleFunc(renderScale, origin);
        DungeonScreen.criticalPath.forEach(path -> NodeRenderUtils.renderPath(path, scaleFunc, origin, renderScale, context, 0xFFBF00, false));
    }

    public static void renderNodeBounds(BlueprintRoom node, boolean isColliding, Vector2i origin, int renderScale, class_332 context) {
        RoomMetadata metadata = node.metadata();
        int mainColour = isColliding ? 12071988 : metadata.type().colour();
        int borderColour = isColliding ? 12071988 : 0x6E6E6E;
        Vector2i boundsMin = node.tileMin().toVec2i().mul(2);
        Vector2i boundsMax = node.tileMax().toVec2i().mul(2);
        Vector2i shellWidth = new Vector2i(1, 1);
        Vector2i shellMin = Vector2iUtils.copy(boundsMin).sub((Vector2ic)shellWidth);
        Vector2i shellMax = Vector2iUtils.copy(boundsMax).add((Vector2ic)shellWidth);
        shellMin = shellMin.mul(renderScale).add((Vector2ic)origin);
        shellMax = shellMax.mul(renderScale).add((Vector2ic)origin);
        NodeRenderUtils.renderBoundary(shellMin, shellMax, context, class_9848.method_61330((int)130, (int)borderColour));
        node.tileGrid().contents().forEach(tile -> NodeRenderUtils.renderTile(tile, origin, renderScale, context, class_9848.method_61330((int)75, (int)borderColour)));
        boundsMin = boundsMin.mul(renderScale).add((Vector2ic)origin);
        boundsMax = boundsMax.mul(renderScale).add((Vector2ic)origin);
        NodeRenderUtils.renderBoundary(boundsMin, boundsMax, context, class_9848.method_61330((int)255, (int)mainColour));
    }

    public static void renderBoundary(Vector2i min, Vector2i max, class_332 context, int colour) {
        int sizeX = max.x - min.x;
        int sizeY = max.y - min.y;
        context.method_49601(min.x, min.y, sizeX, sizeY, colour);
    }

    public static void renderBox(Box2f box, class_332 context, int colour) {
        context.method_49601((int)box.minX(), (int)box.minY(), (int)(box.maxX() - box.minX()), (int)(box.maxY() - box.minY()), colour);
    }

    public static void renderNode(BlueprintRoom node, Vector2i origin, int renderScale, class_332 context, class_327 textRenderer, int mouseX, int mouseY) {
        RoomMetadata metadata = node.metadata();
        Vector2i pos = node.position().mul(renderScale).add((Vector2ic)origin);
        int iconColour = class_9848.method_61330((int)255, (int)metadata.type().colour());
        context.method_25291(class_1921::method_62277, DungeonScreen.ICON_TEX, pos.x - 8, pos.y - 8, 0.0f, 0.0f, 16, 16, 16, 16, iconColour);
        if (pos.distance(mouseX, mouseY) < 8.0) {
            class_5250 title = metadata.name();
            int n = pos.x - textRenderer.method_27525((class_5348)title) / 2;
            int n2 = pos.y;
            Objects.requireNonNull(textRenderer);
            context.method_51439(textRenderer, (class_2561)title, n, n2 - 9 / 2, 0xFFFFFF, true);
        }
    }

    public static void renderPath(BlueprintPassage path, Function<LineSegment2f, LineSegment2f> scaleFunc, Vector2i origin, int renderScale, class_332 context, int colour, boolean showBounds) {
        path.tiles().forEach(tile -> NodeRenderUtils.renderTile(tile, origin, renderScale, context, class_9848.method_61330((int)75, (int)colour)));
        path.asLines().stream().map(scaleFunc).forEach(l -> NodeRenderUtils.renderGradientStraightLine(l, context, colour, 0xFFFFFF));
    }

    public static void renderTile(GridTile tile, Vector2i origin, int renderScale, class_332 context, int colour) {
        GridTile min = tile.copy();
        GridTile max = min.add(1, 1);
        NodeRenderUtils.renderBoundary(min.toVec2i().mul(2).mul(renderScale).add((Vector2ic)origin), max.toVec2i().mul(2).mul(renderScale).add((Vector2ic)origin), context, colour);
    }

    public static void renderGradientStraightLine(LineSegment2f line, class_332 context, int startRGB, int endRGB) {
        NodeRenderUtils.renderGradientStraightLine(line, 1, context, startRGB, endRGB);
    }

    public static void renderGradientStraightLine(LineSegment2f line, class_332 context, int startRGB) {
        NodeRenderUtils.renderGradientStraightLine(line, 1, context, startRGB, startRGB);
    }

    public static void renderGradientStraightLine(LineSegment2f line, int thickness, class_332 context, int startRGB, int endRGB) {
        NodeRenderUtils.renderGradientStraightLine(line.getLeft(), line.getRight(), thickness, context, startRGB, endRGB);
    }

    public static void renderGradientStraightLine(class_241 start, class_241 end, int thickness, class_332 context, int startRGB, int endRGB) {
        class_241 st = new class_241(start.field_1343, start.field_1342);
        class_241 en = new class_241(end.field_1343, end.field_1342);
        class_241 dir = en.method_35586(st.method_35588());
        class_241 nor = new class_241(-dir.field_1342, dir.field_1343).method_35581();
        int colStart = class_9848.method_61324((int)255, (int)class_9848.method_61327((int)startRGB), (int)class_9848.method_61329((int)startRGB), (int)class_9848.method_61331((int)startRGB));
        int colEnd = class_9848.method_61324((int)255, (int)class_9848.method_61327((int)endRGB), (int)class_9848.method_61329((int)endRGB), (int)class_9848.method_61331((int)endRGB));
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(start.field_1343, start.field_1342, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotation((float)Math.atan2(end.field_1342 - start.field_1342, end.field_1343 - start.field_1343)));
        class_241 a = st.method_35586(nor.method_35588());
        class_241 b = st.method_35586(nor);
        class_241 c = en.method_35586(nor);
        class_241 d = en.method_35586(nor.method_35588());
        Matrix4f matrix4f = new class_4587().method_23760().method_23761();
        class_4597.class_4598 provider = class_310.method_1551().method_22940().method_23000();
        class_4588 vertexConsumer = provider.getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, a.field_1343, a.field_1342, 0.0f).method_39415(colStart);
        vertexConsumer.method_22918(matrix4f, b.field_1343, b.field_1342, 0.0f).method_39415(colStart);
        vertexConsumer.method_22918(matrix4f, c.field_1343, c.field_1342, 0.0f).method_39415(colEnd);
        vertexConsumer.method_22918(matrix4f, d.field_1343, d.field_1342, 0.0f).method_39415(colEnd);
        matrixStack.method_22909();
    }

    public static void renderStraightLine(LineSegment2f line, int thickness, class_332 context, int rgb) {
        NodeRenderUtils.renderStraightLine(line.getLeft(), line.getRight(), thickness, context, rgb);
    }

    public static void renderStraightLine(class_241 start, class_241 end, int thickness, class_332 context, int rgb) {
        class_241 st = new class_241(start.field_1343, start.field_1342);
        class_241 en = new class_241(end.field_1343, end.field_1342);
        class_241 dir = en.method_35586(st.method_35588());
        float len = dir.method_35584();
        int colStart = class_9848.method_61324((int)255, (int)class_9848.method_61327((int)rgb), (int)class_9848.method_61329((int)rgb), (int)class_9848.method_61331((int)rgb));
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(start.field_1343, start.field_1342, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotation((float)Math.atan2(end.field_1342 - start.field_1342, end.field_1343 - start.field_1343)));
        context.method_25294(0, -thickness, (int)len, thickness, colStart);
        matrixStack.method_22909();
    }
}

