/*
 * Decompiled with CFR 0.152.
 */
package com.lying.command;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintOrganiser;
import com.lying.blueprint.BlueprintScruncher;
import com.lying.grammar.CDGrammar;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.network.ShowDungeonLayoutPacket;
import com.lying.reference.Reference;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class CDCommands {
    private static final SimpleCommandExceptionType PHRASE_PARSE_FAILED_EXCEPTION = CDCommands.make("phrase_parse_failed");
    private static final SimpleCommandExceptionType GRAPH_FAILED_EXCEPTION = CDCommands.make("graph_failed");
    private static final SimpleCommandExceptionType SCRUNCH_FAILED_EXCEPTION = CDCommands.make("scrunch_failed");
    private static final SimpleCommandExceptionType GENERATION_FAILED_EXCEPTION = CDCommands.make("generation_failed");

    private static SimpleCommandExceptionType make(String name) {
        return new SimpleCommandExceptionType((Message)Reference.ModInfo.translate("command", name.toLowerCase()));
    }

    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, access, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cydun").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"parse").then(class_2170.method_9244((String)"phrase", (ArgumentType)class_2179.method_9284()).executes(context -> CDCommands.tryParsePhrase(class_2179.method_9285((CommandContext)context, (String)"phrase"), (class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"preview").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"phrase", (ArgumentType)class_2179.method_9284()).executes(context -> CDCommands.tryPreview(class_2179.method_9285((CommandContext)context, (String)"phrase"), class_5819.method_43047(), (class_2168)context.getSource()))).then(class_2170.method_9244((String)"seed", (ArgumentType)class_2262.method_9698()).executes(context -> CDCommands.tryPreview(class_2179.method_9285((CommandContext)context, (String)"phrase"), class_5819.method_43049((long)CDCommands.getRandSeed((CommandContext<class_2168>)context, "seed")), (class_2168)context.getSource()))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CDCommands.tryPreview(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), class_5819.method_43047(), (class_2168)context.getSource()))).then(class_2170.method_9244((String)"seed", (ArgumentType)class_2262.method_9698()).executes(context -> CDCommands.tryPreview(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), class_5819.method_43049((long)CDCommands.getRandSeed((CommandContext<class_2168>)context, "seed")), (class_2168)context.getSource())))))).then(class_2170.method_9247((String)"generate").then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> CDCommands.generateInWorld(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), class_2262.method_48299((CommandContext)context, (String)"position"), (class_2168)context.getSource())))))));
    }

    public static GrammarPhrase parsePhrase(class_2487 nbt) throws CommandSyntaxException {
        if (nbt.method_10573("Phrase", 9)) {
            class_2499 phrase = nbt.method_10554("Phrase", 8);
            if (phrase.isEmpty()) {
                throw PHRASE_PARSE_FAILED_EXCEPTION.create();
            }
            ArrayList terms = Lists.newArrayList();
            phrase.forEach(e -> terms.add(e.method_10714()));
            return GrammarPhrase.parsePhrase(terms.toArray(new String[0]));
        }
        throw PHRASE_PARSE_FAILED_EXCEPTION.create();
    }

    private static int tryParsePhrase(class_2487 nbt, class_2168 source) throws CommandSyntaxException {
        GrammarPhrase graph = CDCommands.parsePhrase(nbt);
        if (graph.isEmpty()) {
            throw PHRASE_PARSE_FAILED_EXCEPTION.create();
        }
        if (source.method_44023() != null) {
            ShowDungeonLayoutPacket.sendTo(source.method_44023(), graph, false);
        }
        return graph.size();
    }

    private static int tryPreview(class_2487 nbt, class_5819 rand, class_2168 source) throws CommandSyntaxException {
        GrammarPhrase graph = CDCommands.parsePhrase(nbt);
        if (graph.isEmpty()) {
            throw PHRASE_PARSE_FAILED_EXCEPTION.create();
        }
        CDGrammar.generate(graph, rand);
        if (source.method_44023() != null) {
            ShowDungeonLayoutPacket.sendTo(source.method_44023(), graph, true);
        }
        return graph.size();
    }

    private static int tryPreview(int size, class_5819 rand, class_2168 source) {
        GrammarPhrase graph = CDGrammar.initialGraph(size, rand);
        CDGrammar.generate(graph, rand);
        if (source.method_44023() != null) {
            ShowDungeonLayoutPacket.sendTo(source.method_44023(), graph, true);
        }
        return graph.size();
    }

    private static class_2561 roomToText(GrammarRoom r) {
        return class_2561.method_43470((String)"  ".repeat(r.metadata().depth())).method_10852((class_2561)r.name());
    }

    private static int getRandSeed(CommandContext<class_2168> context, String name) {
        class_2338 position = class_2262.method_48299(context, (String)name);
        return position.method_10263() * position.method_10263() + position.method_10260() * position.method_10260();
    }

    private static int generateInWorld(int size, class_2338 position, class_2168 source) throws CommandSyntaxException {
        class_5819 rand = class_5819.method_43049((long)(position.method_10263() * position.method_10263() + position.method_10260() * position.method_10260()));
        GrammarPhrase graph = CDGrammar.initialGraph(size, rand);
        CDGrammar.generate(graph, rand);
        Blueprint blueprint = Blueprint.fromGraph(graph);
        blueprint.forEach(node -> node.metadata().setSize(node.metadata().type().size(rand)));
        BlueprintOrganiser.Circular.create().organise(blueprint, rand);
        if (blueprint.hasErrors()) {
            throw GRAPH_FAILED_EXCEPTION.create();
        }
        BlueprintScruncher.collapse(blueprint, false);
        if (blueprint.hasErrors()) {
            throw SCRUNCH_FAILED_EXCEPTION.create();
        }
        class_3218 world = source.method_9225();
        if (!blueprint.build(position, world)) {
            throw GENERATION_FAILED_EXCEPTION.create();
        }
        return 15;
    }
}

