/*
 * Decompiled with CFR 0.152.
 */
package com.lying.fabric.client;

import com.lying.block.BladeBlock;
import com.lying.block.CollisionSensorBlock;
import com.lying.block.HatchActorBlock;
import com.lying.block.ProximitySensorBlock;
import com.lying.block.SightSensorBlock;
import com.lying.block.SoundSensorBlock;
import com.lying.block.SwingingBladeBlock;
import com.lying.init.CDBlocks;
import com.lying.init.CDItems;
import com.lying.reference.Reference;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10410;
import net.minecraft.class_10411;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_5705;
import net.minecraft.class_7923;

public class CDModelProvider
extends FabricModelProvider {
    public CDModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        CDBlocks.SOLID_CUBES.forEach(entry -> blockStateModelGenerator.method_25641((class_2248)entry.get()));
        this.registerUnrotatedPillar((class_2248)CDBlocks.TRAP_LOGIC.get(), blockStateModelGenerator);
        blockStateModelGenerator.method_25672((class_2248)CDBlocks.TRAP_LOGIC.get(), (class_2248)CDBlocks.TRAP_LOGIC_DECOY.get());
        this.registerTrapBlockStates(blockStateModelGenerator);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        CDItems.BASIC_BLOCK_ITEMS.stream().map(e -> (class_1747)e.get()).forEach(entry -> CDModelProvider.registerBlockModel(entry, itemModelGenerator));
        CDModelProvider.registerSimpleItem((class_1792)CDItems.PIT.get(), itemModelGenerator);
        CDModelProvider.registerBlockModel((class_1747)CDItems.SWINGING_BLADE.get(), "_horizontal", itemModelGenerator);
    }

    private void registerTrapBlockStates(class_4910 generator) {
        this.registerPowerablePillar((class_2248)CDBlocks.SENSOR_REDSTONE.get(), generator);
        PressureSensor.register((class_2248)CDBlocks.SENSOR_COLLISION.get(), class_2246.field_10093, generator);
        SoundSensor.register((class_2248)CDBlocks.SENSOR_SOUND.get(), generator);
        SightSensor.register((class_2248)CDBlocks.SENSOR_SIGHT.get(), generator);
        ProximitySensor.register((class_2248)CDBlocks.SENSOR_PROXIMITY.get(), generator);
        generator.method_25542((class_2248)CDBlocks.PIT.get(), (class_1792)CDItems.PIT.get());
        this.registerPowerablePillar((class_2248)CDBlocks.ACTOR_REDSTONE.get(), generator);
        HatchActor.register((class_2248)CDBlocks.STONE_BRICK_HATCH.get(), class_2246.field_10056, generator);
        HatchActor.register((class_2248)CDBlocks.STONE_HATCH.get(), class_2246.field_10340, generator);
        HatchActor.register((class_2248)CDBlocks.COBBLESTONE_HATCH.get(), class_2246.field_10445, generator);
        HatchActor.registerGrass((class_2248)CDBlocks.GRASS_HATCH.get(), generator);
        HatchActor.register((class_2248)CDBlocks.DIRT_HATCH.get(), class_2246.field_10566, generator);
        SwingingBlade.registerBlade((class_2248)CDBlocks.BLADE.get(), generator);
        SwingingBlade.register((class_2248)CDBlocks.SWINGING_BLADE.get(), generator);
    }

    public void registerUnrotatedPillar(class_2248 block, class_4910 generator) {
        class_4944 map = class_4944.method_25894((class_2248)block).method_25868(class_4945.field_23012, class_4944.method_25866((class_2248)block, (String)"_side"));
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)class_4943.field_22974.method_25846(block, map, generator.field_22831)));
    }

    private void registerPowerablePillar(class_2248 block, class_4910 generator) {
        Function<class_2960, class_4944> texMapFunc = id -> {
            class_4944 map = new class_4944();
            class_2960 topTex = class_4944.method_25866((class_2248)((class_2248)CDBlocks.TRAP_LOGIC.get()), (String)"_top");
            map.method_25868(class_4945.field_23013, topTex);
            map.method_25868(class_4945.field_23012, topTex);
            map.method_25868(class_4945.field_23018, id);
            return map;
        };
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(CDModelProvider.createBooleanModelMap(class_2741.field_12484, this.createSubModel(block, "_on", class_4943.field_22974, texMapFunc, generator.field_22831), class_4943.field_22974.method_25846(block, texMapFunc.apply(class_4944.method_25860((class_2248)block)), generator.field_22831))));
    }

    private static void registerSimpleItem(class_1792 item, class_4915 generator) {
        class_4944 map = class_4944.method_25871((class_1792)item);
        class_2960 reg = class_4941.method_25840((class_1792)item);
        class_2960 model = class_4943.field_22938.method_25852(reg, map, generator.field_55246);
        generator.field_55245.method_65460(item, class_10410.method_65481((class_2960)model));
    }

    private static void registerBlockModel(class_1747 item, class_4915 generator) {
        CDModelProvider.registerBlockModel(item, "", generator);
    }

    private static void registerBlockModel(class_1747 item, String suffix, class_4915 generator) {
        generator.method_65442((class_1792)item, CDModelProvider.makeBlockModel(item, suffix));
    }

    private static class_4942 makeBlockModel(class_1747 item, String suffix) {
        class_2248 block = item.method_7711();
        class_2960 reg = class_7923.field_41175.method_10221((Object)block);
        return new class_4942(Optional.of(class_2960.method_60655((String)reg.method_12836(), (String)("block/" + reg.method_12832() + suffix))), Optional.empty(), new class_4945[0]);
    }

    private class_2960 createSubModel(class_2248 block, String suffix, class_4942 model, Function<class_2960, class_4944> texturesFactory, BiConsumer<class_2960, class_10411> modelCollector) {
        return model.method_25847(block, suffix, texturesFactory.apply(class_4944.method_25866((class_2248)block, (String)suffix)), modelCollector);
    }

    private static class_4926 createBooleanModelMap(class_2746 property, class_2960 trueModel, class_2960 falseModel) {
        return class_4926.method_25783((class_2769)property).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)trueModel)).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)falseModel));
    }

    private static void appendSettings(class_2350 face, class_4936.class_4937 x, class_4936.class_4937 y, class_4926.class_4928<class_2350, Boolean> variants, class_2960 model, class_2960 modelOn) {
        Function<Boolean, class_4935> func = phase -> {
            class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(phase != false ? modelOn : model));
            if (x != class_4936.class_4937.field_22890) {
                variant.method_25828(class_4936.field_22885, (Object)x);
            }
            if (y != class_4936.class_4937.field_22890) {
                variant.method_25828(class_4936.field_22886, (Object)y);
            }
            return variant;
        };
        variants.method_25797((Comparable)face, (Comparable)Boolean.valueOf(false), func.apply(false));
        variants.method_25797((Comparable)face, (Comparable)Boolean.valueOf(true), func.apply(true));
    }

    private static class PressureSensor {
        private static final class_4942 SENSOR = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_pressure_sensor")), Optional.empty(), new class_4945[]{class_4945.field_23011});
        private static final class_4942 SENSOR_PRESSED = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_pressure_sensor_pressed")), Optional.of("_pressed"), new class_4945[]{class_4945.field_23011});

        private PressureSensor() {
        }

        private static void register(class_2248 block, class_2248 texture, class_4910 generator) {
            class_4944 map = class_4944.method_25872((class_2248)texture);
            class_2960 model = SENSOR.method_25846(block, map, generator.field_22831);
            class_2960 modelOn = SENSOR_PRESSED.method_25846(block, map, generator.field_22831);
            class_4926.class_4928 variants = class_4926.method_25784(CollisionSensorBlock.FACING, (class_2769)CollisionSensorBlock.POWERED);
            CDModelProvider.appendSettings(class_2350.field_11036, class_4936.class_4937.field_22890, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11033, class_4936.class_4937.field_22892, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11043, class_4936.class_4937.field_22891, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11035, class_4936.class_4937.field_22891, class_4936.class_4937.field_22892, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11034, class_4936.class_4937.field_22891, class_4936.class_4937.field_22891, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11039, class_4936.class_4937.field_22891, class_4936.class_4937.field_22893, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }
    }

    private static class SoundSensor {
        private static final class_4945 TENDRILS = class_4945.method_27043((String)"tendrils");
        private static final class_2960 TENDRILS_ACTIVE = class_4944.method_25866((class_2248)class_2246.field_28108, (String)"_tendril_active");
        private static final class_2960 TENDRILS_INACTIVE = class_4944.method_25866((class_2248)class_2246.field_28108, (String)"_tendril_inactive");
        private static final class_4942 SENSOR = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_sound_sensor")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23018, class_4945.field_23015, TENDRILS});

        private SoundSensor() {
        }

        private static void register(class_2248 block, class_4910 generator) {
            class_4944 map = new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top"));
            class_2960 model = SENSOR.method_25846(block, map.method_25868(TENDRILS, TENDRILS_INACTIVE), generator.field_22831);
            class_2960 modelOn = SENSOR.method_25847(block, "_on", map.method_25868(TENDRILS, TENDRILS_ACTIVE), generator.field_22831);
            class_4926.class_4928 variants = class_4926.method_25784(SoundSensorBlock.FACING, SoundSensorBlock.PHASE);
            SoundSensor.appendSettings(class_2350.field_11036, class_4936.class_4937.field_22890, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            SoundSensor.appendSettings(class_2350.field_11033, class_4936.class_4937.field_22892, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            SoundSensor.appendSettings(class_2350.field_11043, class_4936.class_4937.field_22891, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            SoundSensor.appendSettings(class_2350.field_11035, class_4936.class_4937.field_22891, class_4936.class_4937.field_22892, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            SoundSensor.appendSettings(class_2350.field_11034, class_4936.class_4937.field_22891, class_4936.class_4937.field_22891, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            SoundSensor.appendSettings(class_2350.field_11039, class_4936.class_4937.field_22891, class_4936.class_4937.field_22893, (class_4926.class_4928<class_2350, class_5705>)variants, model, modelOn);
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }

        private static void appendSettings(class_2350 face, class_4936.class_4937 x, class_4936.class_4937 y, class_4926.class_4928<class_2350, class_5705> variants, class_2960 model, class_2960 modelOn) {
            Function<class_5705, class_4935> func = phase -> {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(phase == class_5705.field_28121 ? model : modelOn));
                if (x != class_4936.class_4937.field_22890) {
                    variant.method_25828(class_4936.field_22885, (Object)x);
                }
                if (y != class_4936.class_4937.field_22890) {
                    variant.method_25828(class_4936.field_22886, (Object)y);
                }
                return variant;
            };
            for (class_5705 phase2 : class_5705.values()) {
                variants.method_25797((Comparable)face, (Comparable)phase2, func.apply(phase2));
            }
        }
    }

    private static class SightSensor {
        private static final class_4945 EYE = class_4945.method_27043((String)"eye");
        private static final class_4942 SENSOR = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_sight_sensor")), Optional.empty(), new class_4945[]{class_4945.field_23018, EYE});

        private SightSensor() {
        }

        private static void register(class_2248 block, class_4910 generator) {
            class_4944 map = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side"));
            class_2960 model = SENSOR.method_25846(block, map.method_25868(EYE, class_4944.method_25860((class_2248)block)), generator.field_22831);
            class_2960 modelOn = SENSOR.method_25847(block, "_on", map.method_25868(EYE, class_4944.method_25866((class_2248)block, (String)"_on")), generator.field_22831);
            class_4926.class_4927 variants = class_4926.method_25783((class_2769)SightSensorBlock.POWERED).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelOn));
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }
    }

    private static class ProximitySensor {
        private static final class_4942 SENSOR = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_proximity_sensor")), Optional.empty(), new class_4945[]{class_4945.field_23011});

        private ProximitySensor() {
        }

        private static void register(class_2248 block, class_4910 generator) {
            class_4944 map = class_4944.method_25872((class_2248)block);
            class_2960 model = SENSOR.method_25846(block, map, generator.field_22831);
            class_2960 modelOn = SENSOR.method_25847(block, "_on", map.method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)block, (String)"_on")), generator.field_22831);
            class_4926.class_4928 variants = class_4926.method_25784(ProximitySensorBlock.FACING, (class_2769)ProximitySensorBlock.POWERED);
            CDModelProvider.appendSettings(class_2350.field_11036, class_4936.class_4937.field_22890, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11033, class_4936.class_4937.field_22892, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11043, class_4936.class_4937.field_22891, class_4936.class_4937.field_22890, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11035, class_4936.class_4937.field_22891, class_4936.class_4937.field_22892, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11034, class_4936.class_4937.field_22891, class_4936.class_4937.field_22891, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            CDModelProvider.appendSettings(class_2350.field_11039, class_4936.class_4937.field_22891, class_4936.class_4937.field_22893, (class_4926.class_4928<class_2350, Boolean>)variants, model, modelOn);
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }
    }

    private static class HatchActor {
        private static final class_4942 MODEL = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_hatch_block")), Optional.empty(), new class_4945[]{class_4945.field_23011});
        private static final class_4942 MODEL_OPEN = new class_4942(Optional.of(Reference.ModInfo.prefix("block/template_hatch_block_open")), Optional.of("_open"), new class_4945[]{class_4945.field_23011});

        private HatchActor() {
        }

        private static void registerGrass(class_2248 block, class_4910 generator) {
            HatchActor.register(block, class_4944.method_25866((class_2248)class_2246.field_10219, (String)"_top"), generator);
        }

        private static void register(class_2248 block, class_2248 emulated, class_4910 generator) {
            HatchActor.register(block, class_4944.method_25860((class_2248)emulated), generator);
        }

        private static void register(class_2248 block, class_2960 texture, class_4910 generator) {
            class_4944 map = class_4944.method_25869((class_2960)texture);
            class_2960 model = MODEL.method_25846(block, map, generator.field_22831);
            class_2960 modelOn = MODEL_OPEN.method_25846(block, map, generator.field_22831);
            class_2960 modelVoid = class_4943.field_22908.method_25847(block, "_interstitial", class_4944.method_25891((class_2960)texture), generator.field_22831);
            class_4926.class_4929 variants = class_4926.method_25785((class_2769)HatchActorBlock.POWERED, (class_2769)HatchActorBlock.INTERSTITIAL, HatchActorBlock.FACING);
            HatchActor.appendSettings(class_2350.field_11043, class_4936.class_4937.field_22890, (class_4926.class_4929<Boolean, Boolean, class_2350>)variants, model, modelOn, modelVoid);
            HatchActor.appendSettings(class_2350.field_11034, class_4936.class_4937.field_22891, (class_4926.class_4929<Boolean, Boolean, class_2350>)variants, model, modelOn, modelVoid);
            HatchActor.appendSettings(class_2350.field_11035, class_4936.class_4937.field_22892, (class_4926.class_4929<Boolean, Boolean, class_2350>)variants, model, modelOn, modelVoid);
            HatchActor.appendSettings(class_2350.field_11039, class_4936.class_4937.field_22893, (class_4926.class_4929<Boolean, Boolean, class_2350>)variants, model, modelOn, modelVoid);
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }

        private static void appendSettings(class_2350 face, class_4936.class_4937 y, class_4926.class_4929<Boolean, Boolean, class_2350> map, class_2960 model, class_2960 modelOn, class_2960 modelVoid) {
            Function<class_4935, class_4935> rotator = v -> y == class_4936.class_4937.field_22890 ? v : v.method_25828(class_4936.field_22886, (Object)y);
            map.method_25806((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Comparable)face, rotator.apply(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true)));
            map.method_25806((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Comparable)face, rotator.apply(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true)));
            map.method_25806((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Comparable)face, rotator.apply(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelOn)));
            map.method_25806((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Comparable)face, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelVoid));
        }
    }

    private static class SwingingBlade {
        private SwingingBlade() {
        }

        private static void registerBlade(class_2248 block, class_4910 generator) {
            class_4926.class_4927 map = class_4926.method_25783(BladeBlock.PART).method_25793((Comparable)((Object)BladeBlock.Part.MOUNT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)block, (String)"_mount"))).method_25793((Comparable)((Object)BladeBlock.Part.ARM), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)block, (String)"_arm"))).method_25793((Comparable)((Object)BladeBlock.Part.BLADE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4944.method_25866((class_2248)block, (String)"_end")));
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)map));
        }

        private static void register(class_2248 block, class_4910 generator) {
            class_4926.class_4928 variants = class_4926.method_25784(SwingingBladeBlock.FACING, SwingingBladeBlock.AXIS);
            class_2960 wallHorizontalModel = class_4944.method_25866((class_2248)block, (String)"_horizontal");
            class_2960 wallVerticalModel = class_4944.method_25866((class_2248)block, (String)"_vertical");
            for (class_2350 face : class_2350.values()) {
                variants.method_25797((Comparable)face, (Comparable)face.method_10166(), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel));
            }
            variants.method_25797((Comparable)class_2350.field_11036, (Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893));
            variants.method_25797((Comparable)class_2350.field_11036, (Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893));
            variants.method_25797((Comparable)class_2350.field_11033, (Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
            variants.method_25797((Comparable)class_2350.field_11033, (Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
            variants.method_25797((Comparable)class_2350.field_11043, (Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel));
            variants.method_25797((Comparable)class_2350.field_11043, (Comparable)class_2350.class_2351.field_11052, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel));
            variants.method_25797((Comparable)class_2350.field_11034, (Comparable)class_2350.class_2351.field_11052, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
            variants.method_25797((Comparable)class_2350.field_11034, (Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
            variants.method_25797((Comparable)class_2350.field_11035, (Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
            variants.method_25797((Comparable)class_2350.field_11035, (Comparable)class_2350.class_2351.field_11052, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
            variants.method_25797((Comparable)class_2350.field_11039, (Comparable)class_2350.class_2351.field_11052, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallVerticalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
            variants.method_25797((Comparable)class_2350.field_11039, (Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)wallHorizontalModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
            generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)variants));
        }
    }
}

