/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import com.lying.init.CDLoggers;
import com.lying.init.CDTerms;
import com.lying.utility.CDUtils;
import com.lying.utility.DebugLogger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5819;
import org.apache.commons.lang3.tuple.Pair;

public class CDGrammar {
    private static final DebugLogger LOGGER = CDLoggers.GRAMMAR;
    public static final List<GrammarTerm> PLACEABLE = CDTerms.placeables();

    public static GrammarPhrase initialGraph(int blanks) {
        return CDGrammar.initialGraph(blanks, class_5819.method_43047());
    }

    public static GrammarPhrase initialGraph(int blanks, class_5819 rand) {
        GrammarPhrase graph = new GrammarPhrase();
        GrammarRoom start = new GrammarRoom();
        start.metadata().setType(CDTerms.START.get());
        graph.add(start);
        GrammarRoom previous = start;
        for (int i = 0; i < blanks; ++i) {
            GrammarRoom blank = new GrammarRoom();
            previous.linkTo(blank);
            graph.add(blank);
            if (previous.canAddLink() && rand.method_43056()) continue;
            previous = blank;
        }
        GrammarRoom end = new GrammarRoom();
        end.metadata().setType(CDTerms.END.get());
        previous.linkTo(end);
        graph.add(end);
        return graph;
    }

    public static GrammarPhrase generate(GrammarPhrase graph) {
        return CDGrammar.generate(graph, class_5819.method_43047());
    }

    public static GrammarPhrase generate(GrammarPhrase graph, class_5819 rand) {
        int iterationCap = 5;
        while (!graph.isEmpty() && graph.hasBlanks() && --iterationCap > 0) {
            CDGrammar.recursiveGenerate(graph.get(0).get(), graph, rand);
        }
        LOGGER.info(" # Generated {}:{} graph", graph.size(), graph.depth());
        return graph;
    }

    private static void recursiveGenerate(GrammarRoom room, GrammarPhrase graph, class_5819 rand) {
        CDGrammar.generate(room, graph, rand);
        room.getChildRooms(graph).forEach(r -> CDGrammar.recursiveGenerate(r, graph, rand));
    }

    private static void generate(GrammarRoom room, GrammarPhrase graph, class_5819 rand) {
        if (!room.metadata().isReplaceable()) {
            return;
        }
        List<GrammarRoom> previous = room.getParentRooms(graph);
        List<GrammarRoom> next = room.getChildRooms(graph);
        GrammarTerm term = CDTerms.VOID.get();
        List<GrammarTerm> candidates = PLACEABLE.stream().filter(t -> t.canBePlaced(room, previous, next, graph)).toList();
        if (!candidates.isEmpty()) {
            if (candidates.size() == 1) {
                term = candidates.get(0);
            } else {
                ArrayList weights = Lists.newArrayList();
                for (GrammarTerm candidate : candidates) {
                    weights.add(Pair.of((Object)candidate, (Object)Float.valueOf(candidate.weight())));
                }
                term = (GrammarTerm)CDUtils.selectFromWeightedList(weights, rand.method_43057());
            }
        } else {
            LOGGER.warn("No candidates found to replace {}", room.name().getString());
        }
        room.applyTerm(term, graph);
    }
}

