/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import com.lying.grammar.RoomMetadata;
import com.lying.init.CDTerms;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrammarPhrase {
    public static final Codec<GrammarPhrase> CODEC = GrammarRoom.CODEC.listOf().xmap(GrammarPhrase::new, GrammarPhrase::rooms);
    List<GrammarRoom> rooms = Lists.newArrayList();

    public GrammarPhrase() {
    }

    protected GrammarPhrase(List<GrammarRoom> roomsIn) {
        this();
        this.rooms.addAll(roomsIn);
    }

    public static GrammarPhrase parsePhrase(String[] phrase) {
        GrammarPhrase graph = new GrammarPhrase();
        GrammarRoom prev = null;
        for (int i = 0; i < phrase.length; ++i) {
            Optional<GrammarTerm> term = CDTerms.get(phrase[i]);
            if (term.isEmpty()) continue;
            GrammarRoom room = new GrammarRoom();
            room.metadata().setType(term.get());
            if (prev != null) {
                prev.linkTo(room);
            }
            graph.add(room);
            prev = room;
        }
        return graph;
    }

    public GrammarPhrase clone() {
        return GrammarPhrase.fromNbt(this.toNbt());
    }

    public final class_2520 toNbt() {
        return (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
    }

    @NotNull
    public static GrammarPhrase fromNbt(@Nullable class_2520 element) {
        DataResult result;
        if (element != null && (result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)element)).isSuccess()) {
            return (GrammarPhrase)result.getOrThrow();
        }
        return new GrammarPhrase();
    }

    protected List<GrammarRoom> rooms() {
        return this.rooms;
    }

    public Optional<GrammarRoom> get(UUID idIn) {
        return this.rooms.stream().filter(r -> r.uuid().equals(idIn)).findAny();
    }

    public Optional<GrammarRoom> get(int index) {
        return index < this.rooms.size() ? Optional.of(this.rooms.get(index)) : Optional.empty();
    }

    @NotNull
    public List<GrammarRoom> getLinksTo(UUID uuid) {
        ArrayList links = Lists.newArrayList();
        links.addAll(this.rooms.stream().filter(r -> r.hasLinkTo(uuid)).toList());
        return links;
    }

    public int tally(GrammarTerm term) {
        return (int)this.rooms.stream().filter(r -> r.metadata().is(term)).count();
    }

    public boolean isEmpty() {
        return this.rooms.isEmpty();
    }

    public int size() {
        return this.rooms.size();
    }

    public Optional<GrammarRoom> getStart() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.rooms.get(0));
    }

    public boolean hasBlanks() {
        return this.rooms.stream().map(GrammarRoom::metadata).anyMatch(RoomMetadata::isReplaceable);
    }

    public List<GrammarRoom> getBlanks() {
        return this.rooms.stream().filter(r -> r.metadata().isReplaceable()).toList();
    }

    public int depth() {
        int max = Integer.MIN_VALUE;
        for (GrammarRoom room : this.rooms) {
            if (room.metadata().depth() <= max) continue;
            max = room.metadata().depth();
        }
        return max;
    }

    public void add(GrammarRoom roomIn) {
        this.rooms.add(roomIn);
        this.getStart().ifPresent(start -> {
            start.metadata().setDepth(0);
            this.updateDepth((GrammarRoom)start);
        });
    }

    protected void updateDepth(GrammarRoom host) {
        int depth = host.metadata().depth() + 1;
        if (host.hasLinks()) {
            host.getChildRooms(this).forEach(r -> {
                r.metadata().setDepth(depth);
                this.updateDepth((GrammarRoom)r);
            });
        }
    }

    public <T> void printAsTree(Consumer<T> print, Function<GrammarRoom, T> getter) {
        if (this.isEmpty()) {
            return;
        }
        this.getStart().ifPresent(start -> this.printRecursive(print, (GrammarRoom)start, getter));
    }

    private <T> void printRecursive(Consumer<T> print, GrammarRoom room, Function<GrammarRoom, T> getter) {
        print.accept(getter.apply(room));
        Comparator<GrammarRoom> sorter = GrammarRoom.branchSort(this);
        room.getChildRooms(this).stream().sorted(sorter).forEach(r -> this.printRecursive(print, (GrammarRoom)r, (Function)getter));
    }

    public String asString() {
        List<GrammarRoom> links;
        if (this.isEmpty()) {
            return "NULL";
        }
        GrammarRoom room = this.getStart().get();
        Object result = room.asString();
        while (room.hasLinks() && !(links = room.getChildRooms(this)).isEmpty()) {
            room = links.get(0);
            result = (String)result + " -> " + room.asString();
        }
        return result;
    }

    public class_2561 describe() {
        List<GrammarRoom> links;
        if (this.isEmpty()) {
            return class_2561.method_43470((String)"NULL");
        }
        GrammarRoom room = this.getStart().get();
        class_5250 result = room.name();
        while (room.hasLinks() && !(links = room.getChildRooms(this)).isEmpty()) {
            room = links.get(0);
            result = result.method_27693(" -> ").method_10852((class_2561)room.name());
        }
        return result;
    }
}

