/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.TermConditions;
import com.lying.grid.BlueprintTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.init.CDLoggers;
import com.lying.init.CDRoomTileSets;
import com.lying.init.CDTerms;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileGenerator;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public abstract class GrammarTerm {
    public static final DebugLogger LOGGER = CDLoggers.WORLDGEN;
    protected static final Codec<GrammarTerm> CODEC = class_2960.field_25139.comapFlatMap(id -> {
        Optional<GrammarTerm> type = CDTerms.get(id);
        if (type.isPresent()) {
            return DataResult.success((Object)type.get());
        }
        return DataResult.error(() -> "Not a recognised type: '" + String.valueOf(id) + "'");
    }, GrammarTerm::registryName);
    private final class_2960 registryName;
    private final int colour;
    private final class_1767 color;
    private final int weight;
    private final boolean isReplaceable;
    private final boolean isPlaceable;
    private final boolean isBranchInjector;
    private final TermConditions conditions;
    private final Function<class_5819, Vector2i> sizeFunc;
    private final Map<Tile, Float> tileSet;

    private GrammarTerm(class_2960 idIn, int weightIn, int colourIn, class_1767 colorIn, Function<class_5819, Vector2i> sizeFuncIn, boolean placeable, boolean replaceable, boolean injectsBranch, TermConditions conditionsIn, Map<Tile, Float> tileSetIn) {
        this.registryName = idIn;
        this.weight = weightIn;
        this.colour = colourIn;
        this.color = colorIn;
        this.sizeFunc = sizeFuncIn;
        this.conditions = conditionsIn;
        this.tileSet = tileSetIn;
        this.isPlaceable = placeable;
        this.isReplaceable = replaceable;
        this.isBranchInjector = injectsBranch;
    }

    public final class_2960 registryName() {
        return this.registryName;
    }

    public final int colour() {
        return this.colour;
    }

    public final class_1767 color() {
        return this.color;
    }

    public final int weight() {
        return this.weight;
    }

    public class_5250 name() {
        return class_2561.method_43470((String)this.registryName.method_12832());
    }

    public boolean matches(GrammarTerm b) {
        return this.registryName.equals((Object)b.registryName);
    }

    public boolean isReplaceable() {
        return this.isReplaceable;
    }

    public boolean isPlaceable() {
        return this.isPlaceable;
    }

    public boolean isBranchInjector() {
        return this.isBranchInjector;
    }

    public final boolean canBePlaced(GrammarRoom inRoom, @NotNull List<GrammarRoom> previous, @NotNull List<GrammarRoom> next, GrammarPhrase graph) {
        return (!this.isBranchInjector() || inRoom.canAddLink()) && this.conditions.test(this, inRoom, previous, next, graph);
    }

    public boolean generate(class_2338 position, class_3218 world, BlueprintRoom node, List<BlueprintPassage> passages) {
        BlueprintTileGrid map = BlueprintTileGrid.fromGraphGrid(node.tileGrid(), 4);
        GrammarTerm.preseedDoorways(node, map, passages);
        TileGenerator.generate(map, this.tileSet, world.method_8409());
        map.finalise();
        return map.generate(position, world);
    }

    protected static void preseedDoorways(BlueprintRoom node, BlueprintTileGrid map, List<BlueprintPassage> passages) {
        List<GraphTileGrid> connectingPassages = passages.stream().filter(p -> p.isTerminus(node)).map(BlueprintPassage::asTiles).toList();
        map.getBoundaries(class_2350.class_2353.field_11062.method_29716().toList()).stream().filter(t -> {
            GridTile tile = new GridTile(t.method_10263(), t.method_10260());
            return connectingPassages.stream().anyMatch(g -> g.containsAdjacent(tile));
        }).forEach(t -> map.put(t.method_33096(1), CDTiles.PASSAGE.get()));
    }

    public void applyTo(GrammarRoom room, GrammarPhrase graph) {
        room.metadata().setType(this);
        this.onApply(room, graph);
    }

    protected abstract void onApply(GrammarRoom var1, GrammarPhrase var2);

    public Vector2i size(class_5819 rand) {
        return this.sizeFunc.apply(rand);
    }

    public static GrammarRoom injectRoom(GrammarRoom room, GrammarPhrase graph) {
        GrammarRoom injected = new GrammarRoom();
        room.getChildLinks().forEach(uuid -> {
            Optional<GrammarRoom> child = graph.get((UUID)uuid);
            if (child.isEmpty()) {
                return;
            }
            injected.linkTo(child.get());
            room.detachFrom(child.get());
        });
        room.linkTo(injected);
        graph.add(injected);
        return injected;
    }

    public static GrammarRoom injectBranch(GrammarRoom room, GrammarPhrase graph) {
        GrammarRoom injected = new GrammarRoom();
        room.linkTo(injected);
        graph.add(injected);
        return injected;
    }

    protected static boolean checkListFor(@Nullable List<GrammarRoom> rooms, GrammarTerm term) {
        return rooms != null && !rooms.isEmpty() && rooms.stream().filter(Objects::nonNull).anyMatch(r -> r.metadata().is(term));
    }

    public static class Builder {
        private final int colour;
        private final class_1767 color;
        private int weight = 1;
        private boolean replaceable = false;
        private boolean placeable = true;
        private boolean afterSelf = true;
        private boolean deadEnds = true;
        private boolean injects = false;
        private int maxPop = -1;
        private int sizeCap = -1;
        private int depthMin = -1;
        private List<Supplier<GrammarTerm>> after = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> before = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> notAfter = Lists.newArrayList();
        private List<Supplier<GrammarTerm>> notBefore = Lists.newArrayList();
        private TermApplyFunc applyFunc = (t, r, g) -> {};
        private Function<class_5819, Vector2i> sizeFunc = r -> new Vector2i(3 + r.method_43048(4), 3 + r.method_43048(4));
        private Map<Tile, Float> tileSet = CDRoomTileSets.DEFAULT_TILESET;

        private Builder(int colourIn, class_1767 colorIn) {
            this.colour = colourIn;
            this.color = colorIn;
        }

        public static Builder create(int colour, class_1767 color) {
            return new Builder(colour, color);
        }

        public Builder unplaceable() {
            this.placeable = false;
            return this;
        }

        public Builder replaceable() {
            this.replaceable = true;
            return this;
        }

        public Builder injectsBranches() {
            this.injects = true;
            return this;
        }

        public Builder weight(int val) {
            this.weight = val;
            return this;
        }

        public Builder nonconsecutive() {
            this.afterSelf = false;
            return this;
        }

        public Builder afterDepth(int dep) {
            this.depthMin = dep;
            return this;
        }

        public Builder allowDeadEnds(boolean val) {
            this.deadEnds = val;
            return this;
        }

        public Builder popCap(int cap) {
            this.maxPop = cap;
            return this;
        }

        public Builder sizeCap(int cap) {
            this.sizeCap = cap;
            return this;
        }

        public Builder size(Function<class_5819, Vector2i> func) {
            this.sizeFunc = func;
            return this;
        }

        public Builder size(Vector2i vec) {
            this.sizeFunc = r -> vec;
            return this;
        }

        public Builder onlyAfter(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.after.add(termIn);
            }
            return this;
        }

        public Builder neverAfter(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.notAfter.add(termIn);
            }
            return this;
        }

        public Builder onlyBefore(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.before.add(termIn);
            }
            return this;
        }

        public Builder neverBefore(Supplier<GrammarTerm> ... term) {
            for (Supplier<GrammarTerm> termIn : term) {
                this.notBefore.add(termIn);
            }
            return this;
        }

        public Builder onApply(TermApplyFunc funcIn) {
            this.applyFunc = funcIn;
            return this;
        }

        public Builder withTileSet(Map<Tile, Float> tileSetIn) {
            this.tileSet = tileSetIn;
            return this;
        }

        public GrammarTerm build(class_2960 registryName) {
            TermConditions conditions = TermConditions.create().nonconsecutive(this.afterSelf).sizeCap(this.sizeCap).afterDepth(this.depthMin).popCap(this.maxPop).allowDeadEnds(this.deadEnds).onlyAfter(this.after).neverAfter(this.notAfter).onlyBefore(this.before).neverBefore(this.notBefore);
            return new GrammarTerm(registryName, this.weight, this.colour, this.color, this.sizeFunc, this.placeable, this.replaceable, this.injects, conditions, this.tileSet){

                @Override
                public void onApply(GrammarRoom room, GrammarPhrase graph) {
                    applyFunc.apply(this, room, graph);
                }
            };
        }

        @FunctionalInterface
        public static interface TermApplyFunc {
            public void apply(GrammarTerm var1, GrammarRoom var2, GrammarPhrase var3);
        }
    }
}

