/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.google.common.collect.Lists;
import com.lying.grid.AbstractTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.init.CDLoggers;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BlueprintTileGrid
extends AbstractTileGrid<class_2338> {
    public static final DebugLogger LOGGER = CDLoggers.WFC;
    public static final Tile BLANK = CDTiles.BLANK.get();
    public static final class_5819 rand = class_5819.method_43047();
    private final List<TileInstance> finalised = Lists.newArrayList();

    public static BlueprintTileGrid ofSize(class_2338 size) {
        BlueprintTileGrid map = new BlueprintTileGrid();
        int sizeX = Math.abs(size.method_10263());
        sizeX = sizeX == 0 ? 1 : sizeX;
        int sizeY = Math.abs(size.method_10264());
        sizeY = sizeY == 0 ? 1 : sizeY;
        int sizeZ = Math.abs(size.method_10260());
        sizeZ = sizeZ == 0 ? 1 : sizeZ;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int y = 0; y < sizeY; ++y) {
                    map.addToVolume(new class_2338(x, y, z));
                }
            }
        }
        return map;
    }

    public static BlueprintTileGrid fromGraphGrid(GraphTileGrid graph, int height) {
        BlueprintTileGrid map = new BlueprintTileGrid();
        graph.contents().forEach(tile -> {
            class_2338 pos = new class_2338(tile.x, 0, tile.y);
            for (int i = 0; i < height; ++i) {
                map.addToVolume(pos.method_10086(i));
            }
        });
        return map;
    }

    public BlueprintTileGrid addToVolume(class_2338 from, class_2338 to) {
        class_2338.class_2339.method_10097((class_2338)from, (class_2338)to).forEach(p -> this.addToVolume(p.method_10062()));
        return this;
    }

    @Override
    public boolean containsAdjacent(class_2338 pos) {
        return this.set.keySet().stream().anyMatch(p2 -> p2.method_19455((class_2382)pos) == 1);
    }

    @Override
    public void grow(class_2350 direction, int size) {
        this.getBoundaries(List.of(direction)).forEach(p -> {
            for (int i = 0; i < size; ++i) {
                this.addToVolume(p.method_10093(direction));
            }
        });
    }

    public class_2338 size() {
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        int z = Integer.MIN_VALUE;
        for (class_2338 pos : this.set.keySet()) {
            if (pos.method_10263() > x) {
                x = pos.method_10263();
            }
            if (pos.method_10264() > y) {
                y = pos.method_10264();
            }
            if (pos.method_10260() <= z) continue;
            z = pos.method_10260();
        }
        return new class_2338(x, y, z).method_10069(1, 1, 1);
    }

    public boolean isBoundary(class_2338 pos, class_2350 side) {
        return !this.contains(pos.method_10093(side));
    }

    @Override
    public List<class_2338> getBoundaries(List<class_2350> faces) {
        return this.set.keySet().stream().filter(p -> faces.stream().anyMatch(f -> this.isBoundary((class_2338)p, (class_2350)f))).toList();
    }

    public void applyToAllValid(Tile tile) {
        Set points = this.set.keySet();
        points.stream().filter(p -> this.get(p).get().isBlank() && tile.canExistAt((class_2338)p, this)).forEach(p -> this.put((class_2338)p, tile));
    }

    public List<Tile> getOptionsFor(class_2338 pos, List<Tile> useable) {
        ArrayList options = Lists.newArrayList();
        options.addAll((Collection)this.optionCache.getOrDefault(pos, useable.stream().filter(t -> t.canExistAt(pos, this)).toList()));
        if (!this.optionCache.containsKey(pos)) {
            this.optionCache.put(pos, options);
        }
        return options;
    }

    @Override
    public void put(class_2338 pos, @Nullable Tile tile) {
        super.put(pos, tile);
        this.finalised.clear();
    }

    public void finalise() {
        LOGGER.info("Finalising tile set...");
        this.finalised.clear();
        this.set.entrySet().forEach(entry -> {
            Tile tile = (Tile)entry.getValue();
            if (tile == null || tile.isFlag()) {
                return;
            }
            class_2338 pos = (class_2338)entry.getKey();
            class_2470 rotation = tile.assignRotation(pos, this::get, rand);
            this.finalised.add(new TileInstance(pos, tile, rotation));
        });
        if (!this.finalised.isEmpty()) {
            LOGGER.info("Tile set finalised");
        } else {
            LOGGER.warn("Error while finalising tile set");
        }
    }

    public void finalise(TileInstance instance) {
        this.finalised.removeIf(i -> i.pos().method_19455((class_2382)instance.pos()) == 0);
        this.finalised.add(instance);
    }

    public List<TileInstance> getTiles() {
        return this.finalised;
    }

    public boolean generate(class_2338 origin, class_3218 world) {
        if (this.finalised.isEmpty()) {
            LOGGER.warn("Attempted to generate empty or non-finalised tile set");
            return false;
        }
        this.finalised.forEach(entry -> entry.generate(origin.method_10081((class_2382)entry.pos().method_35830(2)), world));
        LOGGER.info("Tile set generated successfully");
        return true;
    }

    public record TileInstance(class_2338 pos, Tile tile, class_2470 rotation) {
        public void generate(class_2338 position, class_3218 world) {
            this.tile.generate(this, position, world);
        }
    }
}

