/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.CyclicDungeons;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import com.lying.init.CDRoomTileSets;
import com.lying.reference.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.joml.Vector2i;

public class CDTerms {
    private static final Map<class_2960, Supplier<GrammarTerm>> TERMS = new HashMap<class_2960, Supplier<GrammarTerm>>();
    private static int tally = 0;
    public static final Supplier<GrammarTerm> START = CDTerms.register("start", () -> GrammarTerm.Builder.create(0xFFFFFF, class_1767.field_7952).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.START_ROOM_TILESET).unplaceable());
    public static final Supplier<GrammarTerm> END = CDTerms.register("end", () -> GrammarTerm.Builder.create(0xFFFFFF, class_1767.field_7952).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.END_ROOM_TILESET).unplaceable());
    public static final Supplier<GrammarTerm> VOID = CDTerms.register("void", () -> GrammarTerm.Builder.create(0, class_1767.field_7963).unplaceable());
    public static final Supplier<GrammarTerm> BLANK = CDTerms.register("blank", () -> GrammarTerm.Builder.create(526344, class_1767.field_7967).unplaceable().replaceable());
    public static final Supplier<GrammarTerm> ADD = CDTerms.register("add_room", () -> GrammarTerm.Builder.create(0xD2D2D2, class_1767.field_7952).replaceable().sizeCap(6).weight(3).onApply((t, r, g) -> GrammarTerm.injectRoom(r, g)));
    public static final Supplier<GrammarTerm> ADD_BRANCH = CDTerms.register("add_branch", () -> GrammarTerm.Builder.create(0xB9B9B9, class_1767.field_7952).replaceable().injectsBranches().sizeCap(6).weight(4).onApply((t, r, g) -> GrammarTerm.injectBranch(r, g)));
    public static final Supplier<GrammarTerm> EMPTY = CDTerms.register("empty", () -> GrammarTerm.Builder.create(0xA6A6A6, class_1767.field_7944).size(CDTerms.size(7, 7, 10, 10)).withTileSet(CDRoomTileSets.EMPTY_ROOM_TILESET).nonconsecutive().allowDeadEnds(false).neverAfter(START).neverBefore(END));
    public static final Supplier<GrammarTerm> BATTLE = CDTerms.register("battle", () -> GrammarTerm.Builder.create(13108999, class_1767.field_7946).size(CDTerms.size(8, 8, 14, 14)).withTileSet(CDRoomTileSets.BATTLE_ROOM_TILESET).nonconsecutive().weight(3));
    public static final Supplier<GrammarTerm> TRAP = CDTerms.register("trap", () -> GrammarTerm.Builder.create(11416030, class_1767.field_7958).size(CDTerms.size(6, 6, 8, 8)).withTileSet(CDRoomTileSets.TRAP_ROOM_TILESET).nonconsecutive().weight(2));
    public static final Supplier<GrammarTerm> BIG_PUZZLE = CDTerms.register("big_puzzle", () -> GrammarTerm.Builder.create(3225310, class_1767.field_7966).size(CDTerms.size(10, 10, 16, 16)).withTileSet(CDRoomTileSets.PUZZLE_ROOM_TILESET).nonconsecutive().popCap(2).onApply(CDTerms::injectTreasure));
    public static final Supplier<GrammarTerm> SML_PUZZLE = CDTerms.register("small_puzzle", () -> GrammarTerm.Builder.create(2582730, class_1767.field_7951).size(CDTerms.size(5, 5, 8, 8)).withTileSet(CDRoomTileSets.PUZZLE_ROOM_TILESET).nonconsecutive().popCap(4));
    public static final Supplier<GrammarTerm> BOSS = CDTerms.register("boss", () -> GrammarTerm.Builder.create(0x7D1D1D, class_1767.field_7964).size(CDTerms.size(16, 16)).withTileSet(CDRoomTileSets.BOSS_ROOM_TILESET).popCap(1).weight(10).neverAfter(START).onlyBefore(END).onApply(CDTerms::injectTreasure));
    public static final Supplier<GrammarTerm> TREASURE = CDTerms.register("treasure", () -> GrammarTerm.Builder.create(16768064, class_1767.field_7947).size(CDTerms.size(5, 5)).withTileSet(CDRoomTileSets.TREASURE_ROOM_TILESET).popCap(3).weight(2).onlyAfter(BATTLE, SML_PUZZLE, EMPTY));

    private static void injectTreasure(GrammarTerm t, GrammarRoom r, GrammarPhrase g) {
        GrammarTerm.injectRoom(r, g).applyTerm(TREASURE.get(), g);
    }

    private static Function<class_5819, Vector2i> size(int x, int y) {
        return r -> new Vector2i(x, y);
    }

    private static Function<class_5819, Vector2i> size(int minX, int minY, int maxX, int maxY) {
        Function<class_5819, Integer> x = minX == maxX ? r -> minX : r -> minX + r.method_43048(maxX - minX);
        Function<class_5819, Integer> y = minY == maxY ? r -> minY : r -> minY + r.method_43048(maxY - minY);
        return r -> new Vector2i(((Integer)x.apply((class_5819)r)).intValue(), ((Integer)y.apply((class_5819)r)).intValue());
    }

    private static Supplier<GrammarTerm> register(String name, Supplier<GrammarTerm.Builder> funcIn) {
        class_2960 id = Reference.ModInfo.prefix(name);
        GrammarTerm term = funcIn.get().build(id);
        if (term.isPlaceable()) {
            ++tally;
        }
        Supplier<GrammarTerm> sup = () -> term;
        TERMS.put(id, sup);
        return sup;
    }

    public static Optional<GrammarTerm> get(String name) {
        return CDTerms.get(name.contains(":") ? class_2960.method_60654((String)name) : Reference.ModInfo.prefix(name));
    }

    public static Optional<GrammarTerm> get(class_2960 id) {
        return TERMS.containsKey(id) ? Optional.of(TERMS.get(id).get()) : Optional.empty();
    }

    public static List<GrammarTerm> placeables() {
        return TERMS.values().stream().map(Supplier::get).filter(GrammarTerm::isPlaceable).toList();
    }

    public static void init() {
        CyclicDungeons.LOGGER.info("# Initialised {} grammar terms ({} placeable)", (Object)TERMS.size(), (Object)tally);
    }
}

