/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.CyclicDungeons;
import com.lying.init.CDTiles;
import com.lying.reference.Reference;
import com.lying.worldgen.Tile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class CDTileTags {
    private static int tally = 0;
    private static final Map<class_2960, TileTag> TAGS = new HashMap<class_2960, TileTag>();
    public static final TileTag SOLID_FLOORING = CDTileTags.make("solid_flooring", CDTiles.ID_FLOOR_PRISTINE, CDTiles.ID_FLOOR_ROOM, CDTiles.ID_FLOOR_PASSAGE, CDTiles.ID_HOT_FLOOR, CDTiles.ID_PILLAR_CAP);
    public static final TileTag WET = CDTileTags.make("wet", CDTiles.ID_WET_FLOOR, CDTiles.ID_POOL);
    public static final TileTag DAMP = CDTileTags.make("damp", CDTiles.ID_PUDDLE, CDTiles.ID_WET_FLOOR, CDTiles.ID_POOL);
    public static final TileTag HOT = CDTileTags.make("hot", CDTiles.ID_LAVA, CDTiles.ID_HOT_FLOOR);
    public static final TileTag CEILING = CDTileTags.make("ceiling", CDTiles.ID_PILLAR_CAP);
    public static final TileTag TABLES = CDTileTags.make("tables", CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE);
    public static final TileTag LIGHTING = CDTileTags.make("lighting", CDTiles.ID_LIGHT_FLOOR, CDTiles.ID_LIGHT_TABLE);
    public static final TileTag DECOR = CDTileTags.make("decor", CDTiles.ID_LIGHT_FLOOR, CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE, CDTiles.ID_SEAT, CDTiles.ID_WORKSTATION, CDTiles.ID_TREASURE, CDTiles.ID_PILLAR_BASE);
    public static final TileTag OBTRUSIVE = CDTileTags.make("obtrusive", CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE, CDTiles.ID_SEAT, CDTiles.ID_TREASURE, CDTiles.ID_PILLAR_BASE);
    public static final TileTag TRAPS = CDTileTags.make("traps", new class_2960[0]);

    private static TileTag make(String name, class_2960 ... idsIn) {
        return CDTileTags.make(Reference.ModInfo.prefix(name), idsIn);
    }

    public static TileTag make(class_2960 registryName, class_2960 ... idsIn) {
        ++tally;
        TileTag tag = new TileTag(registryName, idsIn);
        TAGS.put(registryName, tag);
        return tag;
    }

    public Optional<TileTag> get(class_2960 registryName) {
        return TAGS.containsKey(registryName) ? Optional.of(TAGS.get(registryName)) : Optional.empty();
    }

    public static void init() {
        CyclicDungeons.LOGGER.info("# Initialised {} tile tags", (Object)tally);
    }

    public static final class TileTag {
        private final class_2960 id;
        private final List<class_2960> contents = Lists.newArrayList();

        public TileTag(class_2960 id) {
            this.id = id;
        }

        public TileTag(class_2960 id, class_2960 ... tilesIn) {
            this(id);
            for (class_2960 tile : tilesIn) {
                this.add(tile);
            }
        }

        public class_2960 id() {
            return this.id;
        }

        public List<class_2960> contents() {
            return this.contents;
        }

        public boolean contains(Tile tileIn) {
            return this.contains(tileIn.registryName());
        }

        public boolean contains(class_2960 idIn) {
            return this.contents.stream().anyMatch(arg_0 -> ((class_2960)idIn).equals(arg_0));
        }

        public TileTag add(class_2960 id) {
            if (!this.contents.contains(id)) {
                this.contents.add(id);
            }
            return this;
        }
    }
}

