/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_241;

public abstract class AbstractBox2f {
    public abstract float minX();

    public abstract float minY();

    public abstract float maxX();

    public abstract float maxY();

    public abstract List<LineSegment2f> asEdges();

    public abstract List<class_241> asPoints();

    public abstract String toString();

    public boolean contains(class_241 vec) {
        if (vec.field_1343 < this.minX() || vec.field_1343 > this.maxX() || vec.field_1342 < this.minY() || vec.field_1342 > this.maxY()) {
            return false;
        }
        for (class_241 test : new class_241[]{new class_241(0.0f, 1.0f), new class_241(1.0f, 0.0f)}) {
            LineSegment2f linePos = new LineSegment2f(vec, vec.method_35586(test.method_35582(Float.MAX_VALUE)));
            if (this.intersections(linePos) % 2 > 0) {
                return true;
            }
            LineSegment2f lineNeg = new LineSegment2f(vec, vec.method_35586(test.method_35582(Float.MIN_VALUE)));
            if (this.intersections(lineNeg) % 2 <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean contains(LineSegment2f line) {
        return this.contains(line.getLeft()) && this.contains(line.getRight());
    }

    public int intersections(LineSegment2f line) {
        int tally = 0;
        for (LineSegment2f edge : this.asEdges()) {
            if (!LineSegment2f.doSegmentsIntersect(edge, line)) continue;
            ++tally;
        }
        return tally;
    }

    public boolean intersects(AbstractBox2f box) {
        return box.asPoints().stream().anyMatch(this::contains) || this.asEdges().stream().anyMatch(e1 -> box.asEdges().stream().anyMatch(e2 -> LineSegment2f.doSegmentsIntersect(e1, e2)));
    }

    public boolean intersects(LineSegment2f line) {
        if (this.contains(line.getLeft()) || this.contains(line.getRight())) {
            return true;
        }
        Predicate<LineSegment2f> predicate = a -> LineSegment2f.doSegmentsIntersect(line, a);
        return this.asEdges().stream().anyMatch(predicate);
    }

    public class_241 intercept(LineSegment2f line) {
        for (LineSegment2f face : this.asEdges()) {
            class_241 intercept = LineSegment2f.segmentIntercept(face, line);
            if (intercept == null) continue;
            return intercept;
        }
        return null;
    }

    public final List<class_241> enclosedPositions() {
        ArrayList points = Lists.newArrayList();
        for (float x = this.minX(); x < this.maxX(); x += 1.0f) {
            for (float y = this.minY(); y < this.maxY(); y += 1.0f) {
                class_241 point = new class_241(x, y);
                if (!this.contains(point)) continue;
                points.add(point);
            }
        }
        return points;
    }

    public abstract AbstractBox2f move(class_241 var1);

    public abstract AbstractBox2f mul(float var1);

    public abstract AbstractBox2f grow(float var1);

    public AbstractBox2f spin(float radians) {
        return this;
    }

    public AbstractBox2f rotate(float radians) {
        return this;
    }

    public AbstractBox2f rotateAround(class_241 origin, float radians) {
        return this;
    }
}

