/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.LineSegment2f;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import org.jetbrains.annotations.Nullable;

public class Box2f
extends AbstractBox2f {
    private final float minX;
    private final float minY;
    private final float maxX;
    private final float maxY;
    private final Map<class_2350, LineSegment2f> edgeMap;

    public Box2f(float minX, float maxX, float minY, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        class_241 a = new class_241(minX, minY);
        class_241 b = new class_241(maxX, minY);
        class_241 c = new class_241(maxX, maxY);
        class_241 d = new class_241(minX, maxY);
        this.edgeMap = Map.of(class_2350.field_11043, new LineSegment2f(a, b), class_2350.field_11034, new LineSegment2f(b, c), class_2350.field_11035, new LineSegment2f(c, d), class_2350.field_11039, new LineSegment2f(d, a));
    }

    @Override
    public String toString() {
        return "Box[" + this.minX + "->" + this.maxX + ", " + this.minY + "->" + this.maxY + "]";
    }

    @Override
    public final float minX() {
        return this.minX;
    }

    @Override
    public final float minY() {
        return this.minY;
    }

    @Override
    public final float maxX() {
        return this.maxX;
    }

    @Override
    public final float maxY() {
        return this.maxY;
    }

    @Override
    public List<LineSegment2f> asEdges() {
        return Lists.newArrayList(this.edgeMap.values());
    }

    @Override
    public List<class_241> asPoints() {
        return List.of(new class_241(this.minX, this.minY), new class_241(this.maxX, this.minY), new class_241(this.maxX, this.maxY), new class_241(this.minX, this.maxY));
    }

    @Override
    public boolean intersects(AbstractBox2f box) {
        if (box.asPoints().stream().anyMatch(p -> p.field_1343 >= this.minX && p.field_1343 <= this.maxX && p.field_1342 >= this.minY && p.field_1342 <= this.maxY)) {
            return true;
        }
        return super.intersects(box);
    }

    @Override
    public boolean contains(class_241 vec) {
        return vec.field_1343 >= this.minX && vec.field_1343 <= this.maxX && vec.field_1342 >= this.minY && vec.field_1342 <= this.maxY;
    }

    @Override
    public AbstractBox2f move(class_241 vec) {
        return new Box2f(this.minX + vec.field_1343, this.maxX + vec.field_1343, this.minY + vec.field_1342, this.maxY + vec.field_1342);
    }

    @Override
    public AbstractBox2f mul(float scalar) {
        return new Box2f(this.minX * scalar, this.maxX * scalar, this.minY * scalar, this.maxY * scalar);
    }

    @Override
    public AbstractBox2f grow(float v) {
        return new Box2f(this.minX - v, this.maxX + v, this.minY - v, this.maxY + v);
    }

    @Nullable
    public LineSegment2f getEdge(class_2350 dir) {
        return this.edgeMap.getOrDefault(dir, null);
    }

    @Nullable
    public class_2350 identifyEdge(LineSegment2f faceIn) {
        for (class_2350 edge : class_2350.class_2353.field_11062) {
            if (!faceIn.equals(this.getEdge(edge))) continue;
            return edge;
        }
        return null;
    }
}

