/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import net.minecraft.class_241;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class Line2f {
    public final float m;
    public final float b;
    public final boolean isVertical;
    public final boolean isHorizontal;

    public Line2f(Vector2i posA, Vector2i posB) {
        this(new class_241((float)posA.x, (float)posA.y), new class_241((float)posB.x, (float)posB.y));
    }

    public Line2f(class_241 posA, class_241 posB) {
        float run = posB.field_1343 - posA.field_1343;
        float rise = posB.field_1342 - posA.field_1342;
        this.isVertical = run == 0.0f;
        boolean bl = this.isHorizontal = rise == 0.0f;
        if (this.isVertical) {
            this.m = posA.field_1343;
            this.b = 0.0f;
        } else {
            this.m = run == 0.0f ? 0.0f : rise / run;
            this.b = posA.field_1342 - posA.field_1343 * this.m;
        }
    }

    public boolean equals(Line2f line) {
        return this.alignsWith(line);
    }

    public boolean alignsWith(Line2f line) {
        return this.isVertical == line.isVertical && this.m == line.m && this.b == line.b;
    }

    public String toString() {
        return "Line[" + this.asEquation() + "]";
    }

    public String asEquation() {
        float m = (float)((int)(this.m * 100.0f)) / 100.0f;
        float b = (float)((int)(this.b * 100.0f)) / 100.0f;
        if (this.isVertical) {
            return "x = " + m;
        }
        if (m == 0.0f) {
            return "y = " + b;
        }
        if (b == 0.0f) {
            return "y = " + m + "x";
        }
        return "y = " + m + "x + " + b;
    }

    public boolean contains(@Nullable class_241 vec) {
        if (vec == null) {
            return false;
        }
        return this.isVertical ? vec.field_1343 == this.m : (this.isHorizontal ? vec.field_1342 == this.b : this.atX(vec.field_1343).method_35589(vec) == 0.0f);
    }

    public class_241 direction() {
        if (this.isVertical) {
            return new class_241(0.0f, 1.0f);
        }
        if (this.isHorizontal) {
            return new class_241(0.0f, this.b);
        }
        return this.atX(1.0f).method_35586(this.atX(0.0f).method_35588());
    }

    public class_241 normal() {
        class_241 d = this.direction().method_35581();
        return new class_241(-d.field_1342, d.field_1343);
    }

    public class_241 atX(float x) {
        return this.isVertical ? new class_241(this.m, x) : (this.isHorizontal ? new class_241(x, this.b) : new class_241(x, this.m * x + this.b));
    }

    public static boolean areParallel(Line2f a, Line2f b) {
        return a.isVertical == b.isVertical && a.m == b.m;
    }

    public boolean intersects(Line2f other) {
        return this.isSame(other) || this.intercept(other) != null;
    }

    public boolean isSame(Line2f line2) {
        if (!Line2f.areParallel(this, line2)) {
            return false;
        }
        if (this.isVertical && line2.isVertical) {
            return this.m == line2.m;
        }
        return this.b == line2.b;
    }

    public boolean isParallel(Line2f line) {
        if (this.isVertical && line.isVertical) {
            return true;
        }
        if (this.isHorizontal && line.isHorizontal) {
            return true;
        }
        if (!this.isVertical && !line.isVertical) {
            return this.m == line.m;
        }
        return false;
    }

    @Nullable
    public class_241 intercept(Line2f other) {
        if (this.isParallel(other)) {
            return null;
        }
        if (this.isVertical != other.isVertical) {
            Line2f vert = this.isVertical ? this : other;
            Line2f hori = this.isVertical ? other : this;
            return hori.atX(vert.m);
        }
        float a = this.m;
        float c = this.b;
        float b = other.m;
        float d = other.b;
        return this.atX((d - c) / (a - b));
    }
}

