/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.grid.GridTile;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.Line2f;
import java.util.Iterator;
import net.minecraft.class_241;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LineSegment2f
extends Line2f {
    protected final class_241 left;
    protected final class_241 right;
    protected final float minX;
    protected final float maxX;
    protected final float minY;
    protected final float maxY;

    public LineSegment2f(GridTile tileA, GridTile tileB) {
        this(tileA.toVec2f(), tileB.toVec2f());
    }

    public LineSegment2f(Vector2i posA, Vector2i posB) {
        this(new class_241((float)posA.x, (float)posA.y), new class_241((float)posB.x, (float)posB.y));
    }

    public LineSegment2f(class_241 leftIn, class_241 rightIn) {
        super(leftIn, rightIn);
        this.left = leftIn;
        this.right = rightIn;
        this.minX = Math.min(leftIn.field_1343, rightIn.field_1343);
        this.maxX = Math.max(leftIn.field_1343, rightIn.field_1343);
        this.minY = Math.min(leftIn.field_1342, rightIn.field_1342);
        this.maxY = Math.max(leftIn.field_1342, rightIn.field_1342);
    }

    @Override
    public String toString() {
        float aX = (float)((int)(this.left.field_1343 * 100.0f)) / 100.0f;
        float aY = (float)((int)(this.left.field_1342 * 100.0f)) / 100.0f;
        float bX = (float)((int)(this.right.field_1343 * 100.0f)) / 100.0f;
        float bY = (float)((int)(this.right.field_1342 * 100.0f)) / 100.0f;
        return "LineSegment[" + aX + ", " + aY + " to " + bX + ", " + bY + "]";
    }

    public boolean equals(LineSegment2f line) {
        return super.equals(line) && this.minX == line.minX && this.maxX == line.maxX && this.minY == line.minY && this.maxY == line.maxY;
    }

    public boolean simpleEquals(LineSegment2f line) {
        return this.left.method_1016(line.left) && this.right.method_1016(line.right) || this.left.method_1016(line.right) && this.right.method_1016(this.left);
    }

    @Override
    public boolean contains(@Nullable class_241 vec) {
        return vec != null && super.contains(vec) && this.inRange(vec);
    }

    @Override
    public class_241 direction() {
        return this.right.method_35586(this.left.method_35588());
    }

    public class_241 midPoint() {
        return this.left.method_35586(this.direction().method_35582(0.5f));
    }

    public LineSegment2f localTo(class_241 point) {
        return new LineSegment2f(this.getLeft().method_35586(point.method_35588()), this.getRight().method_35586(point.method_35588()));
    }

    public boolean inRange(class_241 point) {
        float x = point.field_1343;
        float y = point.field_1342;
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public class_241 getLeft() {
        return this.left;
    }

    public class_241 getRight() {
        return this.right;
    }

    public class_241[] toPoints() {
        return new class_241[]{this.left, this.right};
    }

    public boolean linksTo(LineSegment2f line) {
        class_241[] otherPoints = line.toPoints();
        for (class_241 point : this.toPoints()) {
            for (class_241 otherPoint : otherPoints) {
                if (point.method_35589(otherPoint) != 0.0f) continue;
                return true;
            }
        }
        return false;
    }

    public LineSegment2f offset(class_241 offset) {
        return new LineSegment2f(this.left.method_35586(offset), this.right.method_35586(offset));
    }

    public LineSegment2f scale(float scalar) {
        return new LineSegment2f(this.left.method_35582(scalar), this.right.method_35582(scalar));
    }

    public float length() {
        class_241 dir = this.direction();
        float a = Math.abs(dir.field_1343);
        float b = Math.abs(dir.field_1342);
        return (float)Math.sqrt(a * a + b * b);
    }

    public float manhattanLength() {
        class_241 dir = this.direction();
        return Math.abs(dir.field_1343) + Math.abs(dir.field_1342);
    }

    public boolean isStraightLine() {
        return this.isHorizontal || this.isVertical;
    }

    public AbstractBox2f bounds() {
        return new Box2f(this.minX, this.maxX, this.minY, this.maxY);
    }

    public boolean intersectsAtAll(LineSegment2f other) {
        return this.contains(other.left) || this.contains(other.right) || LineSegment2f.doSegmentsIntersect(this, other);
    }

    public boolean isSame(LineSegment2f line2) {
        return super.isSame(line2) && this.inRange(line2.left) && this.inRange(line2.right);
    }

    @Nullable
    public LineSegment2f clip(AbstractBox2f box) {
        if (!box.intersects(this)) {
            return this;
        }
        boolean leftInside = box.contains(this.left);
        boolean rightInside = box.contains(this.right);
        if (leftInside && rightInside) {
            return null;
        }
        if (leftInside || rightInside) {
            LineSegment2f edge;
            class_241 intercept = null;
            Iterator<LineSegment2f> iterator = box.asEdges().iterator();
            while (iterator.hasNext() && (intercept = LineSegment2f.segmentIntercept(edge = iterator.next(), this)) == null) {
            }
            if (intercept != null) {
                LineSegment2f clipped = new LineSegment2f(leftInside ? intercept : this.left, rightInside ? intercept : this.right);
                return clipped.length() > 0.0f ? clipped : null;
            }
        }
        return this;
    }

    @Override
    @Nullable
    public class_241 intercept(Line2f line2) {
        return this.intercept(line2, false);
    }

    @Nullable
    public class_241 intercept(Line2f other, boolean ignoreRange) {
        class_241 intercept = super.intercept(other);
        return ignoreRange || this.contains(intercept) ? intercept : null;
    }

    @Nullable
    public static class_241 segmentIntercept(LineSegment2f a, LineSegment2f b) {
        class_241 interceptA = a.intercept(b, false);
        class_241 interceptB = b.intercept(a, false);
        if (interceptA == null || interceptB == null) {
            return null;
        }
        return interceptA.method_35586(interceptB).method_35582(0.5f);
    }

    public static boolean doSegmentsIntersect(LineSegment2f a, LineSegment2f b) {
        return LineSegment2f.segmentIntercept(a, b) != null;
    }

    public LineSegment2f turnClockwise() {
        class_241 a = new class_241(-this.left.field_1342, this.left.field_1343);
        class_241 b = new class_241(-this.right.field_1342, this.right.field_1343);
        return new LineSegment2f(a, b);
    }

    public LineSegment2f turnCClockwise() {
        class_241 a = new class_241(this.left.field_1342, -this.left.field_1343);
        class_241 b = new class_241(this.right.field_1342, -this.right.field_1343);
        return new LineSegment2f(a, b);
    }
}

