/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.CDUtils;
import com.lying.utility.LineSegment2f;
import java.util.List;
import net.minecraft.class_241;

public class RotaryBox2f
extends AbstractBox2f {
    private class_241[] points = new class_241[4];
    private LineSegment2f[] edges = new LineSegment2f[4];
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;

    public RotaryBox2f(class_241 aIn, class_241 bIn, class_241 cIn, class_241 dIn) {
        this.points[0] = aIn;
        this.points[1] = bIn;
        this.points[2] = cIn;
        this.points[3] = dIn;
        this.updateValues();
    }

    @Override
    public String toString() {
        return "RotBox[" + this.minX + "->" + this.maxX + ", " + this.minY + "->" + this.maxY + "]";
    }

    public RotaryBox2f clone() {
        return new RotaryBox2f(this.points[0], this.points[1], this.points[2], this.points[3]);
    }

    public void updateValues() {
        this.calculateSimpleBounds();
        this.buildEdges();
    }

    protected void calculateSimpleBounds() {
        float mx = 2.1474836E9f;
        float my = 2.1474836E9f;
        float mX = -2.1474836E9f;
        float mY = -2.1474836E9f;
        for (class_241 vec : this.points) {
            float y;
            float x = vec.field_1343;
            if (x > mX) {
                mX = x;
            }
            if (x < mx) {
                mx = x;
            }
            if ((y = vec.field_1342) > mY) {
                mY = y;
            }
            if (!(y < my)) continue;
            my = y;
        }
        this.minX = mx;
        this.minY = my;
        this.maxX = mX;
        this.maxY = mY;
    }

    @Override
    public float minX() {
        return this.minX;
    }

    @Override
    public float minY() {
        return this.minY;
    }

    @Override
    public float maxX() {
        return this.maxX;
    }

    @Override
    public float maxY() {
        return this.maxY;
    }

    protected void buildEdges() {
        this.edges = new LineSegment2f[]{new LineSegment2f(this.points[0], this.points[1]), new LineSegment2f(this.points[1], this.points[2]), new LineSegment2f(this.points[2], this.points[3]), new LineSegment2f(this.points[3], this.points[0])};
    }

    public static RotaryBox2f enclosing(class_241 a, class_241 b) {
        float minX = Math.min(a.field_1343, b.field_1343);
        float minY = Math.min(a.field_1342, b.field_1342);
        float maxX = Math.max(a.field_1343, b.field_1343);
        float maxY = Math.max(a.field_1342, b.field_1342);
        return new RotaryBox2f(new class_241(minX, minY), new class_241(maxX, minY), new class_241(maxX, maxY), new class_241(minX, maxY));
    }

    public static RotaryBox2f ofSize(int width, int height) {
        return new RotaryBox2f(new class_241(0.0f, 0.0f), new class_241((float)width, 0.0f), new class_241((float)width, (float)height), new class_241(0.0f, (float)height));
    }

    public static RotaryBox2f fromLine(LineSegment2f line, float height) {
        class_241 p1 = new class_241(line.getLeft().field_1343, line.getLeft().field_1342);
        class_241 p2 = new class_241(line.getRight().field_1343, line.getRight().field_1342);
        class_241 delta = p2.method_35586(p1.method_35588()).method_35581();
        delta = new class_241(-delta.field_1342, delta.field_1343);
        float minH = -height / 2.0f;
        float maxH = minH + height;
        class_241 a = p1.method_35586(delta.method_35582(minH));
        class_241 b = p2.method_35586(delta.method_35582(minH));
        class_241 c = p2.method_35586(delta.method_35582(maxH));
        class_241 d = p1.method_35586(delta.method_35582(maxH));
        return new RotaryBox2f(new class_241(a.field_1343, a.field_1342), new class_241(b.field_1343, b.field_1342), new class_241(c.field_1343, c.field_1342), new class_241(d.field_1343, d.field_1342));
    }

    public AbstractBox2f simplify() {
        return new Box2f(this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public List<LineSegment2f> asEdges() {
        return List.of(this.edges[0], this.edges[1], this.edges[2], this.edges[3]);
    }

    @Override
    public List<class_241> asPoints() {
        return List.of(this.points[0], this.points[1], this.points[2], this.points[3]);
    }

    @Override
    public AbstractBox2f move(class_241 vec) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = vec.method_35586(this.points[i]);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f mul(float val) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = this.points[i].method_35582(val);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f spin(float radians) {
        return this.rotateAround(new class_241(this.minX + (this.maxX - this.minX) / 2.0f, this.minY + (this.maxY - this.minY) / 2.0f), radians);
    }

    @Override
    public AbstractBox2f rotate(float radians) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = CDUtils.rotate(this.points[i], radians);
        }
        this.updateValues();
        return this;
    }

    @Override
    public AbstractBox2f rotateAround(class_241 origin, float radians) {
        return this.move(origin.method_35588()).rotate(radians).move(origin);
    }

    @Override
    public AbstractBox2f grow(float val) {
        return this;
    }
}

