/*
 * Decompiled with CFR 0.152.
 */
package com.lying.worldgen;

import com.lying.grid.BlueprintTileGrid;
import com.lying.init.CDLoggers;
import com.lying.init.CDTileTags;
import com.lying.init.CDTiles;
import com.lying.utility.DebugLogger;
import com.lying.worldgen.TilePredicate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_9822;
import org.jetbrains.annotations.NotNull;

public abstract class Tile {
    public static final DebugLogger LOGGER = CDLoggers.WORLDGEN;
    public static final int TILE_SIZE = 2;
    public static final class_241 TILE = new class_241(2.0f, 2.0f);
    private final class_2960 registryName;
    private final TilePredicate predicate;
    private final GenStyle type;
    private final RotationSupplier rotator;

    public Tile(class_2960 id, GenStyle style, TilePredicate predicateIn, RotationSupplier rotatorIn) {
        this.registryName = id;
        this.type = style;
        this.predicate = predicateIn;
        this.rotator = rotatorIn;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Tile && this.is((Tile)obj);
    }

    public final boolean is(Tile tile) {
        return tile.registryName().equals((Object)this.registryName);
    }

    public final class_2960 registryName() {
        return this.registryName;
    }

    public final boolean isIn(CDTileTags.TileTag tag) {
        return tag.contains(this.registryName);
    }

    public final boolean isBlank() {
        return this.registryName.equals((Object)CDTiles.BLANK.get().registryName());
    }

    public final boolean isFlag() {
        return this.type == GenStyle.FLAG;
    }

    public final boolean canExistAt(class_2338 pos, BlueprintTileGrid set) {
        return this.predicate.test(this, pos, set);
    }

    @NotNull
    public final class_2470 assignRotation(class_2338 pos, Function<class_2338, Optional<Tile>> getter, class_5819 rand) {
        return this.rotator.assignRotation(pos, getter, rand);
    }

    public abstract void generate(BlueprintTileGrid.TileInstance var1, class_2338 var2, class_3218 var3);

    public static void tryPlace(class_2680 state, class_2338 pos, class_3218 world) {
        if (!world.method_8320(pos).method_26164(class_3481.field_17754)) {
            world.method_8501(pos, state);
        }
    }

    public static enum GenStyle {
        FLAG,
        BLOCK,
        STRUCTURE;

    }

    @FunctionalInterface
    public static interface RotationSupplier {
        public static final Map<class_2350, class_2470> faceToRotationMap = Map.of(class_2350.field_11043, class_2470.field_11467, class_2350.field_11034, class_2470.field_11463, class_2350.field_11035, class_2470.field_11464, class_2350.field_11039, class_2470.field_11465);

        @NotNull
        public class_2470 assignRotation(class_2338 var1, Function<class_2338, Optional<Tile>> var2, class_5819 var3);

        public static RotationSupplier none() {
            return (p, g, r) -> class_2470.field_11467;
        }

        public static RotationSupplier random() {
            return (p, g, r) -> class_2470.values()[r.method_43048(class_2470.values().length)];
        }

        public static RotationSupplier toFaceAdjacent(Predicate<Tile> predicate) {
            return RotationSupplier.toFaceAdjacent(predicate, RotationSupplier.none());
        }

        public static RotationSupplier againstBoundary(RotationSupplier fallback) {
            return (pos, getter, rand) -> {
                for (Map.Entry<class_2350, class_2470> entry : faceToRotationMap.entrySet()) {
                    Optional neighbour = (Optional)getter.apply(pos.method_10093(entry.getKey()));
                    if (!neighbour.isEmpty()) continue;
                    return entry.getValue();
                }
                return fallback.assignRotation(pos, getter, rand);
            };
        }

        public static RotationSupplier toFaceAdjacent(Predicate<Tile> predicate, RotationSupplier fallback) {
            Map<class_2350, class_2470> faceToRotationMap = Map.of(class_2350.field_11043, class_2470.field_11467, class_2350.field_11034, class_2470.field_11463, class_2350.field_11035, class_2470.field_11464, class_2350.field_11039, class_2470.field_11465);
            return (pos, getter, rand) -> {
                for (Map.Entry entry : faceToRotationMap.entrySet()) {
                    Optional neighbour = (Optional)getter.apply(pos.method_10093((class_2350)entry.getKey()));
                    if (!neighbour.isPresent() || !predicate.test((Tile)neighbour.get())) continue;
                    return (class_2470)entry.getValue();
                }
                return fallback.assignRotation(pos, getter, rand);
            };
        }
    }

    public static class Builder {
        private final TilePredicate predicate;
        private GenStyle style = GenStyle.FLAG;
        private class_2680[] blockStates = new class_2680[0];
        private class_5321<class_3785> structureKey = null;
        private RotationSupplier rotationFunc = (p, g, r) -> class_2470.field_11467;

        private Builder(TilePredicate predicateIn) {
            this.predicate = predicateIn;
        }

        public static Builder of(TilePredicate predicate) {
            return new Builder(predicate);
        }

        public Builder asFlag() {
            this.style = GenStyle.FLAG;
            return this;
        }

        public Builder asBlock(class_2680 ... states) {
            this.style = GenStyle.BLOCK;
            this.blockStates = states;
            return this;
        }

        public Builder asAir() {
            this.style = GenStyle.BLOCK;
            this.blockStates = new class_2680[]{class_2246.field_10124.method_9564()};
            return this;
        }

        public Builder asStructure(class_5321<class_3785> structureKeyIn) {
            this.style = GenStyle.STRUCTURE;
            this.structureKey = structureKeyIn;
            return this;
        }

        public Builder freeRotation() {
            return this.withRotation(RotationSupplier.random());
        }

        public Builder noRotation() {
            return this.withRotation((p, g, r) -> class_2470.field_11467);
        }

        public Builder withRotation(RotationSupplier funcIn) {
            this.rotationFunc = funcIn;
            return this;
        }

        public Function<class_2960, Tile> build() {
            switch (this.style.ordinal()) {
                default: {
                    return id -> new Tile(this, (class_2960)id, this.style, this.predicate, RotationSupplier.none()){

                        @Override
                        public void generate(BlueprintTileGrid.TileInstance inst, class_2338 pos, class_3218 world) {
                        }
                    };
                }
                case 1: {
                    return id -> new Tile((class_2960)id, this.style, this.predicate, RotationSupplier.none()){

                        @Override
                        public void generate(BlueprintTileGrid.TileInstance inst, class_2338 pos, class_3218 world) {
                            boolean sc = true;
                            class_2338.class_2339.method_10097((class_2338)pos, (class_2338)pos.method_10069(1, 1, 1)).forEach(p -> Tile.tryPlace(blockStates[world.field_9229.method_43048(blockStates.length)], p, world));
                        }
                    };
                }
                case 2: 
            }
            return id -> new Tile((class_2960)id, this.style, this.predicate, this.rotationFunc){

                @Override
                public void generate(BlueprintTileGrid.TileInstance inst, class_2338 pos, class_3218 world) {
                    class_5455 manager = world.method_30349();
                    class_2378 registry = manager.method_30530(class_7924.field_41249);
                    class_8891 alias = class_8891.create(List.of(), (class_2338)pos, (long)world.method_8412());
                    Optional poolOpt = Optional.of(structureKey).flatMap(key -> registry.method_31189(alias.lookup(key)));
                    if (poolOpt.isEmpty()) {
                        LOGGER.warn("Blank structure pool: {}", structureKey.method_29177().toString());
                        return;
                    }
                    class_5819 rand = class_5819.method_43049((long)(pos.method_10263() * pos.method_10263() + pos.method_10260() * pos.method_10260()));
                    class_3485 structureManager = world.method_14183();
                    class_2470 rotation = inst.rotation();
                    class_2338 place = pos;
                    if (rotation != class_2470.field_11467) {
                        switch (rotation) {
                            case field_11464: {
                                place = place.method_10069(1, 0, 1);
                                break;
                            }
                            case field_11463: {
                                place = place.method_10069(1, 0, 0);
                                break;
                            }
                            case field_11465: {
                                place = place.method_10069(0, 0, 1);
                                break;
                            }
                        }
                    }
                    class_3784 element = ((class_3785)poolOpt.get()).method_16631(rand);
                    class_3790 piece = new class_3790(structureManager, element, place, element.method_19308(), rotation, element.method_16628(structureManager, place, rotation), class_9822.field_52237);
                    piece.method_27236((class_5281)world, world.method_27056(), world.method_14178().method_12129(), rand, class_3341.method_34390((class_2382)pos, (class_2382)pos.method_10069(1, 1, 1)), place, false);
                }
            };
        }
    }
}

