/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public interface IWireableBlock {
    public static IWireableBlock getWireable(BlockPos pos, Level world) {
        return (IWireableBlock)world.getBlockState(pos).getBlock();
    }

    public boolean acceptWireTo(WireRecipient var1, BlockPos var2, BlockPos var3, Level var4);

    public WireRecipient type();

    default public void trigger(BlockPos pos, Level world) {
    }

    default public void activate(BlockPos pos, Level world) {
        if (!this.isActive(pos, world)) {
            this.trigger(pos, world);
        }
    }

    default public void deactivate(BlockPos pos, Level world) {
        if (this.isActive(pos, world)) {
            this.trigger(pos, world);
        }
    }

    default public int wireCount(BlockPos pos, Level world) {
        return 0;
    }

    default public void clearWires(BlockPos pos, Level world) {
    }

    default public boolean isActive(BlockPos pos, Level world) {
        return false;
    }

    public static enum WireRecipient implements StringRepresentable
    {
        ACTOR,
        SENSOR,
        LOGIC;

        public static final Codec<WireRecipient> CODEC;
        public static final StreamCodec<ByteBuf, WireRecipient> PACKET_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(WireRecipient::values);
            PACKET_CODEC = ByteBufCodecs.idMapper(id -> WireRecipient.values()[id], value -> value.ordinal());
        }
    }
}

