/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import com.lying.block.IWireableBlock;
import com.lying.block.entity.TrapLogicBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrapLogicBlock
extends BaseEntityBlock
implements IWireableBlock {
    public static final MapCodec<TrapLogicBlock> CODEC = TrapLogicBlock.simpleCodec(TrapLogicBlock::new);

    public TrapLogicBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrapLogicBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> validateTicker(BlockEntityType<A> given, BlockEntityType<E> expected, BlockEntityTicker<? super E> ticker) {
        return expected == given ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TrapLogicBlockEntity.getTicker(world, state, type);
    }

    @Override
    public IWireableBlock.WireRecipient type() {
        return IWireableBlock.WireRecipient.LOGIC;
    }

    @Override
    public boolean acceptWireTo(IWireableBlock.WireRecipient type, BlockPos target, BlockPos pos, Level world) {
        TrapLogicBlockEntity tile = (TrapLogicBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.TRAP_LOGIC.get()).get());
        return type != IWireableBlock.WireRecipient.LOGIC && tile.processWireConnection(target, type);
    }

    @Override
    public void clearWires(BlockPos pos, Level world) {
        ((TrapLogicBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.TRAP_LOGIC.get()).get())).reset();
    }

    @Override
    public int wireCount(BlockPos pos, Level world) {
        return ((TrapLogicBlockEntity)((Object)world.getBlockEntity(pos, (BlockEntityType)CDBlockEntityTypes.TRAP_LOGIC.get()).get())).wireCount();
    }
}

