/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.lying.block.IWireableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractWireableBlockEntity
extends BlockEntity {
    private static final Function<int[], BlockPos> intArrayToBlockPos = v -> new BlockPos(v[0], v[1], v[2]);
    private List<BlockPos> actors = Lists.newArrayList();
    private List<BlockPos> sensors = Lists.newArrayList();

    protected AbstractWireableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag set;
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("IsActive", IWireableBlock.getWireable(this.getBlockPos(), this.getLevel()).isActive(this.getBlockPos(), this.getLevel()));
        if (this.hasSensors()) {
            set = new ListTag();
            this.sensors.forEach(p -> set.add((Object)NbtUtils.writeBlockPos((BlockPos)p)));
            nbt.put("Sensors", (Tag)set);
        }
        if (this.hasActors()) {
            set = new ListTag();
            this.actors.forEach(p -> set.add((Object)NbtUtils.writeBlockPos((BlockPos)p)));
            nbt.put("Actors", (Tag)set);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        int i;
        ListTag set;
        super.loadAdditional(nbt, registryLookup);
        this.sensors.clear();
        if (nbt.contains("Sensors")) {
            set = nbt.getList("Sensors", 11);
            for (i = 0; i < set.size(); ++i) {
                this.addWire((BlockPos)intArrayToBlockPos.apply((Object)set.getIntArray(i)), IWireableBlock.WireRecipient.SENSOR);
            }
        }
        this.actors.clear();
        if (nbt.contains("Actors")) {
            set = nbt.getList("Actors", 11);
            for (i = 0; i < set.size(); ++i) {
                this.addWire((BlockPos)intArrayToBlockPos.apply((Object)set.getIntArray(i)), IWireableBlock.WireRecipient.ACTOR);
            }
        }
    }

    public final List<BlockPos> getSensors() {
        return this.sensors;
    }

    public final List<BlockPos> getActors() {
        return this.actors;
    }

    public final boolean hasSensors() {
        return !this.sensors.isEmpty();
    }

    public final boolean hasActors() {
        return !this.actors.isEmpty();
    }

    public final int wireCount() {
        return this.sensors.size() + this.actors.size();
    }

    public abstract boolean processWireConnection(BlockPos var1, IWireableBlock.WireRecipient var2);

    public void reset() {
        this.actors.forEach(p -> IWireableBlock.getWireable(p, this.level).deactivate((BlockPos)p, this.level));
        this.actors.clear();
        this.sensors.clear();
        IWireableBlock wireable = IWireableBlock.getWireable(this.getBlockPos(), this.getLevel());
        if (wireable.isActive(this.getBlockPos(), this.getLevel())) {
            wireable.deactivate(this.getBlockPos(), this.getLevel());
        }
        this.setChanged();
    }

    protected void cleanActors() {
        if (this.actors.removeIf(pos -> {
            BlockState sensorState = this.level.getBlockState(pos);
            return !(sensorState.getBlock() instanceof IWireableBlock) || IWireableBlock.getWireable(pos, this.level).type() != IWireableBlock.WireRecipient.ACTOR;
        })) {
            this.setChanged();
        }
    }

    protected void cleanSensors() {
        if (this.sensors.removeIf(pos -> {
            BlockState sensorState = this.level.getBlockState(pos);
            return !(sensorState.getBlock() instanceof IWireableBlock) || IWireableBlock.getWireable(pos, this.level).type() != IWireableBlock.WireRecipient.SENSOR;
        })) {
            this.setChanged();
        }
    }

    protected final void addWire(BlockPos pos, IWireableBlock.WireRecipient type) {
        switch (type) {
            case ACTOR: {
                if (this.actors.stream().anyMatch(p -> p.distManhattan((Vec3i)pos) == 0)) {
                    return;
                }
                this.actors.add(pos);
                this.setChanged();
                break;
            }
            case SENSOR: {
                if (this.sensors.stream().anyMatch(p -> p.distManhattan((Vec3i)pos) == 0)) {
                    return;
                }
                this.sensors.add(pos);
                this.setChanged();
                break;
            }
        }
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

