/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.IWireableBlock;
import com.lying.block.TrapLogicBlock;
import com.lying.block.entity.AbstractWireableBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrapActorBlockEntity
extends AbstractWireableBlockEntity {
    public TrapActorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.TRAP_ACTOR.get(), pos, state);
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type != CDBlockEntityTypes.TRAP_ACTOR.get() ? null : TrapLogicBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.TRAP_ACTOR.get(), world.isClientSide() ? TrapActorBlockEntity::tickClient : TrapActorBlockEntity::tickServer);
    }

    public static <T extends BlockEntity> void tickClient(Level world, BlockPos pos, BlockState state, TrapActorBlockEntity tile) {
    }

    public static <T extends BlockEntity> void tickServer(Level world, BlockPos pos, BlockState state, TrapActorBlockEntity tile) {
        if (tile.hasSensors()) {
            IWireableBlock actor = IWireableBlock.getWireable(pos, world);
            if (tile.sensorInputState()) {
                actor.activate(pos, world);
            } else {
                actor.deactivate(pos, world);
            }
        }
    }

    public boolean sensorInputState() {
        this.cleanSensors();
        return this.hasSensors() && this.getSensors().stream().anyMatch(p -> IWireableBlock.getWireable(p, this.level).isActive((BlockPos)p, this.level));
    }

    @Override
    public boolean processWireConnection(BlockPos pos, IWireableBlock.WireRecipient type) {
        if (type != IWireableBlock.WireRecipient.SENSOR) {
            return false;
        }
        this.addWire(pos, type);
        return true;
    }
}

