/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block.entity;

import com.lying.block.IWireableBlock;
import com.lying.block.TrapLogicBlock;
import com.lying.block.entity.AbstractWireableBlockEntity;
import com.lying.init.CDBlockEntityTypes;
import com.lying.reference.Reference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrapLogicBlockEntity
extends AbstractWireableBlockEntity {
    private ResourceLocation logicType = Reference.ModInfo.prefix("relay");

    public TrapLogicBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CDBlockEntityTypes.TRAP_LOGIC.get(), pos, state);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putString("Logic", this.logicType.toString());
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.logicType = ResourceLocation.parse((String)nbt.getString("Logic"));
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return type != CDBlockEntityTypes.TRAP_LOGIC.get() ? null : TrapLogicBlock.validateTicker(type, (BlockEntityType)CDBlockEntityTypes.TRAP_LOGIC.get(), world.isClientSide() ? TrapLogicBlockEntity::tickClient : TrapLogicBlockEntity::tickServer);
    }

    public static <T extends BlockEntity> void tickClient(Level world, BlockPos pos, BlockState state, TrapLogicBlockEntity tile) {
    }

    public static <T extends BlockEntity> void tickServer(Level world, BlockPos pos, BlockState state, TrapLogicBlockEntity tile) {
        tile.cleanActors();
        if (!tile.hasActors()) {
            return;
        }
        if (!tile.hasSensors()) {
            tile.getActors().forEach(p -> IWireableBlock.getWireable(pos, world).deactivate(pos, world));
        } else {
            boolean status = tile.sensorInputState();
            tile.getActors().forEach(p -> {
                if (status) {
                    IWireableBlock.getWireable(p, world).activate((BlockPos)p, world);
                } else {
                    IWireableBlock.getWireable(p, world).deactivate((BlockPos)p, world);
                }
            });
        }
    }

    public boolean sensorInputState() {
        this.cleanSensors();
        return this.hasSensors() && this.getSensors().stream().anyMatch(p -> IWireableBlock.getWireable(p, this.level).isActive((BlockPos)p, this.level));
    }

    @Override
    public boolean processWireConnection(BlockPos pos, IWireableBlock.WireRecipient type) {
        if (type == IWireableBlock.WireRecipient.LOGIC) {
            return false;
        }
        this.addWire(pos, type);
        return true;
    }
}

