/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grammar.RoomMetadata;
import com.lying.grid.BlueprintTileGrid;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.grid.TileUtils;
import com.lying.init.CDTiles;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.CompoundBox2f;
import com.lying.utility.LineSegment2f;
import com.lying.utility.LineUtils;
import com.lying.utility.RotaryBox2f;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2i;

public class BlueprintPassage {
    public static final int PASSAGE_HEIGHT = 2;
    public static final int TILE_SIZE = 2;
    public static final int PASSAGE_WIDTH = 6;
    public static final Map<Tile, Float> PASSAGE_TILE_SET = Map.of(CDTiles.PASSAGE_FLOOR.get(), Float.valueOf(10000.0f), CDTiles.AIR.get(), Float.valueOf(10.0f), CDTiles.FLOOR_LIGHT.get(), Float.valueOf(1.0f));
    private final BlueprintRoom parent;
    private final List<BlueprintRoom> children = Lists.newArrayList();
    private CompoundBox2f box;
    private List<LineSegment2f> linesCached = Lists.newArrayList();
    private List<GridTile> tilesCached = Lists.newArrayList();

    public BlueprintPassage(BlueprintRoom a, BlueprintRoom b) {
        this(a, b, 6.0f);
    }

    public BlueprintPassage(BlueprintRoom a, BlueprintRoom b, float width) {
        this(a, b, new LineSegment2f(a.position(), b.position()), width);
    }

    public BlueprintPassage(BlueprintRoom a, BlueprintRoom b, LineSegment2f lineIn, float widthIn) {
        this.parent = a;
        this.children.add(b);
        this.buildBounds();
    }

    public BlueprintRoom parent() {
        return this.parent;
    }

    public List<BlueprintRoom> children() {
        return this.children;
    }

    public BlueprintPassage addChild(BlueprintRoom room) {
        if (this.children.stream().noneMatch(room::equals)) {
            this.children.add(room);
            this.buildBounds();
        }
        return this;
    }

    public int size() {
        return 1 + this.children.size();
    }

    public int lineSegments() {
        return this.asLines().size();
    }

    public double length() {
        double len = 0.0;
        for (LineSegment2f line : this.asLines()) {
            len += (double)line.length();
        }
        return len;
    }

    public double lengthManhattan() {
        double dX = 0.0;
        double dY = 0.0;
        for (LineSegment2f line : this.asLines()) {
            Vec2 delta = line.direction();
            dX += (double)Math.abs(delta.x);
            dY += (double)Math.abs(delta.y);
        }
        return dX + dY;
    }

    public List<LineSegment2f> asLines() {
        if (this.linesCached.isEmpty()) {
            this.cacheLines();
        }
        return this.linesCached;
    }

    public void cacheLines() {
        this.linesCached.clear();
        if (this.children.size() <= 1) {
            this.linesCached.addAll(LineUtils.trialLines(this.parent, this.children.getFirst()));
            return;
        }
        ArrayList positions = Lists.newArrayList();
        positions.add(this.parent.tilePosition());
        this.children.stream().map(BlueprintRoom::tilePosition).forEach(positions::add);
        GridTile median = GridTile.median(positions.toArray(new GridTile[0]));
        BlueprintRoom junction = BlueprintRoom.create();
        junction.setTilePosition(median);
        junction.metadata().setTileSize(1, 1);
        this.linesCached.addAll(LineUtils.trialLines(this.parent, junction));
        this.children.stream().map(child -> LineUtils.trialLines(junction, child)).forEach(this.linesCached::addAll);
    }

    public List<GridTile> tiles() {
        if (this.tilesCached.isEmpty()) {
            this.cacheTiles();
        }
        return this.tilesCached;
    }

    public void cacheTiles() {
        this.tilesCached.clear();
        this.children.forEach(child -> TileUtils.trialTiles(this.parent, child).stream().filter(Predicates.not(this.tilesCached::contains)).forEach(this.tilesCached::add));
    }

    public GraphTileGrid asTiles() {
        return (GraphTileGrid)new GraphTileGrid().addAllToVolume(this.tiles());
    }

    public static List<Vec2> asPoints(List<LineSegment2f> lines) {
        ArrayList points = Lists.newArrayList();
        lines.stream().forEach(l -> {
            Vec2 right;
            Vec2 left = l.getLeft();
            if (!points.contains(left)) {
                points.add(left);
            }
            if (!points.contains(right = l.getRight())) {
                points.add(right);
            }
        });
        return points;
    }

    public BlueprintPassage exclude(AbstractBox2f box) {
        if (this.linesCached.isEmpty()) {
            this.asLines();
            if (this.linesCached.isEmpty()) {
                return this;
            }
        }
        this.linesCached.removeIf(box::contains);
        ArrayList clipped = Lists.newArrayList();
        this.linesCached.stream().map(l -> l.clip(box)).filter(Objects::nonNull).forEach(clipped::add);
        this.linesCached.clear();
        this.linesCached.addAll(clipped);
        return this;
    }

    public Vec2 getStart() {
        return this.asLines().getFirst().getLeft();
    }

    public Vec2 getEnd() {
        return this.asLines().getLast().getRight();
    }

    public AbstractBox2f tileBounds() {
        return this.box;
    }

    public List<AABB> worldBox() {
        ArrayList boxes = Lists.newArrayList();
        for (GridTile tile : this.tiles()) {
            boxes.add(GridTile.BOX.move((double)(tile.x * 2), 0.0, (double)(tile.y * 2)).setMaxY(2.0));
        }
        return boxes;
    }

    protected void buildBounds() {
        this.box = new CompoundBox2f();
        for (GridTile tile : this.tiles()) {
            this.box.add(GridTile.BOUNDS.move(new Vec2((float)tile.x, (float)tile.y)));
        }
    }

    protected static CompoundBox2f lineToBox(List<LineSegment2f> segments, float width) {
        CompoundBox2f box = new CompoundBox2f();
        for (LineSegment2f l : segments) {
            box.add(RotaryBox2f.fromLine(l, width));
        }
        return box;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminus(Vec2 point) {
        Vector2i vec = new Vector2i((int)point.x, (int)point.y);
        if (this.parent.position().equals((Object)vec)) return true;
        if (!this.children.stream().map(BlueprintRoom::position).anyMatch(arg_0 -> ((Vector2i)vec).equals(arg_0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminus(BlueprintRoom room) {
        if (room.equals(this.parent)) return true;
        if (!this.children.stream().anyMatch(room::equals)) return false;
        return true;
    }

    public boolean canShareSpaceWith(BlueprintPassage other) {
        int endDepth = this.parent.metadata().depth() + 1;
        Predicate<RoomMetadata> depthMatch = m -> m.depth() == endDepth;
        return other.parent.equals(this.parent) && other.children.stream().map(BlueprintRoom::metadata).allMatch(depthMatch);
    }

    public boolean intersects(BlueprintPassage other) {
        List<GridTile> otherTiles = other.tiles();
        return this.tiles().stream().anyMatch(l -> otherTiles.stream().anyMatch(l::isAdjacentTo));
    }

    public boolean canMergeWith(BlueprintPassage other) {
        if (!this.canShareSpaceWith(other)) {
            return false;
        }
        List<GridTile> myTiles = this.tiles();
        return other.tiles().stream().anyMatch(p2 -> myTiles.stream().anyMatch(p2::isAdjacentTo));
    }

    public BlueprintPassage mergeWith(BlueprintPassage b) {
        int previous = this.children.size();
        for (BlueprintRoom child : b.children) {
            if (!this.children.stream().noneMatch(child::equals)) continue;
            this.children.add(child);
        }
        if (this.children.size() != previous) {
            this.cacheLines();
            this.cacheTiles();
            this.buildBounds();
        }
        return this;
    }

    public boolean intersectsOtherPassages(Blueprint chart) {
        List<BlueprintPassage> paths = chart.passages();
        return paths.stream().filter(Predicates.not(this::canShareSpaceWith)).anyMatch(this::intersects);
    }

    public boolean intersectsOtherRooms(List<BlueprintRoom> chart) {
        List<GridTile> myTiles = this.tiles();
        return chart.stream().filter(p -> {
            if (this.parent.equals(p)) return false;
            if (!this.children.stream().noneMatch(p::equals)) return false;
            return true;
        }).anyMatch(r -> r.tiles().stream().anyMatch(t -> myTiles.stream().anyMatch(t::isAdjacentTo)));
    }

    public void generate(BlockPos origin, ServerLevel world) {
        BlueprintTileGrid map = BlueprintTileGrid.fromGraphGrid(this.asTiles(), 2);
        GraphTileGrid parent = this.parent().tileGrid();
        BlockPos doorPos = null;
        GridTile doorGrid = null;
        for (BlockPos p : map.contents()) {
            doorGrid = new GridTile(p.getX(), p.getZ());
            if (!parent.containsAdjacent(doorGrid)) continue;
            doorPos = p.atY(1);
            map.put(doorPos.below(), CDTiles.FLOOR_PRISTINE.get());
            map.put(doorPos, CDTiles.DOORWAY.get());
            break;
        }
        TileGenerator.generate(map, PASSAGE_TILE_SET, world.random);
        map.finalise();
        if (doorPos != null) {
            for (Direction face : Direction.Plane.HORIZONTAL) {
                if (!parent.contains(doorGrid.offset(face))) continue;
                map.finalise(new BlueprintTileGrid.TileInstance(doorPos, CDTiles.DOORWAY.get(), Tile.RotationSupplier.faceToRotationMap.get(face)));
                break;
            }
        }
        map.generate(origin, world);
    }
}

