/*
 * Decompiled with CFR 0.152.
 */
package com.lying.blueprint;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintRoom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.joml.Vector2ic;

public class BlueprintPather {
    public static List<BlueprintRoom> calculateCriticalPath(Blueprint chart) {
        Optional<BlueprintRoom> start = chart.start();
        Optional<BlueprintRoom> end = chart.end();
        return start.isPresent() && end.isPresent() ? BlueprintPather.calculatePathBetween(start.get(), end.get(), chart) : Lists.newArrayList();
    }

    public static List<BlueprintRoom> calculatePathBetween(BlueprintRoom start, BlueprintRoom end, Blueprint chart) {
        HashMap<BlueprintRoom, BlueprintRoom> pathMap = new HashMap<BlueprintRoom, BlueprintRoom>();
        ArrayList checkList = Lists.newArrayList();
        checkList.add(start);
        ArrayList checkedList = Lists.newArrayList();
        Comparator distSort = (a, b) -> {
            double distB;
            double distA = a.position().distance((Vector2ic)end.position());
            return distA < (distB = b.position().distance((Vector2ic)end.position())) ? -1 : (distA > distB ? 1 : 0);
        };
        while (!checkList.isEmpty()) {
            checkList.removeAll(checkedList);
            checkList.sort(distSort);
            BlueprintRoom node = (BlueprintRoom)checkList.get(0);
            checkedList.add(node);
            if (node.equals(end)) {
                ArrayList finalPath = Lists.newArrayList();
                BlueprintRoom point = node;
                finalPath.add(point);
                while (pathMap.containsKey(point)) {
                    point = (BlueprintRoom)pathMap.get(point);
                    finalPath.add(point);
                }
                return finalPath;
            }
            for (BlueprintRoom child : node.getChildren(chart)) {
                checkList.add(child);
                pathMap.put(child, node);
            }
        }
        return Lists.newArrayList();
    }
}

