/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.block;

import com.lying.block.entity.AbstractWireableBlockEntity;
import com.lying.init.CDItems;
import com.lying.reference.Reference;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class WireableBlockEntityRenderer<T extends AbstractWireableBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Minecraft mc = Minecraft.getInstance();
    private static final ResourceLocation WIRE_TEXTURE = Reference.ModInfo.prefix("textures/wire.png");
    private static final RenderType LAYER = RenderType.entityCutoutNoCull((ResourceLocation)WIRE_TEXTURE);
    public static final int WIRE_COLOUR = 42233;

    public WireableBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (WireableBlockEntityRenderer.mc.player == null || WireableBlockEntityRenderer.mc.level == null || !WireableBlockEntityRenderer.mc.player.getMainHandItem().is((Item)CDItems.WIRING_GUN.get()) && !WireableBlockEntityRenderer.mc.player.getOffhandItem().is((Item)CDItems.WIRING_GUN.get())) {
            return;
        }
        BlockPos here = entity.getBlockPos();
        ((AbstractWireableBlockEntity)((Object)entity)).getSensors().forEach(pos -> WireableBlockEntityRenderer.drawWireBetween(pos, here, here, tickDelta, matrices, vertexConsumers));
        ((AbstractWireableBlockEntity)((Object)entity)).getActors().forEach(pos -> WireableBlockEntityRenderer.drawWireBetween(here, pos, here, tickDelta, matrices, vertexConsumers));
    }

    private static void drawWireBetween(BlockPos start, BlockPos end, BlockPos origin, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
        matrices.pushPose();
        Vec3 o = new Vec3((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
        Vec3 v1 = new Vec3((double)start.getX(), (double)start.getY(), (double)start.getZ()).add(0.5);
        Vec3 v2 = new Vec3((double)end.getX(), (double)end.getY(), (double)end.getZ()).add(0.5);
        int red = 0;
        int green = 164;
        int blue = 249;
        WireableBlockEntityRenderer.renderWire(v1, v2, o, (float)Math.toRadians(45.0), matrices, vertexConsumers, LAYER, 1, red, green, blue);
        matrices.popPose();
    }

    public static void renderWire(Vec3 start, Vec3 dest, Vec3 origin, float roll, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, RenderType layer, int textureHeight, int red, int green, int blue) {
        Vec3 offset = dest.subtract(start);
        matrixStack.pushPose();
        matrixStack.translate(start.x - origin.x, start.y - origin.y, start.z - origin.z);
        float chainLength = (float)offset.length();
        offset = offset.normalize();
        float n = (float)Math.acos(offset.y);
        float o = (float)Math.atan2(offset.z, offset.x);
        matrixStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - o) * 57.295776f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(n * 57.295776f));
        float af = Mth.cos((float)(roll + (float)Math.PI)) * 0.2f;
        float ag = Mth.sin((float)(roll + (float)Math.PI)) * 0.2f;
        float ah = Mth.cos((float)(roll + 0.0f)) * 0.2f;
        float ai = Mth.sin((float)(roll + 0.0f)) * 0.2f;
        float aj = Mth.cos((float)(roll + 1.5707964f)) * 0.2f;
        float ak = Mth.sin((float)(roll + 1.5707964f)) * 0.2f;
        float al = Mth.cos((float)(roll + 4.712389f)) * 0.2f;
        float am = Mth.sin((float)(roll + 4.712389f)) * 0.2f;
        float an = chainLength;
        float textureStart = 0.0f;
        float textureEnd = chainLength / (float)textureHeight;
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(layer);
        PoseStack.Pose entry = matrixStack.last();
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, af, an, ag, red, green, blue, 0.4999f, textureStart);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, af, 0.0f, ag, red, green, blue, 0.4999f, textureEnd);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, ah, 0.0f, ai, red, green, blue, 0.0f, textureEnd);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, ah, an, ai, red, green, blue, 0.0f, textureStart);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, aj, an, ak, red, green, blue, 0.4999f, textureStart);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, aj, 0.0f, ak, red, green, blue, 0.4999f, textureEnd);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, al, 0.0f, am, red, green, blue, 0.0f, textureEnd);
        WireableBlockEntityRenderer.vertex(vertexConsumer, entry, al, an, am, red, green, blue, 0.0f, textureStart);
        matrixStack.popPose();
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose entry, float x, float y, float z, int red, int green, int blue, float u, float v) {
        vertexConsumer.addVertex(entry.pose(), x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, 1.0f, 0.0f);
    }
}

