/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintOrganiser;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.blueprint.BlueprintScruncher;
import com.lying.client.screen.NodeRenderUtils;
import com.lying.reference.Reference;
import com.lying.screen.DungeonScreenHandler;
import com.lying.utility.Box2f;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class DungeonScreen
extends AbstractContainerScreen<DungeonScreenHandler> {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final ResourceLocation ICON_TEX = Reference.ModInfo.prefix("textures/gui/tree_node.png");
    private State state = State.BLUEPRINT;
    public static int renderScale = 1;
    static boolean showCriticalPath = false;
    public static List<BlueprintPassage> criticalPath = Lists.newArrayList();
    public static List<BlueprintPassage> totalPassages = Lists.newArrayList();
    private final Long randSeed;
    private Vector2i displayOffset = new Vector2i(0, 0);
    private Vector2i dragStart = null;
    private Button scrunchButton;
    private Button collapseButton;
    private Button criticalButton;
    private Button[] blueprintButtons;
    private Blueprint blueprint = null;
    private Map<Blueprint.ErrorType, Integer> errorCache = new HashMap<Blueprint.ErrorType, Integer>();
    private Box2f originBox = null;
    private List<LineSegment2f> originLines = Lists.newArrayList();

    public DungeonScreen(DungeonScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.randSeed = System.currentTimeMillis();
        renderScale = 16;
        showCriticalPath = false;
    }

    protected void init() {
        Button tree = Button.builder((Component)Component.literal((String)"Tree"), b -> this.organise(BlueprintOrganiser.Tree::create)).bounds(0, 0, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)tree);
        Button x4 = Button.builder((Component)Component.literal((String)"4x Grid"), b -> this.organise(BlueprintOrganiser.Grid.Square::create)).bounds(0, 20, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)x4);
        Button x8 = Button.builder((Component)Component.literal((String)"8x Grid"), b -> this.organise(BlueprintOrganiser.Grid.Octagonal::create)).bounds(0, 40, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)x8);
        Button circle = Button.builder((Component)Component.literal((String)"Concentric"), b -> this.organise(BlueprintOrganiser.Circular::create)).bounds(0, 60, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)circle);
        this.scrunchButton = Button.builder((Component)Component.literal((String)"Scrunch"), b -> this.scrunch()).bounds(0, 90, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.scrunchButton);
        this.collapseButton = Button.builder((Component)Component.literal((String)"Collapse"), b -> this.collapse()).bounds(0, 110, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.collapseButton);
        Button goStart = Button.builder((Component)Component.literal((String)"O"), b -> this.resetDrag()).tooltip(Tooltip.create((Component)Component.literal((String)"Focus Start"))).bounds(this.width - 20, 0, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)goStart);
        this.criticalButton = Button.builder((Component)Component.literal((String)"X"), b -> {
            showCriticalPath = !showCriticalPath;
        }).tooltip(Tooltip.create((Component)Component.literal((String)"Toggle Critical Path"))).bounds(this.width - 20, 25, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.criticalButton);
        this.blueprintButtons = new Button[]{tree, x4, x8, circle, this.scrunchButton, this.collapseButton, goStart, this.criticalButton};
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Mode"), b -> {
            this.state = State.values()[(this.state.ordinal() + 1) % State.values().length];
        }).bounds(this.width - 60, this.height - 20, 60, 20).build());
    }

    private void organise(Supplier<BlueprintOrganiser> organiser) {
        organiser.get().organise(this.blueprint, RandomSource.create((long)this.randSeed));
        this.cacheErrors();
        this.updatePathCaches();
        this.resetDrag();
    }

    private void scrunch() {
        BlueprintScruncher.scrunch(this.blueprint, false);
        BlueprintScruncher.scrunch(this.blueprint, true);
        this.cacheErrors();
        this.updatePathCaches();
    }

    private void collapse() {
        BlueprintScruncher.collapse(this.blueprint, false);
        BlueprintScruncher.collapse(this.blueprint, true);
        this.cacheErrors();
        this.updatePathCaches();
    }

    private void cacheErrors() {
        this.errorCache.clear();
        for (Blueprint.ErrorType type : Blueprint.ErrorType.values()) {
            int total = Blueprint.tallyErrors(this.blueprint, type);
            if (total <= 0) continue;
            this.errorCache.put(type, total);
        }
    }

    private void updatePathCaches() {
        totalPassages = BlueprintOrganiser.getFinalisedPassages(this.blueprint);
        if (!this.errorCache.isEmpty()) {
            criticalPath.clear();
            return;
        }
        criticalPath = BlueprintOrganiser.getPassages(this.blueprint.getCriticalPath());
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        switch (this.state.ordinal()) {
            case 0: {
                context.drawString(this.font, this.title, (mc.getWindow().getGuiScaledWidth() - this.font.width((FormattedText)this.title)) / 2, 10, 0xFFFFFF, false);
                if (this.blueprint == null || this.blueprint.isEmpty()) break;
                int totalErrors = 0;
                for (int val : this.errorCache.values()) {
                    totalErrors += val;
                }
                boolean errors = totalErrors > 0;
                MutableComponent details = errors ? Component.translatable((String)"gui.cydun.dungeon_data_long", (Object[])new Object[]{this.blueprint.size(), this.blueprint.maxDepth(), totalErrors, this.errorCache.getOrDefault((Object)Blueprint.ErrorType.COLLISION, 0), this.errorCache.getOrDefault((Object)Blueprint.ErrorType.INTERSECTION, 0), this.errorCache.getOrDefault((Object)Blueprint.ErrorType.TUNNEL, 0)}) : Component.translatable((String)"gui.cydun.dungeon_data", (Object[])new Object[]{this.blueprint.size(), this.blueprint.maxDepth(), 0});
                context.drawString(this.font, (Component)details, (mc.getWindow().getGuiScaledWidth() - this.font.width((FormattedText)details)) / 2, 20, 0xFFFFFF, false);
                if (!errors) break;
                int y = mc.getWindow().getGuiScaledHeight();
                for (Component line : new Component[]{Component.literal((String)"Dark Gray - Errors detected elsewhere"), Component.literal((String)"Lime Green - Path intersects with unrelated room"), Component.literal((String)"Light Blue - Path intersects with unrelated path")}) {
                    Objects.requireNonNull(this.font);
                    context.drawString(this.font, line, 10, y -= 9, ChatFormatting.GRAY.getColor().intValue(), false);
                }
                break;
            }
            case 1: {
                context.drawString(this.font, (Component)Component.literal((String)"Geometry testing"), (mc.getWindow().getGuiScaledWidth() - this.font.width((FormattedText)this.title)) / 2, 10, 0xFFFFFF, false);
            }
        }
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        this.clearFocus();
        switch (this.state.ordinal()) {
            case 0: {
                if (this.blueprint == null || this.blueprint.isEmpty()) {
                    return;
                }
                Vector2i position = this.isDragging() ? new Vector2i(this.displayOffset.x + mouseX - this.dragStart.x, this.displayOffset.y + mouseY - this.dragStart.y) : this.displayOffset;
                Vector2i drawOrigin = new Vector2i(mc.getWindow().getGuiScaledWidth() / 2, mc.getWindow().getGuiScaledHeight() / 5).add((Vector2ic)position);
                NodeRenderUtils.render((BlueprintRoom)this.blueprint.get(0), context, this.font, drawOrigin, this.blueprint, this.errorCache, mouseX, mouseY, renderScale);
                break;
            }
            case 1: {
                Vec2 lineStart = new Vec2((float)(mc.getWindow().getGuiScaledWidth() / 2), (float)(mc.getWindow().getGuiScaledHeight() / 5));
                Vec2 lineEnd = new Vec2((float)mouseX, (float)mouseY);
                LineSegment2f line = new LineSegment2f(lineStart, lineEnd);
                NodeRenderUtils.renderGradientStraightLine(line, context, ARGB.color((int)175, (int)ChatFormatting.AQUA.getColor()));
                Vec2 textPoint = lineStart.add(lineEnd.add(lineStart.negated()).scale(0.5f));
                ArrayList intercepts = Lists.newArrayList();
                for (LineSegment2f edge : this.originLines) {
                    Vec2 intercept = LineSegment2f.segmentIntercept(edge, line);
                    boolean hasIntercept = intercept != null;
                    int colour = hasIntercept ? 0xFFBF00 : 0x6E6E6E;
                    NodeRenderUtils.renderGradientStraightLine(edge, context, colour);
                    if (!hasIntercept) continue;
                    intercepts.add(new Tuple((Object)edge, (Object)intercept));
                }
                intercepts.forEach(p -> {
                    LineSegment2f edge = (LineSegment2f)p.getA();
                    Vec2 intercept = (Vec2)p.getB();
                    Box2f pointBox = new Box2f(intercept.x - 1.0f, intercept.x + 1.0f, intercept.y - 1.0f, intercept.y + 1.0f);
                    NodeRenderUtils.renderBox(pointBox, context, ARGB.color((int)255, (int)ChatFormatting.DARK_RED.getColor()));
                    context.drawString(this.font, (Component)Component.literal((String)edge.asEquation()), (int)(edge.isVertical ? edge.getLeft().x + 5.0f : (edge.getLeft().x + edge.getRight().x) / 2.0f), (int)(edge.isVertical ? (edge.getLeft().y + edge.getRight().y) / 2.0f : edge.getLeft().y + 5.0f), ChatFormatting.DARK_RED.getColor().intValue(), false);
                });
                context.drawString(this.font, (Component)Component.literal((String)line.asEquation()), (int)textPoint.x, (int)textPoint.y, 0xFFFFFF, false);
            }
        }
    }

    public void containerTick() {
        switch (this.state.ordinal()) {
            case 0: {
                for (Button button : this.blueprintButtons) {
                    button.visible = true;
                }
                if (this.blueprint == null) {
                    ((DungeonScreenHandler)this.getMenu()).graph().ifPresent(graph -> {
                        if (graph.isEmpty()) {
                            return;
                        }
                        this.blueprint = Blueprint.fromGraph(graph);
                        this.blueprint.updateCriticalPath();
                        RandomSource rand = RandomSource.create((long)this.randSeed);
                        this.blueprint.forEach(node -> node.metadata().setSize(node.metadata().type().size(rand)));
                        BlueprintOrganiser.Tree.create().organise(this.blueprint, rand);
                        this.cacheErrors();
                        this.updatePathCaches();
                    });
                    break;
                }
                this.collapseButton.active = this.criticalButton.active = this.errorCache.isEmpty();
                this.scrunchButton.active = this.criticalButton.active;
                showCriticalPath = showCriticalPath && this.criticalButton.active;
                break;
            }
            case 1: {
                for (Button button : this.blueprintButtons) {
                    button.visible = false;
                }
                if (this.originBox != null) break;
                Vector2i screenMid = new Vector2i(mc.getWindow().getGuiScaledWidth() / 2, mc.getWindow().getGuiScaledHeight() / 2);
                this.originBox = new Box2f(screenMid.x - 50, screenMid.x + 50, screenMid.y - 50, screenMid.y + 50);
                this.originLines.clear();
                this.originLines.addAll(this.originBox.asEdges());
            }
        }
    }

    public void resetDrag() {
        this.blueprint.start().ifPresent(s -> {
            this.displayOffset = s.position();
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.setDragging(true);
            this.dragStart = new Vector2i((int)mouseX, (int)mouseY);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging()) {
            int xOff = (int)mouseX - this.dragStart.x;
            int yOff = (int)mouseY - this.dragStart.y;
            this.displayOffset = this.displayOffset.add(xOff, yOff);
            this.setDragging(false);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int prevScale = renderScale;
        renderScale = Mth.clamp((int)(renderScale + (int)verticalAmount), (int)1, (int)500);
        float delta = (float)renderScale / (float)prevScale;
        float offX = (float)this.displayOffset.x * delta;
        float offY = (float)this.displayOffset.y * delta;
        this.displayOffset = new Vector2i((int)offX, (int)offY);
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public static enum State {
        BLUEPRINT,
        DEBUG;

    }
}

