/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintPassage;
import com.lying.blueprint.BlueprintRoom;
import com.lying.client.screen.DungeonScreen;
import com.lying.grammar.RoomMetadata;
import com.lying.grid.GridTile;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.Box2f;
import com.lying.utility.CompoundBox2f;
import com.lying.utility.LineSegment2f;
import com.lying.utility.RotaryBox2f;
import com.lying.utility.Vector2iUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class NodeRenderUtils {
    public static final int TILE_SIZE = 2;
    public static final int LIGHT_BLUE = 1931253;
    public static final int LIME_GREEN = 1963319;
    public static final int DARK_GRAY = 0x6E6E6E;
    public static final int PALE_RED = 12071988;
    public static final int GOLD = 0xFFBF00;
    public static final ChatFormatting[] LINE_COLOURS = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE, ChatFormatting.WHITE, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLACK};
    private static int colourIndex = 0;

    public static Function<LineSegment2f, LineSegment2f> scaleFunc(int renderScale, Vector2i origin) {
        Vec2 vec = new Vec2((float)origin.x, (float)origin.y);
        return p -> p.scale(renderScale).offset(vec);
    }

    public static void render(BlueprintRoom node, GuiGraphics context, Font textRenderer, Vector2i origin, Blueprint chart, Map<Blueprint.ErrorType, Integer> errors, int mouseX, int mouseY, int renderScale) {
        chart.forEach(n -> NodeRenderUtils.renderNodeBounds(n, chart.stream().filter(n2 -> !n2.equals(n)).anyMatch(n::intersects), origin, renderScale, context));
        colourIndex = 0;
        NodeRenderUtils.renderLinks(origin, renderScale, chart, !errors.isEmpty(), context, mouseX, mouseY);
        if (DungeonScreen.showCriticalPath) {
            NodeRenderUtils.renderCriticalPath(origin, renderScale, chart, context);
        }
        chart.forEach(n -> NodeRenderUtils.renderNode(n, origin, renderScale, context, textRenderer, mouseX, mouseY));
    }

    public static void renderLinks(Vector2i origin, int renderScale, Blueprint chart, boolean errorsPresent, GuiGraphics context, int mouseX, int mouseY) {
        Function<LineSegment2f, LineSegment2f> scaleFunc = NodeRenderUtils.scaleFunc(renderScale, origin);
        Vec2 mousePos = new Vec2((float)mouseX, (float)mouseY);
        Predicate<BlueprintPassage> showBounds = p -> {
            CompoundBox2f box = (CompoundBox2f)p.tileBounds();
            for (AbstractBox2f sub : box.asBoxes()) {
                Vec2 d;
                Vec2 c;
                Vec2 b;
                ArrayList points = Lists.newArrayList();
                points.addAll(sub.asPoints());
                Vec2 a = ((Vec2)points.removeFirst()).scale((float)renderScale).add(new Vec2((float)origin.x, (float)origin.y));
                if (!new RotaryBox2f(a, b = ((Vec2)points.removeFirst()).scale((float)renderScale).add(new Vec2((float)origin.x, (float)origin.y)), c = ((Vec2)points.removeFirst()).scale((float)renderScale).add(new Vec2((float)origin.x, (float)origin.y)), d = ((Vec2)points.removeFirst()).scale((float)renderScale).add(new Vec2((float)origin.x, (float)origin.y))).contains(mousePos)) continue;
                return true;
            }
            return false;
        };
        DungeonScreen.totalPassages.stream().forEach(p -> {
            int n = errorsPresent ? (p.intersectsOtherPassages(chart) ? 1931253 : (p.intersectsOtherRooms(chart) ? 1963319 : 0x6E6E6E)) : LINE_COLOURS[colourIndex++ % LINE_COLOURS.length].getColor();
            int linkColour = n;
            NodeRenderUtils.renderPath(p, scaleFunc, origin, renderScale, context, linkColour, showBounds.test((BlueprintPassage)p));
        });
    }

    public static void renderCriticalPath(Vector2i origin, int renderScale, Blueprint chart, GuiGraphics context) {
        if (DungeonScreen.criticalPath.isEmpty()) {
            return;
        }
        Function<LineSegment2f, LineSegment2f> scaleFunc = NodeRenderUtils.scaleFunc(renderScale, origin);
        DungeonScreen.criticalPath.forEach(path -> NodeRenderUtils.renderPath(path, scaleFunc, origin, renderScale, context, 0xFFBF00, false));
    }

    public static void renderNodeBounds(BlueprintRoom node, boolean isColliding, Vector2i origin, int renderScale, GuiGraphics context) {
        RoomMetadata metadata = node.metadata();
        int mainColour = isColliding ? 12071988 : metadata.type().colour();
        int borderColour = isColliding ? 12071988 : 0x6E6E6E;
        Vector2i boundsMin = node.tileMin().toVec2i().mul(2);
        Vector2i boundsMax = node.tileMax().toVec2i().mul(2);
        Vector2i shellWidth = new Vector2i(1, 1);
        Vector2i shellMin = Vector2iUtils.copy(boundsMin).sub((Vector2ic)shellWidth);
        Vector2i shellMax = Vector2iUtils.copy(boundsMax).add((Vector2ic)shellWidth);
        shellMin = shellMin.mul(renderScale).add((Vector2ic)origin);
        shellMax = shellMax.mul(renderScale).add((Vector2ic)origin);
        NodeRenderUtils.renderBoundary(shellMin, shellMax, context, ARGB.color((int)130, (int)borderColour));
        node.tileGrid().contents().forEach(tile -> NodeRenderUtils.renderTile(tile, origin, renderScale, context, ARGB.color((int)75, (int)borderColour)));
        boundsMin = boundsMin.mul(renderScale).add((Vector2ic)origin);
        boundsMax = boundsMax.mul(renderScale).add((Vector2ic)origin);
        NodeRenderUtils.renderBoundary(boundsMin, boundsMax, context, ARGB.color((int)255, (int)mainColour));
    }

    public static void renderBoundary(Vector2i min, Vector2i max, GuiGraphics context, int colour) {
        int sizeX = max.x - min.x;
        int sizeY = max.y - min.y;
        context.renderOutline(min.x, min.y, sizeX, sizeY, colour);
    }

    public static void renderBox(Box2f box, GuiGraphics context, int colour) {
        context.renderOutline((int)box.minX(), (int)box.minY(), (int)(box.maxX() - box.minX()), (int)(box.maxY() - box.minY()), colour);
    }

    public static void renderNode(BlueprintRoom node, Vector2i origin, int renderScale, GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
        RoomMetadata metadata = node.metadata();
        Vector2i pos = node.position().mul(renderScale).add((Vector2ic)origin);
        int iconColour = ARGB.color((int)255, (int)metadata.type().colour());
        context.blit(RenderType::guiTextured, DungeonScreen.ICON_TEX, pos.x - 8, pos.y - 8, 0.0f, 0.0f, 16, 16, 16, 16, iconColour);
        if (pos.distance(mouseX, mouseY) < 8.0) {
            MutableComponent title = metadata.name();
            int n = pos.x - textRenderer.width((FormattedText)title) / 2;
            int n2 = pos.y;
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, (Component)title, n, n2 - 9 / 2, 0xFFFFFF, true);
        }
    }

    public static void renderPath(BlueprintPassage path, Function<LineSegment2f, LineSegment2f> scaleFunc, Vector2i origin, int renderScale, GuiGraphics context, int colour, boolean showBounds) {
        path.tiles().forEach(tile -> NodeRenderUtils.renderTile(tile, origin, renderScale, context, ARGB.color((int)75, (int)colour)));
        path.asLines().stream().map(scaleFunc).forEach(l -> NodeRenderUtils.renderGradientStraightLine(l, context, colour, 0xFFFFFF));
    }

    public static void renderTile(GridTile tile, Vector2i origin, int renderScale, GuiGraphics context, int colour) {
        GridTile min = tile.copy();
        GridTile max = min.add(1, 1);
        NodeRenderUtils.renderBoundary(min.toVec2i().mul(2).mul(renderScale).add((Vector2ic)origin), max.toVec2i().mul(2).mul(renderScale).add((Vector2ic)origin), context, colour);
    }

    public static void renderGradientStraightLine(LineSegment2f line, GuiGraphics context, int startRGB, int endRGB) {
        NodeRenderUtils.renderGradientStraightLine(line, 1, context, startRGB, endRGB);
    }

    public static void renderGradientStraightLine(LineSegment2f line, GuiGraphics context, int startRGB) {
        NodeRenderUtils.renderGradientStraightLine(line, 1, context, startRGB, startRGB);
    }

    public static void renderGradientStraightLine(LineSegment2f line, int thickness, GuiGraphics context, int startRGB, int endRGB) {
        NodeRenderUtils.renderGradientStraightLine(line.getLeft(), line.getRight(), thickness, context, startRGB, endRGB);
    }

    public static void renderGradientStraightLine(Vec2 start, Vec2 end, int thickness, GuiGraphics context, int startRGB, int endRGB) {
        Vec2 st = new Vec2(start.x, start.y);
        Vec2 en = new Vec2(end.x, end.y);
        Vec2 dir = en.add(st.negated());
        Vec2 nor = new Vec2(-dir.y, dir.x).normalized();
        int colStart = ARGB.color((int)255, (int)ARGB.red((int)startRGB), (int)ARGB.green((int)startRGB), (int)ARGB.blue((int)startRGB));
        int colEnd = ARGB.color((int)255, (int)ARGB.red((int)endRGB), (int)ARGB.green((int)endRGB), (int)ARGB.blue((int)endRGB));
        PoseStack matrixStack = context.pose();
        matrixStack.pushPose();
        matrixStack.translate(start.x, start.y, 0.0f);
        matrixStack.mulPose(Axis.ZP.rotation((float)Math.atan2(end.y - start.y, end.x - start.x)));
        Vec2 a = st.add(nor.negated());
        Vec2 b = st.add(nor);
        Vec2 c = en.add(nor);
        Vec2 d = en.add(nor.negated());
        Matrix4f matrix4f = new PoseStack().last().pose();
        MultiBufferSource.BufferSource provider = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = provider.getBuffer(RenderType.gui());
        vertexConsumer.addVertex(matrix4f, a.x, a.y, 0.0f).setColor(colStart);
        vertexConsumer.addVertex(matrix4f, b.x, b.y, 0.0f).setColor(colStart);
        vertexConsumer.addVertex(matrix4f, c.x, c.y, 0.0f).setColor(colEnd);
        vertexConsumer.addVertex(matrix4f, d.x, d.y, 0.0f).setColor(colEnd);
        matrixStack.popPose();
    }

    public static void renderStraightLine(LineSegment2f line, int thickness, GuiGraphics context, int rgb) {
        NodeRenderUtils.renderStraightLine(line.getLeft(), line.getRight(), thickness, context, rgb);
    }

    public static void renderStraightLine(Vec2 start, Vec2 end, int thickness, GuiGraphics context, int rgb) {
        Vec2 st = new Vec2(start.x, start.y);
        Vec2 en = new Vec2(end.x, end.y);
        Vec2 dir = en.add(st.negated());
        float len = dir.length();
        int colStart = ARGB.color((int)255, (int)ARGB.red((int)rgb), (int)ARGB.green((int)rgb), (int)ARGB.blue((int)rgb));
        PoseStack matrixStack = context.pose();
        matrixStack.pushPose();
        matrixStack.translate(start.x, start.y, 0.0f);
        matrixStack.mulPose(Axis.ZP.rotation((float)Math.atan2(end.y - start.y, end.x - start.x)));
        context.fill(0, -thickness, (int)len, thickness, colStart);
        matrixStack.popPose();
    }
}

