/*
 * Decompiled with CFR 0.152.
 */
package com.lying.command;

import com.google.common.collect.Lists;
import com.lying.blueprint.Blueprint;
import com.lying.blueprint.BlueprintOrganiser;
import com.lying.blueprint.BlueprintScruncher;
import com.lying.grammar.CDGrammar;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.network.ShowDungeonLayoutPacket;
import com.lying.reference.Reference;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;

public class CDCommands {
    private static final SimpleCommandExceptionType PHRASE_PARSE_FAILED_EXCEPTION = CDCommands.make("phrase_parse_failed");
    private static final SimpleCommandExceptionType GRAPH_FAILED_EXCEPTION = CDCommands.make("graph_failed");
    private static final SimpleCommandExceptionType SCRUNCH_FAILED_EXCEPTION = CDCommands.make("scrunch_failed");
    private static final SimpleCommandExceptionType GENERATION_FAILED_EXCEPTION = CDCommands.make("generation_failed");

    private static SimpleCommandExceptionType make(String name) {
        return new SimpleCommandExceptionType((Message)Reference.ModInfo.translate("command", name.toLowerCase()));
    }

    public static void init() {
        CommandRegistrationEvent.EVENT.register((dispatcher, access, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cydun").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"parse").then(Commands.argument((String)"phrase", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> CDCommands.tryParsePhrase(CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"phrase"), (CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"preview").then(((RequiredArgumentBuilder)Commands.argument((String)"phrase", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> CDCommands.tryPreview(CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"phrase"), RandomSource.create(), (CommandSourceStack)context.getSource()))).then(Commands.argument((String)"seed", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> CDCommands.tryPreview(CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"phrase"), RandomSource.create((long)CDCommands.getRandSeed((CommandContext<CommandSourceStack>)context, "seed")), (CommandSourceStack)context.getSource()))))).then(((RequiredArgumentBuilder)Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CDCommands.tryPreview(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), RandomSource.create(), (CommandSourceStack)context.getSource()))).then(Commands.argument((String)"seed", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> CDCommands.tryPreview(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), RandomSource.create((long)CDCommands.getRandSeed((CommandContext<CommandSourceStack>)context, "seed")), (CommandSourceStack)context.getSource())))))).then(Commands.literal((String)"generate").then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> CDCommands.generateInWorld(IntegerArgumentType.getInteger((CommandContext)context, (String)"size"), BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), (CommandSourceStack)context.getSource())))))));
    }

    public static GrammarPhrase parsePhrase(CompoundTag nbt) throws CommandSyntaxException {
        if (nbt.contains("Phrase", 9)) {
            ListTag phrase = nbt.getList("Phrase", 8);
            if (phrase.isEmpty()) {
                throw PHRASE_PARSE_FAILED_EXCEPTION.create();
            }
            ArrayList terms = Lists.newArrayList();
            phrase.forEach(e -> terms.add(e.getAsString()));
            return GrammarPhrase.parsePhrase(terms.toArray(new String[0]));
        }
        throw PHRASE_PARSE_FAILED_EXCEPTION.create();
    }

    private static int tryParsePhrase(CompoundTag nbt, CommandSourceStack source) throws CommandSyntaxException {
        GrammarPhrase graph = CDCommands.parsePhrase(nbt);
        if (graph.isEmpty()) {
            throw PHRASE_PARSE_FAILED_EXCEPTION.create();
        }
        if (source.getPlayer() != null) {
            ShowDungeonLayoutPacket.sendTo(source.getPlayer(), graph, false);
        }
        return graph.size();
    }

    private static int tryPreview(CompoundTag nbt, RandomSource rand, CommandSourceStack source) throws CommandSyntaxException {
        GrammarPhrase graph = CDCommands.parsePhrase(nbt);
        if (graph.isEmpty()) {
            throw PHRASE_PARSE_FAILED_EXCEPTION.create();
        }
        CDGrammar.generate(graph, rand);
        if (source.getPlayer() != null) {
            ShowDungeonLayoutPacket.sendTo(source.getPlayer(), graph, true);
        }
        return graph.size();
    }

    private static int tryPreview(int size, RandomSource rand, CommandSourceStack source) {
        GrammarPhrase graph = CDGrammar.initialGraph(size, rand);
        CDGrammar.generate(graph, rand);
        if (source.getPlayer() != null) {
            ShowDungeonLayoutPacket.sendTo(source.getPlayer(), graph, true);
        }
        return graph.size();
    }

    private static Component roomToText(GrammarRoom r) {
        return Component.literal((String)"  ".repeat(r.metadata().depth())).append((Component)r.name());
    }

    private static int getRandSeed(CommandContext<CommandSourceStack> context, String name) {
        BlockPos position = BlockPosArgument.getBlockPos(context, (String)name);
        return position.getX() * position.getX() + position.getZ() * position.getZ();
    }

    private static int generateInWorld(int size, BlockPos position, CommandSourceStack source) throws CommandSyntaxException {
        RandomSource rand = RandomSource.create((long)(position.getX() * position.getX() + position.getZ() * position.getZ()));
        GrammarPhrase graph = CDGrammar.initialGraph(size, rand);
        CDGrammar.generate(graph, rand);
        Blueprint blueprint = Blueprint.fromGraph(graph);
        blueprint.forEach(node -> node.metadata().setSize(node.metadata().type().size(rand)));
        BlueprintOrganiser.Circular.create().organise(blueprint, rand);
        if (blueprint.hasErrors()) {
            throw GRAPH_FAILED_EXCEPTION.create();
        }
        BlueprintScruncher.collapse(blueprint, false);
        if (blueprint.hasErrors()) {
            throw SCRUNCH_FAILED_EXCEPTION.create();
        }
        ServerLevel world = source.getLevel();
        if (!blueprint.build(position, world)) {
            throw GENERATION_FAILED_EXCEPTION.create();
        }
        return 15;
    }
}

