/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarTerm;
import com.lying.grammar.RoomMetadata;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class GrammarRoom {
    public static final Codec<GrammarRoom> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("Uuid").forGetter(GrammarRoom::uuid), (App)RoomMetadata.CODEC.fieldOf("Metadata").forGetter(GrammarRoom::metadata), (App)UUIDUtil.STRING_CODEC.listOf().fieldOf("Children").forGetter(GrammarRoom::getChildLinks), (App)UUIDUtil.STRING_CODEC.listOf().fieldOf("Parents").forGetter(GrammarRoom::getParentLinks)).apply((Applicative)instance, (id, meta, doors, entries) -> {
        GrammarRoom room = new GrammarRoom((UUID)id);
        room.metadata = meta;
        doors.forEach(child -> room.childLinks.add((UUID)child));
        entries.forEach(parent -> room.parentLinks.add((UUID)parent));
        return room;
    }));
    public static final int MAX_LINKS = 4;
    private final UUID id;
    private RoomMetadata metadata = new RoomMetadata();
    private List<UUID> childLinks = Lists.newArrayList();
    private List<UUID> parentLinks = Lists.newArrayList();

    public GrammarRoom(UUID idIn) {
        this.id = idIn;
    }

    public GrammarRoom() {
        this(UUID.randomUUID());
    }

    public static Comparator<GrammarRoom> branchSort(GrammarPhrase graph) {
        return (a, b) -> {
            int bD;
            int aD = a.tallyDescendants(graph);
            return aD < (bD = b.tallyDescendants(graph)) ? -1 : (aD > bD ? 1 : 0);
        };
    }

    public final UUID uuid() {
        return this.id;
    }

    public final boolean matches(GrammarRoom b) {
        return b.id.equals(this.id);
    }

    public final MutableComponent name() {
        return this.metadata.name();
    }

    public final String asString() {
        return this.metadata.asString();
    }

    public final Tag toNbt() {
        return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow();
    }

    public static final Optional<GrammarRoom> fromNbt(Tag nbt) {
        DataResult room = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt);
        if (room.isSuccess()) {
            return Optional.of((GrammarRoom)room.getOrThrow());
        }
        return Optional.empty();
    }

    public RoomMetadata metadata() {
        return this.metadata;
    }

    public boolean hasLinks() {
        return !this.childLinks.isEmpty();
    }

    public boolean hasLinkTo(UUID uuid) {
        return !this.childLinks.isEmpty() && this.childLinks.contains(uuid);
    }

    public List<UUID> getChildLinks() {
        return List.of(this.childLinks.toArray(new UUID[0]));
    }

    public List<UUID> getParentLinks() {
        return List.of(this.parentLinks.toArray(new UUID[0]));
    }

    public int getTotalLinks() {
        return this.childLinks.size() + this.parentLinks.size();
    }

    public boolean canAddLink() {
        return this.getTotalLinks() < 4;
    }

    public int tallyDescendants(GrammarPhrase graph) {
        int tally = this.childLinks.size();
        for (UUID offshoot : this.childLinks) {
            Optional<GrammarRoom> r = graph.get(offshoot);
            if (r.isEmpty()) continue;
            tally += r.get().tallyDescendants(graph);
        }
        return tally;
    }

    public GrammarRoom linkTo(GrammarRoom otherRoom) {
        this.childLinks.add(otherRoom.uuid());
        otherRoom.parentLinks.add(this.id);
        return this;
    }

    public GrammarRoom detachFrom(GrammarRoom otherRoom) {
        if (this.hasLinks() && this.hasLinkTo(otherRoom.uuid())) {
            this.childLinks.remove(otherRoom.uuid());
            otherRoom.parentLinks.remove(this.id);
        }
        return this;
    }

    @NotNull
    public List<GrammarRoom> getChildRooms(GrammarPhrase graph) {
        ArrayList links = Lists.newArrayList();
        this.childLinks.stream().map(graph::get).filter(Optional::isPresent).map(Optional::get).forEach(links::add);
        return links;
    }

    @NotNull
    public List<GrammarRoom> getParentRooms(GrammarPhrase graph) {
        ArrayList links = Lists.newArrayList();
        this.parentLinks.stream().map(graph::get).filter(Optional::isPresent).map(Optional::get).forEach(links::add);
        return links;
    }

    public GrammarRoom applyTerm(GrammarTerm termIn, GrammarPhrase graph) {
        termIn.applyTo(this, graph);
        return this;
    }
}

