/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grammar;

import com.google.common.collect.Lists;
import com.lying.grammar.GrammarPhrase;
import com.lying.grammar.GrammarRoom;
import com.lying.grammar.GrammarTerm;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class TermConditions {
    private boolean afterSelf = true;
    private boolean deadEnds = true;
    private int maxPop = -1;
    private int sizeCap = -1;
    private int depthMin = -1;
    private List<Supplier<GrammarTerm>> after = Lists.newArrayList();
    private List<Supplier<GrammarTerm>> before = Lists.newArrayList();
    private List<Supplier<GrammarTerm>> notAfter = Lists.newArrayList();
    private List<Supplier<GrammarTerm>> notBefore = Lists.newArrayList();

    protected TermConditions() {
    }

    public static TermConditions create() {
        return new TermConditions();
    }

    public TermConditions nonconsecutive(boolean val) {
        this.afterSelf = val;
        return this;
    }

    public TermConditions afterDepth(int dep) {
        this.depthMin = dep;
        return this;
    }

    public TermConditions allowDeadEnds(boolean val) {
        this.deadEnds = val;
        return this;
    }

    public TermConditions popCap(int cap) {
        this.maxPop = cap;
        return this;
    }

    public TermConditions sizeCap(int cap) {
        this.sizeCap = cap;
        return this;
    }

    public TermConditions onlyAfter(List<Supplier<GrammarTerm>> term) {
        this.after.addAll(term);
        return this;
    }

    public TermConditions neverAfter(List<Supplier<GrammarTerm>> term) {
        this.notAfter.addAll(term);
        return this;
    }

    public TermConditions onlyBefore(List<Supplier<GrammarTerm>> term) {
        this.before.addAll(term);
        return this;
    }

    public TermConditions neverBefore(List<Supplier<GrammarTerm>> term) {
        this.notBefore.addAll(term);
        return this;
    }

    public boolean test(GrammarTerm term, GrammarRoom inRoom, List<GrammarRoom> previous, List<GrammarRoom> next, GrammarPhrase graph) {
        if (this.sizeCap > 0 && graph.size() >= this.sizeCap) {
            return false;
        }
        if (this.depthMin > 0 && inRoom.metadata().depth() <= this.depthMin) {
            return false;
        }
        if (this.maxPop > 0 && graph.tally(term) >= this.maxPop) {
            return false;
        }
        if (!this.deadEnds && !inRoom.hasLinks()) {
            return false;
        }
        Predicate<GrammarTerm> prevCheck = t -> GrammarTerm.checkListFor(previous, t);
        Predicate<GrammarTerm> nextCheck = t -> GrammarTerm.checkListFor(next, t);
        if (!this.afterSelf && (prevCheck.test(term) || nextCheck.test(term))) {
            return false;
        }
        if (!this.after.isEmpty()) {
            if (TermConditions.terms(this.after).noneMatch(prevCheck::test)) {
                return false;
            }
        }
        if (!this.before.isEmpty()) {
            if (TermConditions.terms(this.before).noneMatch(nextCheck::test)) {
                return false;
            }
        }
        if (!this.notAfter.isEmpty()) {
            if (TermConditions.terms(this.notAfter).anyMatch(prevCheck::test)) {
                return false;
            }
        }
        if (!this.notBefore.isEmpty()) {
            if (TermConditions.terms(this.notBefore).anyMatch(nextCheck::test)) {
                return false;
            }
        }
        return true;
    }

    private static Stream<GrammarTerm> terms(List<Supplier<GrammarTerm>> setIn) {
        return setIn.stream().map(Supplier::get).filter(Objects::nonNull);
    }
}

