/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.lying.grid.AbstractTileGrid;
import com.lying.grid.GridTile;
import java.util.List;
import net.minecraft.core.Direction;
import org.joml.Math;

public class GraphTileGrid
extends AbstractTileGrid<GridTile> {
    @Override
    public AbstractTileGrid<GridTile> addToVolume(GridTile from, GridTile to) {
        int minX = Math.min((int)from.x, (int)to.x);
        int maxX = Math.max((int)from.x, (int)to.x);
        int minY = Math.min((int)from.y, (int)to.y);
        int maxY = Math.max((int)from.y, (int)to.y);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                this.addToVolume(new GridTile(x, y));
            }
        }
        return this;
    }

    @Override
    public boolean containsAdjacent(GridTile pos) {
        return this.set.keySet().stream().anyMatch(p2 -> p2.manhattanDistance(pos) == 1);
    }

    @Override
    public void grow(Direction direction, int size) {
        this.getBoundaries(List.of(direction)).forEach(p -> {
            for (int i = 0; i < size; ++i) {
                this.addToVolume(p.offset(direction));
            }
        });
    }

    @Override
    public List<GridTile> getBoundaries(List<Direction> faces) {
        return this.set.keySet().stream().filter(p -> faces.stream().anyMatch(f -> this.isBoundary((GridTile)p, (Direction)f))).toList();
    }

    public boolean isBoundary(GridTile pos) {
        return Direction.Plane.HORIZONTAL.stream().anyMatch(d -> this.isBoundary(pos, (Direction)d));
    }

    public boolean isBoundary(GridTile pos, Direction side) {
        return !this.contains(pos.offset(side));
    }
}

