/*
 * Decompiled with CFR 0.152.
 */
package com.lying.grid;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintRoom;
import com.lying.grid.GraphTileGrid;
import com.lying.grid.GridTile;
import com.lying.utility.Line2f;
import com.lying.utility.LineSegment2f;
import com.lying.utility.LineUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;

public class TileUtils {
    private static final int TILE_SIZE = 2;

    public static List<GridTile> trialTiles(BlueprintRoom start, BlueprintRoom end) {
        ArrayList tiles = Lists.newArrayList();
        tiles.addAll(TileUtils.toTiles(LineUtils.trialLines(start, end)));
        tiles.removeIf(t -> start.tileGrid().contains(t) || end.tileGrid().contains(t));
        return tiles;
    }

    public static List<GridTile> spanRooms(BlueprintRoom start, BlueprintRoom end) {
        GridTile outOfEnd;
        GridTile endDoor;
        GridTile startPos = start.tilePosition();
        GridTile endPos = end.tilePosition();
        GraphTileGrid startGrid = start.tileGrid();
        GraphTileGrid endGrid = end.tileGrid();
        GridTile startTile = startGrid.getBoundaries().stream().filter(p -> Direction.Plane.HORIZONTAL.stream().filter(d -> startGrid.isBoundary((GridTile)p, (Direction)d)).count() == 1L).sorted(GridTile.distSort(endPos)).findFirst().get();
        GridTile endTile = endGrid.getBoundaries().stream().filter(p -> Direction.Plane.HORIZONTAL.stream().filter(d -> endGrid.isBoundary((GridTile)p, (Direction)d)).count() == 1L).sorted(GridTile.distSort(startPos)).findFirst().get();
        Direction startFace = Direction.Plane.HORIZONTAL.stream().filter(d -> startGrid.isBoundary(startTile, (Direction)d)).findFirst().get();
        Direction endFace = Direction.Plane.HORIZONTAL.stream().filter(d -> endGrid.isBoundary(endTile, (Direction)d)).findFirst().get();
        GridTile startDoor = startTile.offset(startFace);
        if (startDoor.equals(endDoor = endTile.offset(endFace))) {
            return List.of(startDoor);
        }
        if (startDoor.isAdjacentTo(endDoor)) {
            return List.of(startDoor, endDoor);
        }
        GridTile outOfStart = startDoor.offset(startFace);
        if (outOfStart.equals(outOfEnd = endDoor.offset(endFace))) {
            return List.of(startDoor, outOfStart, endDoor);
        }
        ArrayList occupiedFaces = Lists.newArrayList();
        occupiedFaces.add(startDoor);
        occupiedFaces.addAll(TileUtils.adjoinTiles(outOfStart, outOfEnd));
        occupiedFaces.add(endDoor);
        return occupiedFaces;
    }

    public static List<GridTile> toTiles(List<LineSegment2f> lines) {
        ArrayList tiles = Lists.newArrayList();
        for (LineSegment2f line : lines) {
            TileUtils.lineToTiles(line).stream().filter(Predicates.not(tiles::contains)).forEach(tiles::add);
        }
        return tiles;
    }

    public static List<GridTile> lineToTiles(LineSegment2f line) {
        if (line.length() <= 2.0f) {
            Vec2 point = line.getLeft().add(line.direction().scale(0.5f));
            return List.of(new GridTile(Math.floorDiv((int)point.x, 2), Math.floorDiv((int)point.y, 2)));
        }
        GridTile startTile = new GridTile(Math.floorDiv((int)line.getLeft().x, 2), Math.floorDiv((int)line.getLeft().y, 2));
        GridTile endTile = new GridTile(Math.floorDiv((int)line.getRight().x, 2), Math.floorDiv((int)line.getRight().y, 2));
        return TileUtils.lineToTiles(line, startTile, endTile);
    }

    public static List<GridTile> lineToTiles(LineSegment2f line, GridTile startTile, GridTile endTile) {
        ArrayList set = Lists.newArrayList();
        int len = (int)(line.length() / 2.0f);
        Vec2 dir = line.direction().normalized();
        for (int i = 0; i < len; ++i) {
            GridTile offset = GridTile.fromVec(dir.scale((float)i));
            GridTile tile = startTile.add(offset);
            if (set.contains(tile)) continue;
            set.add(tile);
        }
        if (!set.contains(endTile)) {
            set.add(endTile);
        }
        ArrayList additions = Lists.newArrayList();
        for (int i = 1; i < set.size(); ++i) {
            additions.addAll(TileUtils.adjoinTiles((GridTile)set.get(i - 1), (GridTile)set.get(i)));
        }
        additions.removeIf(set::contains);
        set.addAll(additions);
        return set;
    }

    private static List<GridTile> adjoinTiles(GridTile start, GridTile end) {
        ArrayList adjoin = Lists.newArrayList();
        Line2f line = new Line2f(start.toVec2i(), end.toVec2i());
        int minX = Math.min(start.x, end.x);
        int maxX = Math.max(start.x, end.x);
        int minY = Math.min(start.y, end.y);
        int maxY = Math.max(start.y, end.y);
        if (line.isVertical) {
            for (int y = minY; y <= maxY; ++y) {
                adjoin.add(new GridTile(start.x, y));
            }
        } else if (line.isHorizontal) {
            for (x = minX; x <= maxX; ++x) {
                adjoin.add(new GridTile(x, start.y));
            }
        } else {
            for (x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    GridTile tile = new GridTile(x, y);
                    double dist = Math.sqrt(tile.toVec2f().distanceToSqr(line.atX(x)));
                    if (!(dist < 0.75)) continue;
                    adjoin.add(tile);
                }
            }
        }
        adjoin.sort(GridTile.distSort(start));
        ArrayList bridging = Lists.newArrayList();
        for (int i = 1; i < adjoin.size(); ++i) {
            GridTile b;
            GridTile a = (GridTile)adjoin.get(i - 1);
            if (a.manhattanDistance(b = (GridTile)adjoin.get(i)) <= 1) continue;
            bridging.addAll(TileUtils.walkBetween(a, b));
        }
        adjoin.addAll(bridging);
        adjoin.sort(GridTile.distSort(start));
        return adjoin;
    }

    public static List<GridTile> walkBetween(GridTile start, GridTile end) {
        ArrayList walk = Lists.newArrayList();
        GridTile point = start;
        while (point.distance(end) > 0.0) {
            GridTile tile = point;
            Direction step = (Direction)Direction.Plane.HORIZONTAL.stream().sorted((a, b) -> {
                double bD;
                double aD = tile.offset((Direction)a).distance(end);
                return aD < (bD = tile.offset((Direction)b).distance(end)) ? -1 : (aD > bD ? 1 : 0);
            }).findFirst().get();
            point = point.offset(step);
            walk.add(point);
        }
        return walk;
    }
}

