/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.CyclicDungeons;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;

public class CDSoundEvents {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((String)"cydun", (ResourceKey)Registries.SOUND_EVENT);
    private static int tally;
    public static final RegistrySupplier<SoundEvent> WIRING_GUN;

    private static RegistrySupplier<SoundEvent> register(ResourceLocation name) {
        ++tally;
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)name));
    }

    public static void init() {
        SOUND_EVENTS.register();
        CyclicDungeons.LOGGER.info("# Registered {} sound events", (Object)tally);
    }

    static {
        WIRING_GUN = CDSoundEvents.register(Reference.ModInfo.prefix("wiring_gun"));
    }

    private static class SupplierSoundGroup
    extends SoundType {
        private final Supplier<SoundEvent> breakSound;
        private final Supplier<SoundEvent> stepSound;
        private final Supplier<SoundEvent> placeSound;
        private final Supplier<SoundEvent> hitSound;
        private final Supplier<SoundEvent> fallSound;

        public SupplierSoundGroup(float volume, float pitch, Supplier<SoundEvent> breakSound, Supplier<SoundEvent> stepSound, Supplier<SoundEvent> placeSound, Supplier<SoundEvent> hitSound, Supplier<SoundEvent> fallSound) {
            super(volume, pitch, null, null, null, null, null);
            this.breakSound = breakSound;
            this.stepSound = stepSound;
            this.placeSound = placeSound;
            this.hitSound = hitSound;
            this.fallSound = fallSound;
        }

        public SoundEvent getBreakSound() {
            return this.breakSound.get();
        }

        public SoundEvent getStepSound() {
            return this.stepSound.get();
        }

        public SoundEvent getPlaceSound() {
            return this.placeSound.get();
        }

        public SoundEvent getHitSound() {
            return this.hitSound.get();
        }

        public SoundEvent getFallSound() {
            return this.fallSound.get();
        }
    }
}

