/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.CyclicDungeons;
import com.lying.init.CDTiles;
import com.lying.reference.Reference;
import com.lying.worldgen.Tile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class CDTileTags {
    private static int tally = 0;
    private static final Map<ResourceLocation, TileTag> TAGS = new HashMap<ResourceLocation, TileTag>();
    public static final TileTag SOLID_FLOORING = CDTileTags.make("solid_flooring", CDTiles.ID_FLOOR_PRISTINE, CDTiles.ID_FLOOR_ROOM, CDTiles.ID_FLOOR_PASSAGE, CDTiles.ID_HOT_FLOOR, CDTiles.ID_PILLAR_CAP);
    public static final TileTag WET = CDTileTags.make("wet", CDTiles.ID_WET_FLOOR, CDTiles.ID_POOL);
    public static final TileTag DAMP = CDTileTags.make("damp", CDTiles.ID_PUDDLE, CDTiles.ID_WET_FLOOR, CDTiles.ID_POOL);
    public static final TileTag HOT = CDTileTags.make("hot", CDTiles.ID_LAVA, CDTiles.ID_HOT_FLOOR);
    public static final TileTag CEILING = CDTileTags.make("ceiling", CDTiles.ID_PILLAR_CAP);
    public static final TileTag TABLES = CDTileTags.make("tables", CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE);
    public static final TileTag LIGHTING = CDTileTags.make("lighting", CDTiles.ID_LIGHT_FLOOR, CDTiles.ID_LIGHT_TABLE);
    public static final TileTag DECOR = CDTileTags.make("decor", CDTiles.ID_LIGHT_FLOOR, CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE, CDTiles.ID_SEAT, CDTiles.ID_WORKSTATION, CDTiles.ID_TREASURE, CDTiles.ID_PILLAR_BASE);
    public static final TileTag OBTRUSIVE = CDTileTags.make("obtrusive", CDTiles.ID_TABLE, CDTiles.ID_LIGHT_TABLE, CDTiles.ID_SEAT, CDTiles.ID_TREASURE, CDTiles.ID_PILLAR_BASE);
    public static final TileTag TRAPS = CDTileTags.make("traps", new ResourceLocation[0]);

    private static TileTag make(String name, ResourceLocation ... idsIn) {
        return CDTileTags.make(Reference.ModInfo.prefix(name), idsIn);
    }

    public static TileTag make(ResourceLocation registryName, ResourceLocation ... idsIn) {
        ++tally;
        TileTag tag = new TileTag(registryName, idsIn);
        TAGS.put(registryName, tag);
        return tag;
    }

    public Optional<TileTag> get(ResourceLocation registryName) {
        return TAGS.containsKey(registryName) ? Optional.of(TAGS.get(registryName)) : Optional.empty();
    }

    public static void init() {
        CyclicDungeons.LOGGER.info("# Initialised {} tile tags", (Object)tally);
    }

    public static final class TileTag {
        private final ResourceLocation id;
        private final List<ResourceLocation> contents = Lists.newArrayList();

        public TileTag(ResourceLocation id) {
            this.id = id;
        }

        public TileTag(ResourceLocation id, ResourceLocation ... tilesIn) {
            this(id);
            for (ResourceLocation tile : tilesIn) {
                this.add(tile);
            }
        }

        public ResourceLocation id() {
            return this.id;
        }

        public List<ResourceLocation> contents() {
            return this.contents;
        }

        public boolean contains(Tile tileIn) {
            return this.contains(tileIn.registryName());
        }

        public boolean contains(ResourceLocation idIn) {
            return this.contents.stream().anyMatch(arg_0 -> ((ResourceLocation)idIn).equals(arg_0));
        }

        public TileTag add(ResourceLocation id) {
            if (!this.contents.contains(id)) {
                this.contents.add(id);
            }
            return this;
        }
    }
}

