/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.base.Predicates;
import com.lying.CyclicDungeons;
import com.lying.data.CDStructurePools;
import com.lying.init.CDTileTags;
import com.lying.reference.Reference;
import com.lying.worldgen.Tile;
import com.lying.worldgen.TileConditions;
import com.lying.worldgen.TilePredicate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class CDTiles {
    private static final Map<ResourceLocation, Supplier<Tile>> TILES = new HashMap<ResourceLocation, Supplier<Tile>>();
    private static int tally = 0;
    public static final ResourceLocation ID_BLANK = Reference.ModInfo.prefix("blank");
    public static final ResourceLocation ID_AIR = Reference.ModInfo.prefix("air");
    public static final ResourceLocation ID_PASSAGE = Reference.ModInfo.prefix("passage_flag");
    public static final ResourceLocation ID_DOORWAY = Reference.ModInfo.prefix("doorway");
    public static final ResourceLocation ID_FLOOR_PRISTINE = Reference.ModInfo.prefix("floor_room_pristine");
    public static final ResourceLocation ID_FLOOR_ROOM = Reference.ModInfo.prefix("floor_room");
    public static final ResourceLocation ID_FLOOR_PASSAGE = Reference.ModInfo.prefix("floor_passage");
    public static final ResourceLocation ID_PUDDLE = Reference.ModInfo.prefix("puddle");
    public static final ResourceLocation ID_WET_FLOOR = Reference.ModInfo.prefix("wet_floor");
    public static final ResourceLocation ID_POOL = Reference.ModInfo.prefix("pool");
    public static final ResourceLocation ID_TABLE = Reference.ModInfo.prefix("table");
    public static final ResourceLocation ID_SEAT = Reference.ModInfo.prefix("seat");
    public static final ResourceLocation ID_LIGHT_FLOOR = Reference.ModInfo.prefix("light_floor");
    public static final ResourceLocation ID_LIGHT_TABLE = Reference.ModInfo.prefix("light_table");
    public static final ResourceLocation ID_WORKSTATION = Reference.ModInfo.prefix("workstation");
    public static final ResourceLocation ID_PILLAR_BASE = Reference.ModInfo.prefix("pillar_base");
    public static final ResourceLocation ID_PILLAR = Reference.ModInfo.prefix("pillar");
    public static final ResourceLocation ID_PILLAR_CAP = Reference.ModInfo.prefix("pillar_cap");
    public static final ResourceLocation ID_LAVA = Reference.ModInfo.prefix("lava");
    public static final ResourceLocation ID_HOT_FLOOR = Reference.ModInfo.prefix("hot_floor");
    public static final ResourceLocation ID_TREASURE = Reference.ModInfo.prefix("treasure");
    public static final Supplier<Tile> BLANK = CDTiles.register(ID_BLANK, Tile.Builder.of(TilePredicate.fromCondition(TileConditions.never())).asFlag().build());
    public static final Supplier<Tile> AIR = CDTiles.register(ID_AIR, Tile.Builder.of(TilePredicate.fromCondition(TileConditions.not(TileConditions.onBottomLayer()))).asAir().build());
    public static final Supplier<Tile> PASSAGE = CDTiles.register(ID_PASSAGE, Tile.Builder.of(TilePredicate.fromCondition(TileConditions.boundary(Direction.Plane.HORIZONTAL))).asAir().build());
    public static final Supplier<Tile> DOORWAY = CDTiles.register(ID_DOORWAY, Tile.Builder.of(TilePredicate.fromCondition(TileConditions.boundary(Direction.Plane.HORIZONTAL))).asStructure(CDStructurePools.DOORWAY_KEY).build());
    public static final Supplier<Tile> FLOOR_PRISTINE = CDTiles.register(ID_FLOOR_PRISTINE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.nonAdjacent(CDTileTags.DAMP::contains)).build()).asStructure(CDStructurePools.PRISTINE_FLOOR_KEY).freeRotation().build());
    public static final Supplier<Tile> FLOOR = CDTiles.register(ID_FLOOR_ROOM, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.nonAdjacent(CDTileTags.WET::contains)).build()).asStructure(CDStructurePools.FLOOR_KEY).freeRotation().build());
    public static final Supplier<Tile> PUDDLE = CDTiles.register(ID_PUDDLE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.nonAdjacent(t -> t.registryName().equals((Object)ID_POOL))).condition(TileConditions.nonPassage()).build()).asStructure(CDStructurePools.PUDDLE_KEY).freeRotation().build());
    public static final Supplier<Tile> WET_FLOOR = CDTiles.register(ID_WET_FLOOR, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.adjacent(CDTileTags.DAMP::contains)).condition(TileConditions.nonAdjacent(CDTileTags.SOLID_FLOORING::contains)).condition(TileConditions.nonPassage()).build()).asStructure(CDStructurePools.WET_FLOOR_KEY).freeRotation().build());
    public static final Supplier<Tile> POOL = CDTiles.register(ID_POOL, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.adjacent(CDTileTags.WET::contains)).condition(TileConditions.nonAdjacent(CDTileTags.SOLID_FLOORING::contains)).condition(TileConditions.nonPassage()).build()).asBlock(Blocks.WATER.defaultBlockState()).build());
    public static final Supplier<Tile> PASSAGE_FLOOR = CDTiles.register(ID_FLOOR_PASSAGE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).build()).asStructure(CDStructurePools.PASSAGE_FLOOR_KEY).freeRotation().build());
    public static final Supplier<Tile> TABLE = CDTiles.register(ID_TABLE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onFloor()).condition(TileConditions.boundary(Direction.Plane.HORIZONTAL)).condition(TileConditions.avoid(AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 0, 1)), CDTileTags.TABLES::contains)).build()).asStructure(CDStructurePools.TABLE_KEY).freeRotation().build());
    public static final Supplier<Tile> TABLE_LIGHT = CDTiles.register(ID_LIGHT_TABLE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onFloor()).condition(TileConditions.boundary(Direction.Plane.HORIZONTAL)).condition(TileConditions.nonConsecutive()).condition(TileConditions.avoid(AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(-1, 0, -1), (BlockPos)new BlockPos(1, 0, 1)), (Predicate<Tile>)Predicates.or(CDTileTags.TABLES::contains, CDTileTags.LIGHTING::contains))).build()).asStructure(CDStructurePools.TABLE_LIGHT_KEY).freeRotation().build());
    public static final Supplier<Tile> SEAT = CDTiles.register(ID_SEAT, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onFloor()).condition(TileConditions.adjacent(Direction.Plane.HORIZONTAL, CDTileTags.TABLES::contains)).build()).asStructure(CDStructurePools.SEAT_KEY).withRotation(Tile.RotationSupplier.toFaceAdjacent(CDTileTags.TABLES::contains)).build());
    public static final Supplier<Tile> FLOOR_LIGHT = CDTiles.register(ID_LIGHT_FLOOR, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.boundary(Direction.Plane.HORIZONTAL)).condition(TileConditions.onFloor()).condition(TileConditions.nonConsecutive()).condition(TileConditions.avoid(AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(-2, 0, -2), (BlockPos)new BlockPos(2, 0, 2)), CDTileTags.LIGHTING::contains)).condition(TileConditions.nonAdjacent(CDTileTags.TABLES::contains)).build()).asStructure(CDStructurePools.FLOOR_LIGHT_KEY).freeRotation().build());
    public static final Supplier<Tile> WORKSTATION = CDTiles.register(ID_WORKSTATION, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.boundary(Direction.Plane.HORIZONTAL)).condition(TileConditions.onFloor()).condition(TileConditions.nonConsecutive()).condition(TileConditions.avoid(AABB.encapsulatingFullBlocks((BlockPos)new BlockPos(-2, 0, -2), (BlockPos)new BlockPos(2, 0, 2)), CDTileTags.DECOR::contains)).build()).asStructure(CDStructurePools.WORKSTATION_KEY).withRotation(Tile.RotationSupplier.againstBoundary(Tile.RotationSupplier.random())).build());
    public static final Supplier<Tile> PILLAR_BASE = CDTiles.register(ID_PILLAR_BASE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onFloor()).condition(TileConditions.nonBoundary()).condition((tile, pos, set) -> Direction.Plane.HORIZONTAL.stream().filter(d -> set.isBoundary(pos.relative(d), (Direction)d)).count() >= 2L).condition(TileConditions.nonConsecutive()).condition(TileConditions.maxOf(4)).build()).asStructure(CDStructurePools.PILLAR_BASE_KEY).freeRotation().build());
    public static final Supplier<Tile> PILLAR = CDTiles.register(ID_PILLAR, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.nonBoundary()).condition(TileConditions.adjacent(List.of(Direction.DOWN), TileConditions.isAnyOf(ID_PILLAR_BASE, ID_PILLAR))).build()).asStructure(CDStructurePools.PILLAR_KEY).freeRotation().build());
    public static final Supplier<Tile> PILLAR_CAP = CDTiles.register(ID_PILLAR_CAP, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onTopLayer()).condition(TileConditions.adjacent(List.of(Direction.DOWN), TileConditions.isAnyOf(ID_PILLAR_BASE, ID_PILLAR))).build()).asStructure(CDStructurePools.PILLAR_CAP_KEY).freeRotation().build());
    public static final Supplier<Tile> TREASURE = CDTiles.register(ID_TREASURE, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.nonBoundary()).condition(TileConditions.onFloor()).build()).asStructure(CDStructurePools.TREASURE_KEY).freeRotation().build());
    public static final Supplier<Tile> LAVA = CDTiles.register(ID_LAVA, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.nonAdjacent(CDTileTags.DAMP::contains)).condition(TileConditions.adjacent(CDTileTags.HOT::contains)).condition(TileConditions.nonPassage()).build()).asBlock(Blocks.LAVA.defaultBlockState()).build());
    public static final Supplier<Tile> HOT_FLOOR = CDTiles.register(ID_HOT_FLOOR, Tile.Builder.of(TilePredicate.Builder.create().condition(TileConditions.onBottomLayer()).condition(TileConditions.nonAdjacent(CDTileTags.DAMP::contains)).condition(TileConditions.adjacent(CDTileTags.SOLID_FLOORING::contains)).condition(TileConditions.nonPassage()).build()).asStructure(CDStructurePools.HOT_FLOOR_KEY).freeRotation().build());

    private static Supplier<Tile> register(String name, Function<ResourceLocation, Tile> funcIn) {
        return CDTiles.register(Reference.ModInfo.prefix(name), funcIn);
    }

    private static Supplier<Tile> register(ResourceLocation id, Function<ResourceLocation, Tile> funcIn) {
        Supplier<Tile> sup = () -> (Tile)funcIn.apply(id);
        TILES.put(id, sup);
        ++tally;
        return sup;
    }

    public static Optional<Tile> get(String name) {
        return CDTiles.get(name.contains(":") ? ResourceLocation.parse((String)name) : Reference.ModInfo.prefix(name));
    }

    public static Optional<Tile> get(ResourceLocation id) {
        return TILES.containsKey(id) ? Optional.of(TILES.get(id).get()) : Optional.empty();
    }

    public static void init() {
        CyclicDungeons.LOGGER.info("# Initialised {} generator tiles", (Object)tally);
    }
}

