/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.block.IWireableBlock;
import com.lying.init.CDDataComponentTypes;
import com.lying.init.CDSoundEvents;
import com.lying.item.component.WiringComponent;
import com.lying.reference.Reference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WiringGunItem
extends Item {
    public WiringGunItem(Item.Properties settings) {
        super(settings.component((DataComponentType)CDDataComponentTypes.LINK_POS.get(), (Object)WiringComponent.empty()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        ((WiringComponent)stack.get((DataComponentType)CDDataComponentTypes.LINK_POS.get())).addToTooltip(context, tooltip::add, type);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        WiringComponent wiring = (WiringComponent)stack.get((DataComponentType)CDDataComponentTypes.LINK_POS.get());
        BlockPos blockPos = context.getClickedPos();
        Block block = world.getBlockState(blockPos).getBlock();
        MutableComponent blockName = block.getName().withStyle(s -> s.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)blockPos.toShortString()))));
        if (wiring.isWiring()) {
            BlockPos linkPos = wiring.pos().get();
            MutableComponent linkName = world.getBlockState(linkPos).getBlock().getName().withStyle(s -> s.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)linkPos.toShortString()))));
            if (!(block instanceof IWireableBlock) || context.isSecondaryUseActive()) {
                stack.set((DataComponentType)CDDataComponentTypes.LINK_POS.get(), (Object)WiringComponent.empty());
                context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.cancel"), true);
                return InteractionResult.SUCCESS;
            }
            if (!wiring.pos().get().closerThan((Vec3i)blockPos, 32.0)) {
                context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.out_of_range", linkName), true);
                return InteractionResult.PASS;
            }
            IWireableBlock wireable = (IWireableBlock)block;
            if (wireable.acceptWireTo(wiring.type().get(), linkPos, blockPos, world)) {
                stack.set((DataComponentType)CDDataComponentTypes.LINK_POS.get(), (Object)WiringComponent.empty());
                context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.success", linkName, blockName), false);
                WiringGunItem.playSound((LivingEntity)context.getPlayer(), blockPos);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (context.isSecondaryUseActive()) {
                IWireableBlock wireable = IWireableBlock.getWireable(blockPos, world);
                int count = wireable.wireCount(blockPos, world);
                if (count < 1) {
                    context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.wires_cleared.failed", blockName), true);
                    return InteractionResult.PASS;
                }
                wireable.clearWires(blockPos, world);
                context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.wires_cleared.success", count, blockName), false);
                WiringGunItem.playSound((LivingEntity)context.getPlayer(), blockPos);
                return InteractionResult.SUCCESS;
            }
            if (block instanceof IWireableBlock) {
                context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.start", blockName), true);
                stack.set((DataComponentType)CDDataComponentTypes.LINK_POS.get(), (Object)WiringComponent.of(blockPos, IWireableBlock.getWireable(blockPos, world).type()));
                WiringGunItem.playSound((LivingEntity)context.getPlayer(), blockPos);
                return InteractionResult.SUCCESS;
            }
            context.getPlayer().displayClientMessage((Component)Reference.ModInfo.translate("gui", "wiring_gun.failed", blockName), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private static void playSound(LivingEntity player, BlockPos pos) {
        player.getCommandSenderWorld().playSound(null, pos, (SoundEvent)CDSoundEvents.WIRING_GUN.get(), SoundSource.PLAYERS, 1.0f, 0.75f + player.getRandom().nextFloat() * 0.25f);
    }
}

