/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.LineSegment2f;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class Box2f
extends AbstractBox2f {
    private final float minX;
    private final float minY;
    private final float maxX;
    private final float maxY;
    private final Map<Direction, LineSegment2f> edgeMap;

    public Box2f(float minX, float maxX, float minY, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        Vec2 a = new Vec2(minX, minY);
        Vec2 b = new Vec2(maxX, minY);
        Vec2 c = new Vec2(maxX, maxY);
        Vec2 d = new Vec2(minX, maxY);
        this.edgeMap = Map.of(Direction.NORTH, new LineSegment2f(a, b), Direction.EAST, new LineSegment2f(b, c), Direction.SOUTH, new LineSegment2f(c, d), Direction.WEST, new LineSegment2f(d, a));
    }

    @Override
    public String toString() {
        return "Box[" + this.minX + "->" + this.maxX + ", " + this.minY + "->" + this.maxY + "]";
    }

    @Override
    public final float minX() {
        return this.minX;
    }

    @Override
    public final float minY() {
        return this.minY;
    }

    @Override
    public final float maxX() {
        return this.maxX;
    }

    @Override
    public final float maxY() {
        return this.maxY;
    }

    @Override
    public List<LineSegment2f> asEdges() {
        return Lists.newArrayList(this.edgeMap.values());
    }

    @Override
    public List<Vec2> asPoints() {
        return List.of(new Vec2(this.minX, this.minY), new Vec2(this.maxX, this.minY), new Vec2(this.maxX, this.maxY), new Vec2(this.minX, this.maxY));
    }

    @Override
    public boolean intersects(AbstractBox2f box) {
        if (box.asPoints().stream().anyMatch(p -> p.x >= this.minX && p.x <= this.maxX && p.y >= this.minY && p.y <= this.maxY)) {
            return true;
        }
        return super.intersects(box);
    }

    @Override
    public boolean contains(Vec2 vec) {
        return vec.x >= this.minX && vec.x <= this.maxX && vec.y >= this.minY && vec.y <= this.maxY;
    }

    @Override
    public AbstractBox2f move(Vec2 vec) {
        return new Box2f(this.minX + vec.x, this.maxX + vec.x, this.minY + vec.y, this.maxY + vec.y);
    }

    @Override
    public AbstractBox2f mul(float scalar) {
        return new Box2f(this.minX * scalar, this.maxX * scalar, this.minY * scalar, this.maxY * scalar);
    }

    @Override
    public AbstractBox2f grow(float v) {
        return new Box2f(this.minX - v, this.maxX + v, this.minY - v, this.maxY + v);
    }

    @Nullable
    public LineSegment2f getEdge(Direction dir) {
        return this.edgeMap.getOrDefault(dir, null);
    }

    @Nullable
    public Direction identifyEdge(LineSegment2f faceIn) {
        for (Direction edge : Direction.Plane.HORIZONTAL) {
            if (!faceIn.equals(this.getEdge(edge))) continue;
            return edge;
        }
        return null;
    }
}

