/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class CDUtils {
    private static final Map<DyeColor, Pair<Block, Block>> DYE_TO_CONCRETE = new HashMap<DyeColor, Pair<Block, Block>>();

    public static Block dyeToConcretePowder(DyeColor color) {
        return (Block)DYE_TO_CONCRETE.get(color).getLeft();
    }

    public static Block dyeToConcrete(DyeColor color) {
        return (Block)DYE_TO_CONCRETE.get(color).getRight();
    }

    @Nullable
    public static <T> T selectFromWeightedList(List<Pair<T, Float>> weightedList, float selector) {
        if (weightedList.isEmpty()) {
            return null;
        }
        if (weightedList.size() == 1) {
            return (T)weightedList.get(0).getLeft();
        }
        float totalWeight = 0.0f;
        for (float weight : weightedList.stream().map(Pair::getRight).map(Math::abs).filter(w -> w.floatValue() > 0.0f).toList()) {
            totalWeight += weight;
        }
        ArrayList percentileList = Lists.newArrayList();
        for (Pair<T, Float> entry : weightedList) {
            percentileList.add(Pair.of((Object)entry.getLeft(), (Object)Float.valueOf(((Float)entry.getRight()).floatValue() / totalWeight)));
        }
        percentileList.sort((a, b) -> ((Float)a.getRight()).floatValue() < ((Float)b.getRight()).floatValue() ? -1 : (((Float)a.getRight()).floatValue() > ((Float)b.getRight()).floatValue() ? 1 : 0));
        float lowerBound = 0.0f;
        for (int i = 0; i < percentileList.size(); ++i) {
            Pair entry = (Pair)percentileList.get(i);
            float upperBound = lowerBound + ((Float)entry.getRight()).floatValue();
            if (selector >= lowerBound && selector <= upperBound) {
                return (T)entry.getLeft();
            }
            lowerBound = upperBound;
        }
        return (T)((Pair)percentileList.getLast()).getLeft();
    }

    public static Vec2 rotate(Vec2 a, float radians) {
        if ((double)radians == Math.toRadians(90.0)) {
            return new Vec2(-a.y, a.x);
        }
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return new Vec2((float)((double)a.x * cos - (double)a.y * sin), (float)((double)a.x * sin + (double)a.y * cos));
    }

    static {
        DYE_TO_CONCRETE.put(DyeColor.BLACK, (Pair<Block, Block>)Pair.of((Object)Blocks.BLACK_CONCRETE_POWDER, (Object)Blocks.BLACK_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.BLUE, (Pair<Block, Block>)Pair.of((Object)Blocks.BLUE_CONCRETE_POWDER, (Object)Blocks.BLUE_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.BROWN, (Pair<Block, Block>)Pair.of((Object)Blocks.BROWN_CONCRETE_POWDER, (Object)Blocks.BROWN_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.CYAN, (Pair<Block, Block>)Pair.of((Object)Blocks.CYAN_CONCRETE_POWDER, (Object)Blocks.CYAN_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.GRAY, (Pair<Block, Block>)Pair.of((Object)Blocks.GRAY_CONCRETE_POWDER, (Object)Blocks.GRAY_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.GREEN, (Pair<Block, Block>)Pair.of((Object)Blocks.GREEN_CONCRETE_POWDER, (Object)Blocks.GREEN_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.LIGHT_BLUE, (Pair<Block, Block>)Pair.of((Object)Blocks.LIGHT_BLUE_CONCRETE_POWDER, (Object)Blocks.LIGHT_BLUE_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.LIGHT_GRAY, (Pair<Block, Block>)Pair.of((Object)Blocks.LIGHT_GRAY_CONCRETE_POWDER, (Object)Blocks.LIGHT_GRAY_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.LIME, (Pair<Block, Block>)Pair.of((Object)Blocks.LIME_CONCRETE_POWDER, (Object)Blocks.LIME_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.MAGENTA, (Pair<Block, Block>)Pair.of((Object)Blocks.MAGENTA_CONCRETE_POWDER, (Object)Blocks.MAGENTA_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.ORANGE, (Pair<Block, Block>)Pair.of((Object)Blocks.ORANGE_CONCRETE_POWDER, (Object)Blocks.ORANGE_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.PINK, (Pair<Block, Block>)Pair.of((Object)Blocks.PINK_CONCRETE_POWDER, (Object)Blocks.PINK_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.PURPLE, (Pair<Block, Block>)Pair.of((Object)Blocks.PURPLE_CONCRETE_POWDER, (Object)Blocks.PURPLE_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.RED, (Pair<Block, Block>)Pair.of((Object)Blocks.RED_CONCRETE_POWDER, (Object)Blocks.RED_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.WHITE, (Pair<Block, Block>)Pair.of((Object)Blocks.WHITE_CONCRETE_POWDER, (Object)Blocks.WHITE_CONCRETE));
        DYE_TO_CONCRETE.put(DyeColor.YELLOW, (Pair<Block, Block>)Pair.of((Object)Blocks.YELLOW_CONCRETE_POWDER, (Object)Blocks.YELLOW_CONCRETE));
    }
}

