/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.utility.AbstractBox2f;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec2;

public class CompoundBox2f
extends AbstractBox2f {
    private List<AbstractBox2f> boxes = Lists.newArrayList();

    @Override
    public String toString() {
        return "CompBox[" + this.boxes.size() + "]";
    }

    public CompoundBox2f add(AbstractBox2f box) {
        this.boxes.add(box);
        return this;
    }

    @Override
    public float minX() {
        float minX = Float.MAX_VALUE;
        for (AbstractBox2f b : this.boxes) {
            if (!(b.minX() < minX)) continue;
            minX = b.minX();
        }
        return minX;
    }

    @Override
    public float minY() {
        float minY = Float.MAX_VALUE;
        for (AbstractBox2f b : this.boxes) {
            if (!(b.minY() < minY)) continue;
            minY = b.minY();
        }
        return minY;
    }

    @Override
    public float maxX() {
        float maxX = Float.MIN_VALUE;
        for (AbstractBox2f b : this.boxes) {
            if (!(b.maxX() > maxX)) continue;
            maxX = b.maxX();
        }
        return maxX;
    }

    @Override
    public float maxY() {
        float maxY = Float.MIN_VALUE;
        for (AbstractBox2f b : this.boxes) {
            if (!(b.maxY() > maxY)) continue;
            maxY = b.maxY();
        }
        return maxY;
    }

    @Override
    public boolean contains(Vec2 vec) {
        return this.boxes.stream().anyMatch(b -> b.contains(vec));
    }

    @Override
    public List<LineSegment2f> asEdges() {
        ArrayList edges = Lists.newArrayList();
        this.boxes.forEach(b -> edges.addAll(b.asEdges()));
        return edges;
    }

    @Override
    public List<Vec2> asPoints() {
        ArrayList points = Lists.newArrayList();
        this.boxes.stream().map(AbstractBox2f::asPoints).forEach(points::addAll);
        return points;
    }

    public List<AbstractBox2f> asBoxes() {
        return this.boxes;
    }

    @Override
    public AbstractBox2f move(Vec2 vec) {
        CompoundBox2f box = new CompoundBox2f();
        this.boxes.stream().map(b -> b.move(vec)).forEach(box::add);
        return box;
    }

    @Override
    public AbstractBox2f mul(float val) {
        CompoundBox2f box = new CompoundBox2f();
        this.boxes.stream().map(b -> b.mul(val)).forEach(box::add);
        return box;
    }

    @Override
    public AbstractBox2f grow(float val) {
        CompoundBox2f box = new CompoundBox2f();
        this.boxes.stream().map(b -> b.grow(val)).forEach(box::add);
        return box;
    }
}

