/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugLogger {
    private final Logger logger;
    private boolean isActive = true;

    public DebugLogger(String sub) {
        this.logger = LoggerFactory.getLogger((String)("cydun_" + sub.toLowerCase()));
    }

    public static DebugLogger of(String sub) {
        return new DebugLogger(sub);
    }

    public DebugLogger setActive(boolean bool) {
        this.isActive = bool;
        return this;
    }

    public DebugLogger disable() {
        return this.setActive(false);
    }

    public DebugLogger enable() {
        return this.setActive(true);
    }

    public void info(String msg) {
        if (!this.isActive) {
            return;
        }
        this.logger.info(msg);
    }

    public void info(String format, Object ... args) {
        if (!this.isActive) {
            return;
        }
        this.logger.info(format, args);
    }

    public void error(String msg) {
        this.logger.error(" !! " + msg);
    }

    public void error(String format, Object ... args) {
        this.logger.error(" !! " + format, args);
    }

    public void warn(String msg) {
        if (!this.isActive) {
            return;
        }
        this.logger.warn(" ? " + msg);
    }

    public void warn(String format, Object ... args) {
        if (!this.isActive) {
            return;
        }
        this.logger.warn(" ? " + format, args);
    }

    public void forceWarn(String msg) {
        this.logger.warn(" ?? " + msg);
    }

    public void forceWarn(String format, Object ... args) {
        this.logger.warn(" ?? " + format, args);
    }
}

