/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.google.common.collect.Lists;
import com.lying.blueprint.BlueprintRoom;
import com.lying.init.CDLoggers;
import com.lying.utility.Box2f;
import com.lying.utility.DebugLogger;
import com.lying.utility.LineSegment2f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LineUtils {
    public static final DebugLogger LOGGER = CDLoggers.PLANAR;
    private static final int TILE_SIZE = 2;

    public static List<LineSegment2f> simplifyLines(List<LineSegment2f> linesIn) {
        if (linesIn.size() <= 1) {
            return linesIn;
        }
        ArrayList output = Lists.newArrayList();
        boolean anyMerged = false;
        for (int i = 1; i < linesIn.size(); ++i) {
            LineSegment2f b;
            LineSegment2f a = linesIn.get(i - 1);
            LineSegment2f merged = LineUtils.mergeLines(a, b = linesIn.get(i));
            if (merged == null) {
                output.add(a);
                continue;
            }
            output.add(merged);
            anyMerged = true;
        }
        return anyMerged ? LineUtils.simplifyLines(output) : linesIn;
    }

    @Nullable
    public static LineSegment2f mergeLines(LineSegment2f a, LineSegment2f b) {
        if (!a.linksTo(b) || !a.alignsWith(b)) {
            return null;
        }
        ArrayList points = Lists.newArrayList();
        for (Vec2 point : new Vec2[]{a.getLeft(), a.getRight(), b.getLeft(), b.getRight()}) {
            if (points.contains(point)) {
                points.remove(point);
                continue;
            }
            points.add(point);
        }
        return new LineSegment2f((Vec2)points.getFirst(), (Vec2)points.getLast());
    }

    public static List<LineSegment2f> trialLines(BlueprintRoom start, BlueprintRoom end) {
        Vec2 endDoor;
        Box2f startBox = (Box2f)start.worldBounds();
        Box2f endBox = (Box2f)end.worldBounds();
        Pair<Direction, Vec2> startPoints = LineUtils.findClosestTile(startBox, end.position());
        Pair<Direction, Vec2> endPoints = LineUtils.findClosestTile(endBox, start.position());
        Vec2 startDoor = (Vec2)startPoints.getRight();
        LineSegment2f startToEnd = new LineSegment2f(startDoor, endDoor = (Vec2)endPoints.getRight());
        if (startToEnd.isStraightLine()) {
            return List.of(startToEnd);
        }
        Direction startExit = (Direction)startPoints.getLeft();
        Direction endExit = (Direction)endPoints.getLeft();
        Vec2 outOfStart = startDoor.add(new Vec2((float)startExit.getStepX(), (float)startExit.getStepZ()).scale(3.0f));
        Vec2 outOfEnd = endDoor.add(new Vec2((float)endExit.getStepX(), (float)endExit.getStepZ()).scale(3.0f));
        if (outOfStart.distanceToSqr(endDoor) == startDoor.distanceToSqr(outOfStart)) {
            return List.of(new LineSegment2f(startDoor, outOfStart), new LineSegment2f(outOfStart, endDoor));
        }
        return List.of(new LineSegment2f(startDoor, outOfStart), new LineSegment2f(outOfStart, outOfEnd), new LineSegment2f(outOfEnd, endDoor));
    }

    private static Pair<Direction, Vec2> findClosestTile(Box2f bounds, Vector2i target) {
        Vec2 destination = new Vec2((float)target.x, (float)target.y);
        float minDist = Float.MAX_VALUE;
        Pair best = null;
        block4: for (Direction face : Direction.Plane.HORIZONTAL) {
            LineSegment2f edge = bounds.getEdge(face);
            int tileLength = (int)(edge.length() / 2.0f);
            Vec2 offset = new Vec2((float)face.getStepX(), (float)face.getStepZ()).scale(-1.0f);
            Vec2 dir = edge.direction().normalized();
            switch (tileLength) {
                case 1: 
                case 2: {
                    Vec2 p2 = edge.left.add(dir.scale(1.0f));
                    float d2 = p2.add(offset).distanceToSqr(destination);
                    if (!(d2 < minDist) && best != null) continue block4;
                    best = Pair.of((Object)face, (Object)p2);
                    minDist = d2;
                    continue block4;
                }
                case 3: {
                    Vec2 p3 = edge.left.add(edge.direction().scale(0.5f));
                    float d3 = p3.add(offset).distanceToSqr(destination);
                    if (!(d3 < minDist) && best != null) continue block4;
                    best = Pair.of((Object)face, (Object)p3);
                    minDist = d3;
                    continue block4;
                }
            }
            for (int i = 1; i < tileLength - 1; ++i) {
                Vec2 pN = edge.left.add(dir.scale(((float)i + 0.5f) * 2.0f));
                float dN = pN.add(offset).distanceToSqr(destination);
                if (!(dN < minDist) && best != null) continue;
                best = Pair.of((Object)face, (Object)pN);
                minDist = dN;
            }
        }
        return best;
    }
}

